/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.dialog;

import com.jidesoft.dialog.AbstractDialogPage;
import com.jidesoft.dialog.ButtonPanel;
import com.jidesoft.dialog.ButtonResources;
import com.jidesoft.dialog.DialogPageListCellRenderer;
import com.jidesoft.dialog.DialogPageTreeCellRenderer;
import com.jidesoft.dialog.PageList;
import com.jidesoft.dialog.ScrollableButtonPanel;
import com.jidesoft.dialog.StandardDialogPane;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.JideButton;
import com.jidesoft.swing.JideScrollPane;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class MultiplePageDialogPane
extends StandardDialogPane {
    public static final int TAB_STYLE = 0;
    public static final int TREE_STYLE = 1;
    public static final int LIST_STYLE = 2;
    public static final int ICON_STYLE = 3;
    private int _style;
    private PageList _pageList;
    private JComponent _indexPanel;
    private JComponent _pagesPanel;
    private CardLayout _cardLayout;
    private Map _titleNodeMap;
    private JButton _okButton;
    private JButton _cancelButton;
    private JButton _applyButton;
    private AbstractAction _okAction;
    private AbstractAction _cancelAction;
    private TreeCellRenderer _treeCellRenderer;
    private ListCellRenderer _listCellRenderer;
    private JTabbedPane _tabbedPane;
    private String _initialPageTitle;
    public JTree _tree;

    public MultiplePageDialogPane() throws HeadlessException {
        this(0);
    }

    public MultiplePageDialogPane(int style) {
        this.setStyle(style);
    }

    @Override
    public JComponent createBannerPanel() {
        return null;
    }

    @Override
    public JComponent createContentPanel() {
        this._indexPanel = this.createIndexPanel();
        this._pagesPanel = this.createPagesPanel();
        if (this._pageList.getPageCount() > 0) {
            if (this.getInitialPageTitle() != null) {
                this.setCurrentPage(this.getInitialPageTitle());
            } else {
                this.setCurrentPage(this._pageList.getPage(0));
            }
        }
        return this.setupContentPanel(this._indexPanel, this._pagesPanel);
    }

    protected JComponent setupContentPanel(JComponent indexPanel, JComponent pagesPanel) {
        JPanel middlePanel = new JPanel(new BorderLayout());
        if (indexPanel != null) {
            middlePanel.add((Component)indexPanel, "Before");
        }
        if (pagesPanel != null) {
            middlePanel.add((Component)pagesPanel, "Center");
        }
        return middlePanel;
    }

    @Override
    public ButtonPanel createButtonPanel() {
        ButtonPanel buttonPanel = new ButtonPanel();
        Locale l = this.getLocale();
        this._okButton = new JButton(UIDefaultsLookup.getString("OptionPane.okButtonText", l));
        this._cancelButton = new JButton(UIDefaultsLookup.getString("OptionPane.cancelButtonText", l));
        this._applyButton = new JButton();
        this._okButton.setName("OK");
        this._cancelButton.setName("CANCEL");
        this._applyButton.setName("APPLY");
        buttonPanel.addButton((AbstractButton)this._okButton, "AFFIRMATIVE");
        buttonPanel.addButton((AbstractButton)this._cancelButton, "CANCEL");
        buttonPanel.addButton((AbstractButton)this._applyButton, "ALTERNATIVE");
        this._okButton.setAction(this.getOKAction());
        this._cancelButton.setAction(this.getCancelAction());
        this._applyButton.setAction(new AbstractAction(ButtonResources.getResourceBundle(Locale.getDefault()).getString("Button.apply")){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MultiplePageDialogPane.this.getCurrentPage() != null) {
                    MultiplePageDialogPane.this.getCurrentPage().fireButtonEvent(3302, "APPLY");
                }
            }
        });
        this._applyButton.setMnemonic(ButtonResources.getResourceBundle(Locale.getDefault()).getString("Button.apply.mnemonic").charAt(0));
        this._applyButton.setEnabled(false);
        this.setDefaultCancelAction(this._cancelButton.getAction());
        this.setDefaultAction(this._okButton.getAction());
        return buttonPanel;
    }

    public JButton getOkButton() {
        return this._okButton;
    }

    public JButton getCancelButton() {
        return this._cancelButton;
    }

    public JButton getApplyButton() {
        return this._applyButton;
    }

    public void setCancelAction(AbstractAction cancelAction) {
        if (cancelAction == null) {
            throw new IllegalArgumentException("cancelAction cannot be null");
        }
        this._cancelAction = cancelAction;
        this.setDefaultCancelAction(cancelAction);
        if (this._cancelButton != null) {
            this._cancelButton.setAction(cancelAction);
        }
    }

    public AbstractAction getCancelAction() {
        return this._cancelAction;
    }

    public void setOKAction(AbstractAction okAction) {
        if (okAction == null) {
            throw new IllegalArgumentException("cancelAction cannot be null");
        }
        this._okAction = okAction;
        this.setDefaultAction(okAction);
        if (this._okAction != null) {
            this._okButton.setAction(okAction);
        }
    }

    public AbstractAction getOKAction() {
        return this._okAction;
    }

    protected JComponent createPagesPanel() {
        if (this._style == 0) {
            this._tabbedPane = this.createTabbedPane();
            this._tabbedPane.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    Component selectedComponent = MultiplePageDialogPane.this._tabbedPane.getSelectedComponent();
                    if (selectedComponent instanceof AbstractDialogPage) {
                        MultiplePageDialogPane.this.setCurrentPage((AbstractDialogPage)selectedComponent, MultiplePageDialogPane.this._tabbedPane);
                    }
                }
            });
            int i = 0;
            while (i < this._pageList.getPageCount()) {
                AbstractDialogPage page = this._pageList.getPage(i);
                page.addButtonListener(this.getButtonPanel());
                this._tabbedPane.addTab(page.getTitle(), page.getIcon(), page, page.getDescription());
                this._tabbedPane.setEnabledAt(i, page.isPageEnabled());
                final int index = i++;
                page.addPropertyChangeListener(new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        if ("enabled".equals(evt.getPropertyName())) {
                            MultiplePageDialogPane.this._tabbedPane.setEnabledAt(index, Boolean.TRUE.equals(evt.getNewValue()));
                        } else if ("icon".equals(evt.getPropertyName())) {
                            MultiplePageDialogPane.this._tabbedPane.setIconAt(index, (Icon)evt.getNewValue());
                        } else if ("title".equals(evt.getPropertyName())) {
                            MultiplePageDialogPane.this._tabbedPane.setTitleAt(index, (String)evt.getNewValue());
                        } else if ("description".equals(evt.getPropertyName())) {
                            MultiplePageDialogPane.this._tabbedPane.setToolTipTextAt(index, (String)evt.getNewValue());
                        }
                    }
                });
            }
            this._pageList.addListDataListener(new ListDataListener(){

                @Override
                public void intervalAdded(ListDataEvent e) {
                    for (int i = e.getIndex0(); i <= e.getIndex1(); ++i) {
                        AbstractDialogPage page = MultiplePageDialogPane.this._pageList.getPage(i);
                        MultiplePageDialogPane.this._tabbedPane.insertTab(page.getTitle(), page.getIcon(), page, page.getDescription(), i);
                    }
                }

                @Override
                public void intervalRemoved(ListDataEvent e) {
                    for (int i = e.getIndex1(); i >= e.getIndex0(); --i) {
                        MultiplePageDialogPane.this._tabbedPane.removeTabAt(i);
                    }
                }

                @Override
                public void contentsChanged(ListDataEvent e) {
                }
            });
            return this._tabbedPane;
        }
        final JPanel pagesPanel = new JPanel();
        this._cardLayout = new CardLayout();
        pagesPanel.setLayout(this._cardLayout);
        for (int i = 0; i < this._pageList.getPageCount(); ++i) {
            AbstractDialogPage page = this._pageList.getPage(i);
            page.addButtonListener(this.getButtonPanel());
            page.setName(page.getFullTitle());
            page.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if ("title".equals(evt.getPropertyName())) {
                        for (int j = 0; j < pagesPanel.getComponentCount(); ++j) {
                            Component c = pagesPanel.getComponent(j);
                            Object source = evt.getSource();
                            if (!(source instanceof AbstractDialogPage) || c != source) continue;
                            pagesPanel.remove(j);
                            String fullTitle = ((AbstractDialogPage)source).getFullTitle();
                            pagesPanel.add((AbstractDialogPage)source, fullTitle, j);
                            ((AbstractDialogPage)source).setName(fullTitle);
                            MultiplePageDialogPane.this.getIndexPanel().repaint();
                            break;
                        }
                    }
                }
            });
            pagesPanel.add((Component)page, page.getFullTitle());
        }
        this._pageList.addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent e) {
                for (int i = e.getIndex0(); i <= e.getIndex1(); ++i) {
                    AbstractDialogPage page = MultiplePageDialogPane.this._pageList.getPage(i);
                    page.setName(page.getFullTitle());
                    pagesPanel.add(page, page.getFullTitle(), i);
                }
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
                for (int i = e.getIndex1(); i >= e.getIndex0(); --i) {
                    pagesPanel.remove(i);
                }
            }

            private void dumpPagesPanel() {
                for (int i = 0; i < pagesPanel.getComponentCount(); ++i) {
                    System.out.println("" + i + ": " + pagesPanel.getComponent(i).getName());
                }
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                Object o;
                if (e.getSource() instanceof PageList && (o = ((PageList)e.getSource()).getSelectedItem()) instanceof AbstractDialogPage) {
                    MultiplePageDialogPane.this.setCurrentPage((AbstractDialogPage)o);
                }
            }
        });
        return pagesPanel;
    }

    protected JTabbedPane createTabbedPane() {
        return new JTabbedPane(1);
    }

    public JComponent createIndexPanel() {
        switch (this._style) {
            case 3: {
                return this.createIconPanel();
            }
            case 2: {
                return this.createListPanel();
            }
            case 1: {
                return this.createTreePanel();
            }
        }
        return null;
    }

    public void setPageList(PageList pageList) {
        this._pageList = pageList;
    }

    public PageList getPageList() {
        return this._pageList;
    }

    public AbstractDialogPage getCurrentPage() {
        return this._pageList.getCurrentPage();
    }

    protected void setCurrentPage(String pageTitle) {
        if (this._pageList != null) {
            this.setCurrentPage(this._pageList.getPageByFullTitle(pageTitle));
        }
    }

    protected void setCurrentPage(AbstractDialogPage currentPage) {
        this.setCurrentPage(currentPage, null);
    }

    protected void setCurrentPage(AbstractDialogPage currentPage, Object source) {
        if (!this._pageList.setCurrentPage(currentPage, source)) {
            return;
        }
        if (currentPage != null) {
            this.showCurrentPage(currentPage);
        }
    }

    protected void showCurrentPage(AbstractDialogPage currentPage) {
        if (this.getStyle() == 0) {
            this._tabbedPane.setSelectedComponent(currentPage);
        } else {
            this._cardLayout.show(this._pagesPanel, currentPage.getFullTitle());
        }
        if (currentPage != null) {
            currentPage.focusDefaultFocusComponent();
        }
    }

    private JComponent createTreePanel() {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("", true);
        this._titleNodeMap = new HashMap((int)((double)this._pageList.getPageCount() * 0.75));
        for (int i = 0; i < this._pageList.getPageCount(); ++i) {
            AbstractDialogPage dialogPage = this._pageList.getPage(i);
            this.addPage(dialogPage, root, false);
        }
        this._tree = this.createTree(root);
        this.configureTree(this._tree);
        this._pageList.addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent e) {
                for (int i = e.getIndex0(); i <= e.getIndex1(); ++i) {
                    AbstractDialogPage dialogPage = MultiplePageDialogPane.this._pageList.getPage(i);
                    MultiplePageDialogPane.this.addPage(dialogPage, (DefaultMutableTreeNode)MultiplePageDialogPane.this._tree.getModel().getRoot(), true);
                }
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
                Set set = MultiplePageDialogPane.this._titleNodeMap.keySet();
                Vector<String> toBeRemoved = new Vector<String>();
                for (Object k : set) {
                    DefaultMutableTreeNode treeNode;
                    String title = (String)k;
                    if (MultiplePageDialogPane.this._pageList.getPageByFullTitle(title) != null || (treeNode = (DefaultMutableTreeNode)MultiplePageDialogPane.this._titleNodeMap.get(title)) == null) continue;
                    toBeRemoved.add(title);
                    DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)treeNode.getParent();
                    if (parentNode == null) continue;
                    int index = parentNode.getIndex(treeNode);
                    parentNode.remove(treeNode);
                    ((DefaultTreeModel)MultiplePageDialogPane.this._tree.getModel()).nodesWereRemoved(parentNode, new int[]{index}, new Object[]{treeNode});
                }
                for (Object object : toBeRemoved) {
                    MultiplePageDialogPane.this._titleNodeMap.remove(object);
                }
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                TreeNode node;
                if (e.getIndex0() == -1 && e.getIndex1() == -1 && e.getType() == 0 && MultiplePageDialogPane.this._titleNodeMap != null && MultiplePageDialogPane.this._pageList.getCurrentPage() != null && (node = (TreeNode)MultiplePageDialogPane.this._titleNodeMap.get(MultiplePageDialogPane.this._pageList.getCurrentPage().getFullTitle())) != null) {
                    ArrayList<TreeNode> list = new ArrayList<TreeNode>();
                    while (node != null) {
                        list.add(0, node);
                        node = node.getParent();
                    }
                    TreePath treePath = new TreePath(list.toArray(new TreeNode[list.size()]));
                    MultiplePageDialogPane.this._tree.getSelectionModel().setSelectionPath(treePath);
                }
            }
        });
        JPanel indexPanel = new JPanel(new BorderLayout());
        indexPanel.add((Component)new JScrollPane(this._tree), "Center");
        return indexPanel;
    }

    protected JTree createTree(DefaultMutableTreeNode root) {
        UIManager.put("Tree.hash", Color.white);
        return new JTree(root);
    }

    protected void configureTree(final JTree tree) {
        tree.setToggleClickCount(1);
        tree.setCellRenderer(this.createTreeCellRenderer());
        tree.setRootVisible(false);
        tree.setShowsRootHandles(false);
        tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                Object userObject;
                if (tree.getSelectionPath() == null) {
                    return;
                }
                DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)tree.getSelectionPath().getLastPathComponent();
                while (!treeNode.isLeaf()) {
                    final DefaultMutableTreeNode tn = treeNode;
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            tree.expandPath(new TreePath(tn.getPath()));
                        }
                    };
                    SwingUtilities.invokeLater(runnable);
                    treeNode = (DefaultMutableTreeNode)treeNode.getChildAt(0);
                }
                if (treeNode != null && (userObject = treeNode.getUserObject()) instanceof AbstractDialogPage && !userObject.equals(MultiplePageDialogPane.this.getCurrentPage())) {
                    MultiplePageDialogPane.this.setCurrentPage((AbstractDialogPage)userObject, tree);
                    if (MultiplePageDialogPane.this.getCurrentPage() != userObject) {
                        // empty if block
                    }
                }
            }
        });
    }

    private void addPage(AbstractDialogPage dialogPage, DefaultMutableTreeNode root, boolean fireEvent) {
        if (dialogPage == null) {
            return;
        }
        if (dialogPage.getParentPage() == null) {
            DefaultMutableTreeNode treeNode = new DefaultMutableTreeNode(dialogPage);
            this._titleNodeMap.put(dialogPage.getFullTitle(), treeNode);
            root.add(treeNode);
            if (fireEvent) {
                ((DefaultTreeModel)this._tree.getModel()).nodesWereInserted(root, new int[]{root.getIndex(treeNode)});
            }
        } else {
            DefaultMutableTreeNode treeNode = new DefaultMutableTreeNode(dialogPage);
            this._titleNodeMap.put(dialogPage.getFullTitle(), treeNode);
            DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)this._titleNodeMap.get(dialogPage.getParentPage().getFullTitle());
            if (parentNode != null) {
                parentNode.add(treeNode);
                if (fireEvent) {
                    ((DefaultTreeModel)this._tree.getModel()).nodesWereInserted(parentNode, new int[]{parentNode.getIndex(treeNode)});
                }
            }
        }
    }

    private void removePage(AbstractDialogPage dialogPage, DefaultMutableTreeNode root, boolean fireEvent) {
        if (dialogPage == null) {
            return;
        }
        DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)this._titleNodeMap.get(dialogPage.getFullTitle());
        if (treeNode == null) {
            return;
        }
        if (treeNode.getChildCount() > 0) {
            throw new IllegalArgumentException("Please remove all children pages before removing parent page \"" + dialogPage.getFullTitle() + "\"");
        }
        this._titleNodeMap.remove(dialogPage.getFullTitle());
        if (dialogPage.getParentPage() == null) {
            int index = root.getIndex(treeNode);
            root.remove(treeNode);
            if (fireEvent) {
                ((DefaultTreeModel)this._tree.getModel()).nodesWereRemoved(root, new int[]{index}, new Object[]{treeNode});
            }
        } else {
            DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)this._titleNodeMap.get(dialogPage.getParentPage().getFullTitle());
            if (parentNode != null) {
                int index = parentNode.getIndex(treeNode);
                parentNode.remove(treeNode);
                if (fireEvent) {
                    ((DefaultTreeModel)this._tree.getModel()).nodesWereRemoved(parentNode, new int[]{index}, new Object[]{treeNode});
                }
            }
        }
    }

    private JComponent createListPanel() {
        final DefaultListModel<AbstractDialogPage> listModel = new DefaultListModel<AbstractDialogPage>();
        for (int i = 0; i < this._pageList.getPageCount(); ++i) {
            AbstractDialogPage optionsPanel = this._pageList.getPage(i);
            listModel.addElement(optionsPanel);
        }
        final JList list = this.createList(listModel);
        if (list.getModel().getSize() > 0) {
            list.setSelectedIndex(0);
        }
        list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (list.getSelectedValue() == MultiplePageDialogPane.this.getCurrentPage()) {
                    return;
                }
                if (!e.getValueIsAdjusting()) {
                    AbstractDialogPage page = (AbstractDialogPage)list.getSelectedValue();
                    if (page != null) {
                        MultiplePageDialogPane.this.setCurrentPage(page, list);
                        if (MultiplePageDialogPane.this.getCurrentPage() != page) {
                            list.setSelectedValue(MultiplePageDialogPane.this.getCurrentPage(), true);
                        }
                    } else {
                        list.setSelectedIndex(e.getLastIndex());
                    }
                }
            }
        });
        list.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 10));
        this._pageList.addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent e) {
                for (int i = e.getIndex0(); i <= e.getIndex1(); ++i) {
                    AbstractDialogPage optionsPanel = MultiplePageDialogPane.this._pageList.getPage(i);
                    listModel.add(i, optionsPanel);
                }
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
                for (int i = e.getIndex1(); i >= e.getIndex0(); --i) {
                    listModel.remove(i);
                }
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                if (e.getIndex0() == -1 && e.getIndex1() == -1 && e.getType() == 0) {
                    int index = MultiplePageDialogPane.this._pageList.getPageIndexByFullTitle(MultiplePageDialogPane.this._pageList.getCurrentPage().getFullTitle());
                    list.setSelectedIndex(index);
                }
            }
        });
        JPanel indexPanel = new JPanel(new BorderLayout(4, 4));
        indexPanel.add((Component)new JideScrollPane(list), "Center");
        indexPanel.setOpaque(false);
        return indexPanel;
    }

    protected JList createList(DefaultListModel listModel) {
        JList list = new JList(listModel);
        list.setCellRenderer(this.createListCellRenderer());
        return list;
    }

    protected JComponent createIconPanel() {
        final ButtonPanel buttonsPanel = this.createIconButtonPanel();
        buttonsPanel.setGroupGap(0);
        buttonsPanel.setButtonGap(0);
        final ButtonGroup group = new ButtonGroup();
        for (int i = 0; i < this._pageList.getPageCount(); ++i) {
            final AbstractDialogPage optionsPanel = this._pageList.getPage(i);
            final JideButton button = this.createIconButton(optionsPanel.getTitle(), optionsPanel.getIcon());
            button.setToolTipText(optionsPanel.getDescription());
            button.setEnabled(optionsPanel.isPageEnabled());
            button.addActionListener(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MultiplePageDialogPane.this.setCurrentPage(optionsPanel, buttonsPanel);
                    if (MultiplePageDialogPane.this.getCurrentPage() == optionsPanel) {
                        group.setSelected(button.getModel(), true);
                    }
                }
            });
            optionsPanel.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if ("enabled".equals(evt.getPropertyName())) {
                        button.setEnabled(Boolean.TRUE.equals(evt.getNewValue()));
                    } else if ("icon".equals(evt.getPropertyName())) {
                        button.setIcon((Icon)evt.getNewValue());
                    } else if ("title".equals(evt.getPropertyName())) {
                        button.setText((String)evt.getNewValue());
                    } else if ("description".equals(evt.getPropertyName())) {
                        button.setToolTipText((String)evt.getNewValue());
                    }
                }
            });
            buttonsPanel.addButton(button);
            group.add(button);
            if (i != 0) continue;
            group.setSelected(button.getModel(), true);
        }
        buttonsPanel.setOpaque(false);
        buttonsPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JScrollPane pane = new JScrollPane(buttonsPanel){

            @Override
            public Dimension getPreferredSize() {
                if (buttonsPanel.getAlignment() == 1 || buttonsPanel.getAlignment() == 3) {
                    return new Dimension(buttonsPanel.getPreferredSize().width + this.getVerticalScrollBar().getPreferredSize().width, 5);
                }
                return new Dimension(5, buttonsPanel.getPreferredSize().height + this.getHorizontalScrollBar().getPreferredSize().height);
            }

            @Override
            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        pane.setHorizontalScrollBarPolicy(31);
        buttonsPanel.setOpaque(false);
        this._pageList.addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent e) {
                for (int i = e.getIndex0(); i <= e.getIndex1(); ++i) {
                    MultiplePageDialogPane.this.addPage(i, group, buttonsPanel);
                }
                buttonsPanel.invalidate();
                buttonsPanel.doLayout();
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
                for (int i = e.getIndex1(); i >= e.getIndex0(); --i) {
                    AbstractButton button = (AbstractButton)buttonsPanel.getComponent(i);
                    buttonsPanel.remove(button);
                    group.remove(button);
                }
                buttonsPanel.invalidate();
                buttonsPanel.doLayout();
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                AbstractButton button;
                if (e.getIndex0() == -1 && e.getIndex1() == -1 && e.getType() == 0 && (button = (AbstractButton)buttonsPanel.getButtonByName(MultiplePageDialogPane.this._pageList.getCurrentPage().getTitle())) != null) {
                    group.setSelected(button.getModel(), true);
                }
            }
        });
        pane.getViewport().setOpaque(false);
        return pane;
    }

    protected ButtonPanel createIconButtonPanel() {
        return new ScrollableButtonPanel(1, 0);
    }

    private JideButton addPage(int i, final ButtonGroup group, final ButtonPanel buttonsPanel) {
        AbstractDialogPage optionsPanel = this._pageList.getPage(i);
        final JideButton button = this.createIconButton(optionsPanel.getTitle(), optionsPanel.getIcon());
        button.addActionListener(new AbstractAction(optionsPanel.getTitle(), optionsPanel.getIcon()){

            @Override
            public void actionPerformed(ActionEvent e) {
                group.setSelected(button.getModel(), true);
                MultiplePageDialogPane.this.setCurrentPage(MultiplePageDialogPane.this._pageList.getPageByFullTitle(e.getActionCommand()), buttonsPanel);
            }
        });
        buttonsPanel.addButton((AbstractButton)button, i);
        group.add(button);
        return button;
    }

    protected JideButton createIconButton(String title, Icon icon) {
        JideButton button = new JideButton(title, icon);
        button.setName(title);
        button.setHorizontalAlignment(0);
        button.setVerticalTextPosition(3);
        button.setHorizontalTextPosition(0);
        button.setRequestFocusEnabled(false);
        button.setFocusable(false);
        return button;
    }

    public int getStyle() {
        return this._style;
    }

    public void setStyle(int style) {
        if (style != 0 && style != 2 && style != 3 && style != 1) {
            throw new IllegalArgumentException("The value of style must be one of the following - TAB_STYLE, ICON_STYLE, LIST_STYLE or TREE_STYLE");
        }
        this._style = style;
    }

    public JComponent getIndexPanel() {
        return this._indexPanel;
    }

    public JComponent getPagesPanel() {
        return this._pagesPanel;
    }

    protected TreeCellRenderer getTreeCellRenderer() {
        return this._treeCellRenderer;
    }

    public void setTreeCellRenderer(TreeCellRenderer treeCellRenderer) {
        this._treeCellRenderer = treeCellRenderer;
    }

    protected ListCellRenderer getListCellRenderer() {
        return this._listCellRenderer;
    }

    public void setListCellRenderer(ListCellRenderer listCellRenderer) {
        this._listCellRenderer = listCellRenderer;
    }

    protected ListCellRenderer createListCellRenderer() {
        if (this.getListCellRenderer() == null) {
            this.setListCellRenderer(new DialogPageListCellRenderer());
        }
        return this.getListCellRenderer();
    }

    protected TreeCellRenderer createTreeCellRenderer() {
        if (this.getTreeCellRenderer() == null) {
            this.setTreeCellRenderer(new DialogPageTreeCellRenderer());
        }
        return this.getTreeCellRenderer();
    }

    public String getInitialPageTitle() {
        return this._initialPageTitle;
    }

    public void setInitialPageTitle(String initialPageTitle) {
        this._initialPageTitle = initialPageTitle;
    }
}

