/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import net.sourceforge.squirrel_sql.client.action.SquirrelAction;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.mainpanel.ErrorPanelListener;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.StringUtilities;
import net.sourceforge.squirrel_sql.fw.util.Utilities;

public class ErrorPanel
extends JPanel {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(ErrorPanel.class);
    private ErrorPanelListener _errorPanelListener;
    private JPopupMenu _popUp = new JPopupMenu();
    private JTextArea _txtArea;
    private TabButton _btnClose;

    public ErrorPanel(ISession session, ErrorPanelListener errorPanelListener, ArrayList<String> sqlExecErrorMsgs, String lastExecutedStatement) {
        super(new BorderLayout());
        this._errorPanelListener = errorPanelListener;
        this._txtArea = new JTextArea();
        this._txtArea.setFont(this._txtArea.getFont().deriveFont(1));
        this._txtArea.setForeground(Color.red);
        this._txtArea.setSelectedTextColor(Color.red);
        this._txtArea.setEditable(false);
        for (int i = 0; i < sqlExecErrorMsgs.size(); ++i) {
            this._txtArea.append(sqlExecErrorMsgs.get(i));
            if (i >= sqlExecErrorMsgs.size() - 1) continue;
            this._txtArea.append("\n\n");
        }
        JScrollPane scrp = new JScrollPane(this._txtArea);
        this.add((Component)this.createNorthPanel(session, sqlExecErrorMsgs, lastExecutedStatement), "North");
        this.add((Component)scrp, "Center");
        this.initPopup();
        scrp.scrollRectToVisible(new Rectangle(0, 0, 1, 1));
    }

    private void initPopup() {
        JMenuItem mnuCopyAll = new JMenuItem(s_stringMgr.getString("ErrorPanel.copyAll"));
        mnuCopyAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ErrorPanel.this.onCopyAll();
            }
        });
        this._popUp.add(mnuCopyAll);
        JMenuItem mnuCopySelection = new JMenuItem(s_stringMgr.getString("ErrorPanel.copySelection"));
        mnuCopySelection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ErrorPanel.this.onCopySelection();
            }
        });
        this._popUp.add(mnuCopySelection);
        this._txtArea.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                ErrorPanel.this.maybeShowPopup(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                ErrorPanel.this.maybeShowPopup(evt);
            }
        });
    }

    private void onCopyAll() {
        if (null == this._txtArea.getText()) {
            return;
        }
        Clipboard clip = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection data = new StringSelection(this._txtArea.getText().trim());
        clip.setContents(data, data);
    }

    private void onCopySelection() {
        if (null == this._txtArea.getSelectedText()) {
            return;
        }
        Clipboard clip = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection data = new StringSelection(this._txtArea.getSelectedText().trim());
        clip.setContents(data, data);
    }

    private JPanel createNorthPanel(ISession session, ArrayList<String> sqlExecErrorMsgs, String lastExecutedStatement) {
        JPanel ret = new JPanel(new GridBagLayout());
        String msg = s_stringMgr.getString("ErrorPanel.NoErrorStatement");
        if (1 < sqlExecErrorMsgs.size() && !session.getProperties().getAbortOnError()) {
            msg = s_stringMgr.getString("ErrorPanel.MultibleStatements");
        } else if (null != lastExecutedStatement && 0 < lastExecutedStatement.trim().length()) {
            msg = s_stringMgr.getString("ErrorPanel.occuredIn", StringUtilities.cleanString(lastExecutedStatement.trim()));
        }
        String escapedMsg = Utilities.escapeHtmlChars(msg);
        String htmlMsg = "<html><pre>&nbsp;" + escapedMsg + "</pre></html>";
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 2, new Insets(0, 0, 0, 5), 0, 0);
        ret.add((Component)new JLabel(htmlMsg), gbc);
        gbc = new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 12, 0, new Insets(0, 0, 0, 0), 0, 0);
        this._btnClose = new TabButton(new CloseAction(session));
        ret.add((Component)this._btnClose, gbc);
        return ret;
    }

    public void hideCloseButton() {
        this._btnClose.setVisible(false);
    }

    private void closeTab() {
        this._errorPanelListener.removeErrorPanel(this);
    }

    private void maybeShowPopup(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            this._popUp.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }

    private final class TabButton
    extends JButton {
        TabButton(Action action) {
            super(action);
            this.setMargin(new Insets(0, 0, 0, 0));
            this.setBorderPainted(false);
            this.setText("");
        }
    }

    private class CloseAction
    extends SquirrelAction {
        CloseAction(ISession session) {
            super(session.getApplication(), session.getApplication().getResources());
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            ErrorPanel.this.closeTab();
        }
    }
}

