/*
Copyright (C) 2003, Nik Reiman - nik@aboleo.net

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "ubs.h"

/****
  Functions used exclusively by the ubs shell.
****/

// Shared Functions

// ubs.c
int parse_command(int cmdc, char **cmdv);
int break_command(char *buf, char **cmd);
// loginfo.c
int get_log(char *log, int num_lines, int mode);
int show_queue(int format);
// search.c
int recache(void);
int scan_dir(char *dirname, FILE *fp);

// known commands
int cmd_start(int cmdc, char **cmdv);
int sub_start_proc(char *proc, int format);

int cmd_stop(int cmdc, char **cmdv);
int sub_stop_proc(char *proc, int format);

int cmd_restart(int cmdc, char **cmdv);

int cmd_status(int cmdc, char **cmdv);
int sub_status_proc(char *proc, int format);

int cmd_log(int cmdc, char **cmdv);
int sub_list_logs(int format);

int cmd_queue(int cmdc, char **cmdv);

int cmd_tag(int cmdc, char **cmdv);
int sub_print_tag(char *sname, int format);

int cmd_shows(int cmdc, char **cmdv);
int sub_dump_show(int show_num, int format);
int sub_now_playing(int format);

int cmd_sched(int cmdc, char **cmdv);
int sub_dump_sched(int format);

int cmd_search(int cmdc, char **cmdv);

int cmd_events(int cmdc, char **cmdv);
int sub_dump_event(int event_num, int format);

int cmd_help(int cmdc, char **cmdv);
int sub_help_cmd(char *command);
