/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.datatransfer.DataFlavor;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import org.netbeans.core.windows.Constants;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.view.Controller;
import org.netbeans.core.windows.view.ViewElement;
import org.netbeans.core.windows.view.dnd.TopComponentDraggable;
import org.netbeans.core.windows.view.dnd.TopComponentDroppable;
import org.netbeans.core.windows.view.dnd.WindowDnDManager;
import org.netbeans.core.windows.view.ui.MainWindow;
import org.openide.awt.Actions;
import org.openide.filesystems.FileUtil;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.windows.ExternalDropHandler;

public class EditorView
extends ViewElement {
    private static final boolean IS_GTK = "GTK".equals(UIManager.getLookAndFeel().getID());
    private ViewElement editorArea;
    private EditorAreaComponent editorAreaComponent;
    private final WindowDnDManager windowDnDManager;
    private static DataFlavor URI_LIST_DATA_FLAVOR;

    public EditorView(Controller controller, WindowDnDManager windowDnDManager, double d, ViewElement viewElement) {
        super(controller, d);
        this.editorArea = viewElement;
        this.windowDnDManager = windowDnDManager;
    }

    Rectangle getPureBounds() {
        EditorAreaComponent editorAreaComponent = this.getEditorAreaComponent();
        Rectangle rectangle = editorAreaComponent.getBounds();
        Point point = new Point(0, 0);
        SwingUtilities.convertPointToScreen(point, editorAreaComponent);
        rectangle.setLocation(point);
        return rectangle;
    }

    private EditorAreaComponent getEditorAreaComponent() {
        if (this.editorAreaComponent == null) {
            this.editorAreaComponent = new EditorAreaComponent(this, this.windowDnDManager);
        }
        if (IS_GTK && !this.editorAreaComponent.isValid()) {
            this.editorAreaComponent.repaint();
        }
        return this.editorAreaComponent;
    }

    private void manageBorder(JPanel jPanel) {
        if (this.editorArea != null) {
            jPanel.setBorder(null);
        } else if (Utilities.isMac()) {
            jPanel.setBorder(BorderFactory.createEmptyBorder());
        } else {
            Border border = UIManager.getBorder("Nb.EmptyEditorArea.border");
            if (null == border) {
                border = UIManager.getBorder("Nb.ScrollPane.border");
            }
            jPanel.setBorder(border);
        }
    }

    public ViewElement getEditorArea() {
        return this.editorArea;
    }

    public void setEditorArea(ViewElement viewElement) {
        this.editorArea = viewElement;
    }

    @Override
    public Component getComponent() {
        return this.getEditorAreaComponent();
    }

    @Override
    public boolean updateAWTHierarchy(Dimension dimension) {
        boolean bl = false;
        EditorAreaComponent editorAreaComponent = this.getEditorAreaComponent();
        Dimension dimension2 = (Dimension)editorAreaComponent.getClientProperty("lastAvailableSpace");
        Dimension dimension3 = editorAreaComponent.getPreferredSize();
        if (!dimension.equals(dimension2) || !dimension.equals(dimension3)) {
            editorAreaComponent.setPreferredSize(dimension);
            editorAreaComponent.putClientProperty("lastAvailableSpace", dimension);
            bl = true;
        }
        this.assureComponentInEditorArea();
        if (this.editorArea != null) {
            bl |= this.editorArea.updateAWTHierarchy(new Dimension(dimension.width - 5, dimension.height - 5));
        }
        return bl;
    }

    void assureComponentInEditorArea() {
        EditorAreaComponent editorAreaComponent = this.getEditorAreaComponent();
        if (this.editorArea == null) {
            editorAreaComponent.setAreaComponent(null);
        } else {
            editorAreaComponent.setAreaComponent(this.editorArea.getComponent());
        }
        this.manageBorder(editorAreaComponent);
    }

    static {
        try {
            URI_LIST_DATA_FLAVOR = new DataFlavor("text/uri-list;class=java.lang.String");
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
    }

    private static class BackgroundActionButton
    extends JButton {
        private final TitledBorder shortcut;

        private BackgroundActionButton(Action action) {
            this.setContentAreaFilled(false);
            this.setRolloverEnabled(true);
            this.setHorizontalAlignment(2);
            Color color = UIManager.getColor("EditorTab.foreground");
            if (color != null) {
                this.setForeground(color);
            }
            this.shortcut = new TitledBorder(new EmptyBorder(2, 20, 2, 40), "", 1, 4);
            Color color2 = UIManager.getColor("EditorTab.underlineColor");
            if (color2 != null) {
                this.shortcut.setTitleColor(color2);
            } else {
                color2 = new Color(1461115);
                this.shortcut.setTitleColor(color2);
            }
            Font font = this.getFont();
            if (font != null) {
                this.shortcut.setTitleFont(font.deriveFont(0.9f * (float)font.getSize()));
            }
            this.setBorder(this.shortcut);
            this.setCursor(Cursor.getPredefinedCursor(12));
            this.setAction(action);
        }

        @Override
        protected void actionPropertyChanged(Action action, String string) {
            if ("Name".equals(string)) {
                this.configureText(action);
            } else if ("AcceleratorKey".equals(string)) {
                this.configureShortcut(action);
            }
            this.repaint();
        }

        @Override
        protected void configurePropertiesFromAction(Action action) {
            this.configureText(action);
            this.configureShortcut(action);
            this.setIcon(null);
        }

        @Override
        public void paint(Graphics graphics) {
            Color color;
            if (this.getModel().isRollover() && (color = UIManager.getColor("EditorTab.hoverBackground")) != null) {
                graphics.setColor(color);
                graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
            super.paint(graphics);
        }

        private void configureShortcut(Action action) {
            KeyStroke keyStroke = (KeyStroke)action.getValue("AcceleratorKey");
            if (keyStroke != null) {
                String string = Actions.keyStrokeToString((KeyStroke)keyStroke);
                this.shortcut.setTitle(string);
            } else {
                String string = NbBundle.getMessage(MainWindow.class, (String)"LBL_NoShortcut");
                if (string.isEmpty()) {
                    string = " ";
                }
                this.shortcut.setTitle(string);
            }
        }

        private void configureText(Action action) {
            String string = (String)action.getValue("Name");
            if (string == null) {
                string = "";
            }
            this.setText(Actions.cutAmpersand((String)string));
        }
    }

    private static class EditorAreaComponent
    extends JPanel
    implements TopComponentDroppable {
        private final EditorView editorView;
        private final JComponent backgroundComponent;
        private final WindowDnDManager windowDnDManager;
        private Component areaComponent;

        public EditorAreaComponent(EditorView editorView, WindowDnDManager windowDnDManager) {
            this.editorView = editorView;
            this.windowDnDManager = windowDnDManager;
            this.backgroundComponent = this.initBackgroundComponent();
            this.init();
        }

        private void init() {
            this.setLayout(new BorderLayout());
            if (this.backgroundComponent != null) {
                this.add((Component)this.backgroundComponent, "Center");
            }
            DropTarget dropTarget = new DropTarget(this, new DropTargetListener(){

                @Override
                public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
                }

                @Override
                public void dragExit(DropTargetEvent dropTargetEvent) {
                }

                @Override
                public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
                    for (ExternalDropHandler externalDropHandler : Lookup.getDefault().lookupAll(ExternalDropHandler.class)) {
                        if (!externalDropHandler.canDrop(dropTargetDragEvent)) continue;
                        dropTargetDragEvent.acceptDrag(1);
                        return;
                    }
                    dropTargetDragEvent.rejectDrag();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void drop(DropTargetDropEvent dropTargetDropEvent) {
                    boolean bl = false;
                    try {
                        for (ExternalDropHandler externalDropHandler : Lookup.getDefault().lookupAll(ExternalDropHandler.class)) {
                            if (!externalDropHandler.canDrop(dropTargetDropEvent)) continue;
                            dropTargetDropEvent.acceptDrop(1);
                            bl = externalDropHandler.handleDrop(dropTargetDropEvent);
                            break;
                        }
                    }
                    finally {
                        dropTargetDropEvent.dropComplete(bl);
                    }
                }

                @Override
                public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
                }
            });
            this.setDropTarget(dropTarget);
            if (UIManager.getBoolean("NbMainWindow.showCustomBackground") || "Aqua".equals(UIManager.getLookAndFeel().getID())) {
                this.setOpaque(false);
            }
        }

        private JComponent initBackgroundComponent() {
            Object object;
            Object object2;
            Object object3 = null;
            String string = Constants.SWITCH_IMAGE_SOURCE;
            if (string == null && (object2 = FileUtil.getConfigFile((String)"Windows2/Background")) != null && (object = object2.getAttribute("backgroundImage")) instanceof String) {
                string = (String)object;
            }
            if (string != null) {
                object2 = ImageUtilities.loadImage((String)string);
                if (object2 != null) {
                    object = new JLabel(ImageUtilities.image2Icon((Image)object2));
                    ((JComponent)object).setMinimumSize(new Dimension(0, 0));
                    object3 = object;
                } else {
                    Logger.getLogger(EditorView.class.getName()).log(Level.WARNING, null, new NullPointerException("Image not found at " + string));
                }
            }
            if ((object2 = this.initBackgroundActions()) != null) {
                object = new JPanel(new GridBagLayout());
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.ipadx = 50;
                if (object3 != null) {
                    ((Container)object).add((Component)object3, gridBagConstraints);
                }
                ((Container)object).add((Component)object2, gridBagConstraints);
                return object;
            }
            return object3;
        }

        private JComponent initBackgroundActions() {
            List list = Utilities.actionsForPath((String)"Windows2/Background/Actions");
            if (list.isEmpty()) {
                return null;
            }
            JPanel jPanel = new JPanel(new GridLayout(0, 1));
            for (Action action : list) {
                if (action == null) continue;
                BackgroundActionButton backgroundActionButton = new BackgroundActionButton(action);
                jPanel.add(backgroundActionButton);
            }
            return jPanel;
        }

        @Override
        public void updateUI() {
            super.updateUI();
            Color color = UIManager.getColor("Nb.EmptyEditorArea.background");
            if (color == null) {
                color = UIManager.getColor("Panel.background");
            }
            this.setBackground(color);
        }

        public void setAreaComponent(Component component) {
            if (this.areaComponent == component) {
                if (component != null && !Arrays.asList(this.getComponents()).contains(component)) {
                    if (this.backgroundComponent != null) {
                        this.remove(this.backgroundComponent);
                    }
                    this.add(component, "Center");
                }
                return;
            }
            if (this.areaComponent != null) {
                this.remove(this.areaComponent);
                if (component == null && this.backgroundComponent != null) {
                    this.add((Component)this.backgroundComponent, "Center");
                }
            }
            this.areaComponent = component;
            if (this.areaComponent != null) {
                if (this.backgroundComponent != null) {
                    this.remove(this.backgroundComponent);
                }
                this.add(this.areaComponent, "Center");
            }
            this.repaint();
        }

        @Override
        public Shape getIndicationForLocation(Point point) {
            int n = this.windowDnDManager.getStartingTransfer().getKind();
            if (n == 1) {
                Rectangle rectangle = this.getBounds();
                rectangle.setLocation(0, 0);
                return rectangle;
            }
            Rectangle rectangle = this.getBounds();
            rectangle.setLocation(0, 0);
            String string = this.getSideForLocation(point);
            double d = 0.25;
            if ("top".equals(string)) {
                return new Rectangle(0, 0, rectangle.width, (int)((double)rectangle.height * d));
            }
            if (string == "left") {
                return new Rectangle(0, 0, (int)((double)rectangle.width * d), rectangle.height);
            }
            if (string == "right") {
                return new Rectangle(rectangle.width - (int)((double)rectangle.width * d), 0, (int)((double)rectangle.width * d), rectangle.height);
            }
            if (string == "bottom") {
                return new Rectangle(0, rectangle.height - (int)((double)rectangle.height * d), rectangle.width, (int)((double)rectangle.height * d));
            }
            if (this.windowDnDManager.getStartingTransfer().isAllowedToMoveAnywhere()) {
                return rectangle;
            }
            return null;
        }

        @Override
        public Object getConstraintForLocation(Point point) {
            int n = this.windowDnDManager.getStartingTransfer().getKind();
            if (n == 1) {
                return null;
            }
            return this.getSideForLocation(point);
        }

        private String getSideForLocation(Point point) {
            Rectangle rectangle = this.getBounds();
            rectangle.setLocation(0, 0);
            int n = 20;
            Rectangle rectangle2 = new Rectangle(0, 0, rectangle.width, n);
            if (rectangle2.contains(point)) {
                return "top";
            }
            Rectangle rectangle3 = new Rectangle(0, n, n, rectangle.height - 2 * n);
            if (rectangle3.contains(point)) {
                return "left";
            }
            Rectangle rectangle4 = new Rectangle(rectangle.width - n, n, n, rectangle.height - 2 * n);
            if (rectangle4.contains(point)) {
                return "right";
            }
            Rectangle rectangle5 = new Rectangle(0, rectangle.height - n, rectangle.width, n);
            if (rectangle5.contains(point)) {
                return "bottom";
            }
            return null;
        }

        @Override
        public Component getDropComponent() {
            return this;
        }

        @Override
        public ViewElement getDropViewElement() {
            return this.editorView;
        }

        @Override
        public boolean canDrop(TopComponentDraggable topComponentDraggable, Point point) {
            if (topComponentDraggable.isAllowedToMoveAnywhere()) {
                return true;
            }
            int n = topComponentDraggable.getKind();
            if (n == 1) {
                return true;
            }
            return WindowManagerImpl.getInstance().getEditorAreaState() == 0 && this.getSideForLocation(point) != null;
        }

        @Override
        public boolean supportsKind(TopComponentDraggable topComponentDraggable) {
            return true;
        }

        @Override
        public int getKind() {
            return 1;
        }
    }
}

