/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public abstract class AutoScroll {
    public static final String CLIENT_PROPERTY_AUTO_SCROLL = "AutoScroll";
    protected Timer _timer;
    protected boolean _autoScrolling = false;
    protected int _scrollDirection = 0;
    protected boolean _hasEntered;
    public static final int SCROLL_UP = 0;
    public static final int SCROLL_DOWN = 1;
    public static final int SCROLL_LEFT = 2;
    public static final int SCROLL_RIGHT = 4;
    protected Component _component;
    protected boolean _vertical = true;
    protected int _autoScrollInterval = 100;
    private boolean _componentSelfScrollable = true;
    private boolean _enabled = true;

    protected AutoScroll(Component component) {
        this._component = component;
        this.updateClientProperty(component, this);
    }

    protected AutoScroll(Component component, boolean vertical) {
        this._component = component;
        this._vertical = vertical;
        this.updateClientProperty(component, this);
    }

    public int getAutoScrollInterval() {
        return this._autoScrollInterval;
    }

    public void setAutoScrollInterval(int autoScrollInterval) {
        this._autoScrollInterval = autoScrollInterval;
    }

    public boolean isEnabled() {
        return this._enabled;
    }

    public void setEnabled(boolean enabled) {
        this._enabled = enabled;
    }

    public void startAutoScrolling(int direction) {
        if (this._autoScrolling) {
            this._timer.stop();
        }
        this._autoScrolling = true;
        this._scrollDirection = direction;
        this.autoScrollingStarted(this._scrollDirection);
        this._timer = new Timer(this._autoScrollInterval, new AutoScrollActionHandler(this._scrollDirection));
        this._timer.start();
    }

    public void stopAutoScrolling() {
        this._autoScrolling = false;
        if (this._timer != null) {
            this._timer.stop();
            this._timer = null;
        }
        this.autoScrollingEnded(this._scrollDirection);
    }

    public boolean isAutoScrolling() {
        return this._autoScrolling;
    }

    public int getScrollDirection() {
        return this._scrollDirection;
    }

    public boolean isComponentSelfScrollable() {
        return this._componentSelfScrollable;
    }

    public void setComponentSelfScrollable(boolean scrollable) {
        this._componentSelfScrollable = scrollable;
    }

    protected MouseEvent convertMouseEvent(MouseEvent e) {
        if (e.getSource() == this._component) {
            return e;
        }
        Point convertedPoint = SwingUtilities.convertPoint((Component)e.getSource(), e.getPoint(), this._component);
        return new MouseEvent((Component)e.getSource(), e.getID(), e.getWhen(), e.getModifiers(), convertedPoint.x, convertedPoint.y, e.getClickCount(), e.isPopupTrigger());
    }

    public void mouseReleased(MouseEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        this._hasEntered = false;
        this.stopAutoScrolling();
    }

    public void mousePressed(MouseEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        this.stopAutoScrolling();
    }

    public void mouseDragged(MouseEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        if (this._componentSelfScrollable && e.getSource() == this._component) {
            return;
        }
        if (this._component.isVisible()) {
            MouseEvent newEvent = this.convertMouseEvent(e);
            Rectangle r = new Rectangle();
            if (this._component instanceof JComponent) {
                ((JComponent)this._component).computeVisibleRect(r);
            } else {
                r = this._component.getBounds();
            }
            if (newEvent.getPoint().y >= r.y && newEvent.getPoint().y <= r.y + r.height - 1 && newEvent.getPoint().x >= r.x && newEvent.getPoint().x <= r.x + r.width - 1) {
                Point location;
                this._hasEntered = true;
                if (this._autoScrolling) {
                    this.stopAutoScrolling();
                }
                if (r.contains(location = newEvent.getPoint())) {
                    this.updateSelectionForEvent(newEvent, false);
                }
            } else if (this._hasEntered) {
                int directionToScroll = newEvent.getPoint().y < r.y ? 0 : (newEvent.getPoint().x < r.x ? 2 : (newEvent.getPoint().y > r.y + r.height ? 1 : 4));
                if (this._autoScrolling && this._scrollDirection != directionToScroll) {
                    this.stopAutoScrolling();
                    this.startAutoScrolling(directionToScroll);
                } else if (!this._autoScrolling) {
                    this.startAutoScrolling(directionToScroll);
                }
            }
        }
    }

    public void mouseMoved(MouseEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        if (e.getSource() == this._component) {
            Point location = e.getPoint();
            Rectangle r = new Rectangle();
            if (this._component instanceof JComponent) {
                ((JComponent)this._component).computeVisibleRect(r);
                if (r.contains(location)) {
                    this.updateSelectionForEvent(e, false);
                }
            } else {
                this.updateSelectionForEvent(e, false);
            }
        }
    }

    public void autoScrollingStarted(int direction) {
    }

    public void autoScrollingEnded(int direction) {
    }

    public abstract void autoScrolling(int var1);

    public abstract void updateSelectionForEvent(MouseEvent var1, boolean var2);

    public static AutoScroll getAutoScroll(Component component) {
        Object clientProperty;
        Object object = clientProperty = component instanceof JComponent ? ((JComponent)component).getClientProperty(CLIENT_PROPERTY_AUTO_SCROLL) : null;
        if (clientProperty instanceof AutoScroll) {
            return (AutoScroll)clientProperty;
        }
        return null;
    }

    private void updateClientProperty(Component component, AutoScroll autoScroll) {
        if (component != null) {
            Object clientProperty = ((JComponent)this._component).getClientProperty(CLIENT_PROPERTY_AUTO_SCROLL);
            if (clientProperty instanceof AutoScroll) {
                ((AutoScroll)clientProperty).stopAutoScrolling();
            }
            if (component instanceof JComponent) {
                ((JComponent)component).putClientProperty(CLIENT_PROPERTY_AUTO_SCROLL, autoScroll);
            }
        }
    }

    private class AutoScrollActionHandler
    implements ActionListener {
        private int _direction;

        AutoScrollActionHandler(int direction) {
            this._direction = direction;
        }

        public void actionPerformed(ActionEvent e) {
            AutoScroll.this.autoScrolling(this._direction);
        }
    }
}

