/*
 * Decompiled with CFR 0.152.
 */
package org.wiztools.restclient.ui.reqssl;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.wiztools.restclient.bean.KeyStoreType;
import org.wiztools.restclient.bean.SSLKeyStore;
import org.wiztools.restclient.ui.UIUtil;
import org.wiztools.restclient.ui.reqssl.KeyStoreDialog;
import org.wiztools.restclient.ui.reqssl.KeyStoreListener;

public class KeyStorePanel
extends JPanel
implements KeyStoreListener {
    @Inject
    private KeyStoreDialog jd;
    private final JLabel jl = new JLabel();
    private final JTextField jtf = new JTextField(23);
    private final JButton jb_addEdit = new JButton(UIUtil.getIconFromClasspath("org/wiztools/restclient/pencil_add.png"));
    private final JButton jb_clear = new JButton(UIUtil.getIconFromClasspath("org/wiztools/restclient/delete.png"));
    private SSLKeyStore keyStore = null;
    private static final String tmpl = "type={0}; fileName={1}; password={2}";

    @PostConstruct
    public void init() {
        this.jtf.setEditable(false);
        this.jd.addKeyStoreListener(this);
        this.jb_addEdit.setToolTipText("Add / Edit");
        this.jb_clear.setToolTipText("Clear");
        this.jb_addEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KeyStorePanel.this.onAddEdit();
            }
        });
        this.jb_clear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KeyStorePanel.this.clear();
            }
        });
        this.jtf.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    KeyStorePanel.this.onAddEdit();
                }
            }
        });
        JPanel jp_jtf = new JPanel(new FlowLayout(2));
        jp_jtf.add(this.jtf);
        this.setLayout(new BorderLayout());
        this.add((Component)this.jl, "West");
        this.add((Component)jp_jtf, "Center");
        this.add((Component)UIUtil.getFlowLayoutLeftAlignedMulti(this.jb_addEdit, this.jb_clear), "East");
    }

    public void setLabel(String label) {
        this.jl.setText(label);
    }

    public void setTitle(String title) {
        this.jd.setTitle(title);
    }

    @Override
    public void onOk(SSLKeyStore store) {
        String pwdAvailable = store.getType() == KeyStoreType.PEM ? "NA" : (store.getPassword() != null && store.getPassword().length > 0 ? "Yes" : "No");
        String txt = MessageFormat.format(tmpl, new Object[]{store.getType(), store.getFile().getName(), pwdAvailable});
        this.jtf.setText(txt);
        this.jtf.setCaretPosition(0);
        this.keyStore = store;
    }

    @Override
    public void onCancel() {
        this.jd.setKeyStore(this.keyStore);
    }

    public SSLKeyStore getKeyStore() {
        return this.keyStore;
    }

    public void setKeyStore(SSLKeyStore store) {
        if (store != null) {
            this.jd.setKeyStore(store);
            this.onOk(store);
        } else {
            this.clear();
        }
    }

    private void onAddEdit() {
        this.jd.setVisible(true);
    }

    public void clear() {
        this.jd.clear();
        this.jtf.setText("");
        this.keyStore = null;
    }
}

