/*
 * Copyright (C) Huawei Technologies Co., Ltd. 2023-2024. All rights reserved.
 * SPDX-License-Identifier: MIT
 */

#ifndef VATOMIC_BUILTINS_H
#define VATOMIC_BUILTINS_H
/* !!!Warning: File generated by tmplr; DO NOT EDIT.!!! */
#include <vsync/common/macros.h>

/* ****************************************************************************
 * vatomic_fence
 * ****************************************************************************/

#ifndef VATOMIC_FENCE
    #define VATOMIC_FENCE

static inline void
vatomic_fence(void)
{
    V_COMPILER_BARRIER();
    #if !defined(VSYNC_THREAD_SANITIZER)
    __atomic_thread_fence(__ATOMIC_SEQ_CST);
    #endif
    V_COMPILER_BARRIER();
}

#endif /* VATOMIC_FENCE */

#ifndef VATOMIC_FENCE_ACQ
    #define VATOMIC_FENCE_ACQ

static inline void
vatomic_fence_acq(void)
{
    V_COMPILER_BARRIER();
    #if !defined(VSYNC_THREAD_SANITIZER)
    __atomic_thread_fence(__ATOMIC_ACQUIRE);
    #endif
    V_COMPILER_BARRIER();
}

#endif /* VATOMIC_FENCE_ACQ */

#ifndef VATOMIC_FENCE_REL
    #define VATOMIC_FENCE_REL

static inline void
vatomic_fence_rel(void)
{
    V_COMPILER_BARRIER();
    #if !defined(VSYNC_THREAD_SANITIZER)
    __atomic_thread_fence(__ATOMIC_RELEASE);
    #endif
    V_COMPILER_BARRIER();
}

#endif /* VATOMIC_FENCE_REL */

#ifndef VATOMIC_FENCE_RLX
    #define VATOMIC_FENCE_RLX

static inline void
vatomic_fence_rlx(void)
{
    #if !defined(VSYNC_THREAD_SANITIZER)
    __atomic_thread_fence(__ATOMIC_RELAXED);
    #endif
}

#endif /* VATOMIC_FENCE_RLX */

/* *****************************************************************************
 * vatomic_read
 * ****************************************************************************/

#ifndef VATOMIC8_READ
    #define VATOMIC8_READ

static inline vuint8_t
vatomic8_read(const vatomic8_t *a)
{
    V_COMPILER_BARRIER();
    vuint8_t tmp = (vuint8_t)__atomic_load_n(&a->_v, __ATOMIC_SEQ_CST);
    V_COMPILER_BARRIER();
    return tmp;
}

#endif /* VATOMIC8_READ */

#ifndef VATOMIC8_READ_ACQ
    #define VATOMIC8_READ_ACQ

static inline vuint8_t
vatomic8_read_acq(const vatomic8_t *a)
{
    V_COMPILER_BARRIER();
    vuint8_t tmp = (vuint8_t)__atomic_load_n(&a->_v, __ATOMIC_ACQUIRE);
    V_COMPILER_BARRIER();
    return tmp;
}

#endif /* VATOMIC8_READ_ACQ */

#ifndef VATOMIC8_READ_RLX
    #define VATOMIC8_READ_RLX

static inline vuint8_t
vatomic8_read_rlx(const vatomic8_t *a)
{
    V_COMPILER_BARRIER();
    vuint8_t tmp = (vuint8_t)__atomic_load_n(&a->_v, __ATOMIC_RELAXED);
    V_COMPILER_BARRIER();
    return tmp;
}

#endif /* VATOMIC8_READ_RLX */

#ifndef VATOMIC16_READ
    #define VATOMIC16_READ

static inline vuint16_t
vatomic16_read(const vatomic16_t *a)
{
    V_COMPILER_BARRIER();
    vuint16_t tmp = (vuint16_t)__atomic_load_n(&a->_v, __ATOMIC_SEQ_CST);
    V_COMPILER_BARRIER();
    return tmp;
}

#endif /* VATOMIC16_READ */

#ifndef VATOMIC16_READ_ACQ
    #define VATOMIC16_READ_ACQ

static inline vuint16_t
vatomic16_read_acq(const vatomic16_t *a)
{
    V_COMPILER_BARRIER();
    vuint16_t tmp = (vuint16_t)__atomic_load_n(&a->_v, __ATOMIC_ACQUIRE);
    V_COMPILER_BARRIER();
    return tmp;
}

#endif /* VATOMIC16_READ_ACQ */

#ifndef VATOMIC16_READ_RLX
    #define VATOMIC16_READ_RLX

static inline vuint16_t
vatomic16_read_rlx(const vatomic16_t *a)
{
    V_COMPILER_BARRIER();
    vuint16_t tmp = (vuint16_t)__atomic_load_n(&a->_v, __ATOMIC_RELAXED);
    V_COMPILER_BARRIER();
    return tmp;
}

#endif /* VATOMIC16_READ_RLX */

#ifndef VATOMIC32_READ
    #define VATOMIC32_READ

static inline vuint32_t
vatomic32_read(const vatomic32_t *a)
{
    V_COMPILER_BARRIER();
    vuint32_t tmp = (vuint32_t)__atomic_load_n(&a->_v, __ATOMIC_SEQ_CST);
    V_COMPILER_BARRIER();
    return tmp;
}

#endif /* VATOMIC32_READ */

#ifndef VATOMIC32_READ_ACQ
    #define VATOMIC32_READ_ACQ

static inline vuint32_t
vatomic32_read_acq(const vatomic32_t *a)
{
    V_COMPILER_BARRIER();
    vuint32_t tmp = (vuint32_t)__atomic_load_n(&a->_v, __ATOMIC_ACQUIRE);
    V_COMPILER_BARRIER();
    return tmp;
}

#endif /* VATOMIC32_READ_ACQ */

#ifndef VATOMIC32_READ_RLX
    #define VATOMIC32_READ_RLX

static inline vuint32_t
vatomic32_read_rlx(const vatomic32_t *a)
{
    V_COMPILER_BARRIER();
    vuint32_t tmp = (vuint32_t)__atomic_load_n(&a->_v, __ATOMIC_RELAXED);
    V_COMPILER_BARRIER();
    return tmp;
}

#endif /* VATOMIC32_READ_RLX */

#ifndef VATOMIC64_READ
    #define VATOMIC64_READ

static inline vuint64_t
vatomic64_read(const vatomic64_t *a)
{
    V_COMPILER_BARRIER();
    vuint64_t tmp = (vuint64_t)__atomic_load_n(&a->_v, __ATOMIC_SEQ_CST);
    V_COMPILER_BARRIER();
    return tmp;
}

#endif /* VATOMIC64_READ */

#ifndef VATOMIC64_READ_ACQ
    #define VATOMIC64_READ_ACQ

static inline vuint64_t
vatomic64_read_acq(const vatomic64_t *a)
{
    V_COMPILER_BARRIER();
    vuint64_t tmp = (vuint64_t)__atomic_load_n(&a->_v, __ATOMIC_ACQUIRE);
    V_COMPILER_BARRIER();
    return tmp;
}

#endif /* VATOMIC64_READ_ACQ */

#ifndef VATOMIC64_READ_RLX
    #define VATOMIC64_READ_RLX

static inline vuint64_t
vatomic64_read_rlx(const vatomic64_t *a)
{
    V_COMPILER_BARRIER();
    vuint64_t tmp = (vuint64_t)__atomic_load_n(&a->_v, __ATOMIC_RELAXED);
    V_COMPILER_BARRIER();
    return tmp;
}

#endif /* VATOMIC64_READ_RLX */

#ifndef VATOMICSZ_READ
    #define VATOMICSZ_READ

static inline vsize_t
vatomicsz_read(const vatomicsz_t *a)
{
    V_COMPILER_BARRIER();
    vsize_t tmp = (vsize_t)__atomic_load_n(&a->_v, __ATOMIC_SEQ_CST);
    V_COMPILER_BARRIER();
    return tmp;
}

#endif /* VATOMICSZ_READ */

#ifndef VATOMICSZ_READ_ACQ
    #define VATOMICSZ_READ_ACQ

static inline vsize_t
vatomicsz_read_acq(const vatomicsz_t *a)
{
    V_COMPILER_BARRIER();
    vsize_t tmp = (vsize_t)__atomic_load_n(&a->_v, __ATOMIC_ACQUIRE);
    V_COMPILER_BARRIER();
    return tmp;
}

#endif /* VATOMICSZ_READ_ACQ */

#ifndef VATOMICSZ_READ_RLX
    #define VATOMICSZ_READ_RLX

static inline vsize_t
vatomicsz_read_rlx(const vatomicsz_t *a)
{
    V_COMPILER_BARRIER();
    vsize_t tmp = (vsize_t)__atomic_load_n(&a->_v, __ATOMIC_RELAXED);
    V_COMPILER_BARRIER();
    return tmp;
}

#endif /* VATOMICSZ_READ_RLX */

#ifndef VATOMICPTR_READ
    #define VATOMICPTR_READ

static inline void *
vatomicptr_read(const vatomicptr_t *a)
{
    V_COMPILER_BARRIER();
    void *tmp = (void *)__atomic_load_n(&a->_v, __ATOMIC_SEQ_CST);
    V_COMPILER_BARRIER();
    return tmp;
}

#endif /* VATOMICPTR_READ */

#ifndef VATOMICPTR_READ_ACQ
    #define VATOMICPTR_READ_ACQ

static inline void *
vatomicptr_read_acq(const vatomicptr_t *a)
{
    V_COMPILER_BARRIER();
    void *tmp = (void *)__atomic_load_n(&a->_v, __ATOMIC_ACQUIRE);
    V_COMPILER_BARRIER();
    return tmp;
}

#endif /* VATOMICPTR_READ_ACQ */

#ifndef VATOMICPTR_READ_RLX
    #define VATOMICPTR_READ_RLX

static inline void *
vatomicptr_read_rlx(const vatomicptr_t *a)
{
    V_COMPILER_BARRIER();
    void *tmp = (void *)__atomic_load_n(&a->_v, __ATOMIC_RELAXED);
    V_COMPILER_BARRIER();
    return tmp;
}

#endif /* VATOMICPTR_READ_RLX */

/* *****************************************************************************
 * vatomic_write
 * ****************************************************************************/

#ifndef VATOMIC8_WRITE
    #define VATOMIC8_WRITE

static inline void
vatomic8_write(vatomic8_t *a, vuint8_t v)
{
    V_COMPILER_BARRIER();
    __atomic_store_n(&a->_v, v, __ATOMIC_SEQ_CST);
    V_COMPILER_BARRIER();
}

#endif /* VATOMIC8_WRITE */

#ifndef VATOMIC8_WRITE_REL
    #define VATOMIC8_WRITE_REL

static inline void
vatomic8_write_rel(vatomic8_t *a, vuint8_t v)
{
    V_COMPILER_BARRIER();
    __atomic_store_n(&a->_v, v, __ATOMIC_RELEASE);
    V_COMPILER_BARRIER();
}

#endif /* VATOMIC8_WRITE_REL */

#ifndef VATOMIC8_WRITE_RLX
    #define VATOMIC8_WRITE_RLX

static inline void
vatomic8_write_rlx(vatomic8_t *a, vuint8_t v)
{
    V_COMPILER_BARRIER();
    __atomic_store_n(&a->_v, v, __ATOMIC_RELAXED);
    V_COMPILER_BARRIER();
}

#endif /* VATOMIC8_WRITE_RLX */

#ifndef VATOMIC16_WRITE
    #define VATOMIC16_WRITE

static inline void
vatomic16_write(vatomic16_t *a, vuint16_t v)
{
    V_COMPILER_BARRIER();
    __atomic_store_n(&a->_v, v, __ATOMIC_SEQ_CST);
    V_COMPILER_BARRIER();
}

#endif /* VATOMIC16_WRITE */

#ifndef VATOMIC16_WRITE_REL
    #define VATOMIC16_WRITE_REL

static inline void
vatomic16_write_rel(vatomic16_t *a, vuint16_t v)
{
    V_COMPILER_BARRIER();
    __atomic_store_n(&a->_v, v, __ATOMIC_RELEASE);
    V_COMPILER_BARRIER();
}

#endif /* VATOMIC16_WRITE_REL */

#ifndef VATOMIC16_WRITE_RLX
    #define VATOMIC16_WRITE_RLX

static inline void
vatomic16_write_rlx(vatomic16_t *a, vuint16_t v)
{
    V_COMPILER_BARRIER();
    __atomic_store_n(&a->_v, v, __ATOMIC_RELAXED);
    V_COMPILER_BARRIER();
}

#endif /* VATOMIC16_WRITE_RLX */

#ifndef VATOMIC32_WRITE
    #define VATOMIC32_WRITE

static inline void
vatomic32_write(vatomic32_t *a, vuint32_t v)
{
    V_COMPILER_BARRIER();
    __atomic_store_n(&a->_v, v, __ATOMIC_SEQ_CST);
    V_COMPILER_BARRIER();
}

#endif /* VATOMIC32_WRITE */

#ifndef VATOMIC32_WRITE_REL
    #define VATOMIC32_WRITE_REL

static inline void
vatomic32_write_rel(vatomic32_t *a, vuint32_t v)
{
    V_COMPILER_BARRIER();
    __atomic_store_n(&a->_v, v, __ATOMIC_RELEASE);
    V_COMPILER_BARRIER();
}

#endif /* VATOMIC32_WRITE_REL */

#ifndef VATOMIC32_WRITE_RLX
    #define VATOMIC32_WRITE_RLX

static inline void
vatomic32_write_rlx(vatomic32_t *a, vuint32_t v)
{
    V_COMPILER_BARRIER();
    __atomic_store_n(&a->_v, v, __ATOMIC_RELAXED);
    V_COMPILER_BARRIER();
}

#endif /* VATOMIC32_WRITE_RLX */

#ifndef VATOMIC64_WRITE
    #define VATOMIC64_WRITE

static inline void
vatomic64_write(vatomic64_t *a, vuint64_t v)
{
    V_COMPILER_BARRIER();
    __atomic_store_n(&a->_v, v, __ATOMIC_SEQ_CST);
    V_COMPILER_BARRIER();
}

#endif /* VATOMIC64_WRITE */

#ifndef VATOMIC64_WRITE_REL
    #define VATOMIC64_WRITE_REL

static inline void
vatomic64_write_rel(vatomic64_t *a, vuint64_t v)
{
    V_COMPILER_BARRIER();
    __atomic_store_n(&a->_v, v, __ATOMIC_RELEASE);
    V_COMPILER_BARRIER();
}

#endif /* VATOMIC64_WRITE_REL */

#ifndef VATOMIC64_WRITE_RLX
    #define VATOMIC64_WRITE_RLX

static inline void
vatomic64_write_rlx(vatomic64_t *a, vuint64_t v)
{
    V_COMPILER_BARRIER();
    __atomic_store_n(&a->_v, v, __ATOMIC_RELAXED);
    V_COMPILER_BARRIER();
}

#endif /* VATOMIC64_WRITE_RLX */

#ifndef VATOMICSZ_WRITE
    #define VATOMICSZ_WRITE

static inline void
vatomicsz_write(vatomicsz_t *a, vsize_t v)
{
    V_COMPILER_BARRIER();
    __atomic_store_n(&a->_v, v, __ATOMIC_SEQ_CST);
    V_COMPILER_BARRIER();
}

#endif /* VATOMICSZ_WRITE */

#ifndef VATOMICSZ_WRITE_REL
    #define VATOMICSZ_WRITE_REL

static inline void
vatomicsz_write_rel(vatomicsz_t *a, vsize_t v)
{
    V_COMPILER_BARRIER();
    __atomic_store_n(&a->_v, v, __ATOMIC_RELEASE);
    V_COMPILER_BARRIER();
}

#endif /* VATOMICSZ_WRITE_REL */

#ifndef VATOMICSZ_WRITE_RLX
    #define VATOMICSZ_WRITE_RLX

static inline void
vatomicsz_write_rlx(vatomicsz_t *a, vsize_t v)
{
    V_COMPILER_BARRIER();
    __atomic_store_n(&a->_v, v, __ATOMIC_RELAXED);
    V_COMPILER_BARRIER();
}

#endif /* VATOMICSZ_WRITE_RLX */

#ifndef VATOMICPTR_WRITE
    #define VATOMICPTR_WRITE

static inline void
vatomicptr_write(vatomicptr_t *a, void *v)
{
    V_COMPILER_BARRIER();
    __atomic_store_n(&a->_v, v, __ATOMIC_SEQ_CST);
    V_COMPILER_BARRIER();
}

#endif /* VATOMICPTR_WRITE */

#ifndef VATOMICPTR_WRITE_REL
    #define VATOMICPTR_WRITE_REL

static inline void
vatomicptr_write_rel(vatomicptr_t *a, void *v)
{
    V_COMPILER_BARRIER();
    __atomic_store_n(&a->_v, v, __ATOMIC_RELEASE);
    V_COMPILER_BARRIER();
}

#endif /* VATOMICPTR_WRITE_REL */

#ifndef VATOMICPTR_WRITE_RLX
    #define VATOMICPTR_WRITE_RLX

static inline void
vatomicptr_write_rlx(vatomicptr_t *a, void *v)
{
    V_COMPILER_BARRIER();
    __atomic_store_n(&a->_v, v, __ATOMIC_RELAXED);
    V_COMPILER_BARRIER();
}

#endif /* VATOMICPTR_WRITE_RLX */

/* *****************************************************************************
 * vatomic_xchg
 * ****************************************************************************/

#ifndef VATOMIC8_XCHG
    #define VATOMIC8_XCHG

static inline vuint8_t
vatomic8_xchg(vatomic8_t *a, vuint8_t v)
{
    V_COMPILER_BARRIER();
    vuint8_t tmp =
        (vuint8_t)__atomic_exchange_n(&a->_v, (vuint8_t)v, __ATOMIC_SEQ_CST);
    V_COMPILER_BARRIER();
    return tmp;
}

#endif /* VATOMIC8_XCHG */

#ifndef VATOMIC8_XCHG_ACQ
    #define VATOMIC8_XCHG_ACQ

static inline vuint8_t
vatomic8_xchg_acq(vatomic8_t *a, vuint8_t v)
{
    V_COMPILER_BARRIER();
    vuint8_t tmp =
        (vuint8_t)__atomic_exchange_n(&a->_v, (vuint8_t)v, __ATOMIC_ACQUIRE);
    V_COMPILER_BARRIER();
    return tmp;
}

#endif /* VATOMIC8_XCHG_ACQ */

#ifndef VATOMIC8_XCHG_REL
    #define VATOMIC8_XCHG_REL

static inline vuint8_t
vatomic8_xchg_rel(vatomic8_t *a, vuint8_t v)
{
    V_COMPILER_BARRIER();
    vuint8_t tmp =
        (vuint8_t)__atomic_exchange_n(&a->_v, (vuint8_t)v, __ATOMIC_RELEASE);
    V_COMPILER_BARRIER();
    return tmp;
}

#endif /* VATOMIC8_XCHG_REL */

#ifndef VATOMIC8_XCHG_RLX
    #define VATOMIC8_XCHG_RLX

static inline vuint8_t
vatomic8_xchg_rlx(vatomic8_t *a, vuint8_t v)
{
    V_COMPILER_BARRIER();
    vuint8_t tmp =
        (vuint8_t)__atomic_exchange_n(&a->_v, (vuint8_t)v, __ATOMIC_RELAXED);
    V_COMPILER_BARRIER();
    return tmp;
}

#endif /* VATOMIC8_XCHG_RLX */

#ifndef VATOMIC16_XCHG
    #define VATOMIC16_XCHG

static inline vuint16_t
vatomic16_xchg(vatomic16_t *a, vuint16_t v)
{
    V_COMPILER_BARRIER();
    vuint16_t tmp =
        (vuint16_t)__atomic_exchange_n(&a->_v, (vuint16_t)v, __ATOMIC_SEQ_CST);
    V_COMPILER_BARRIER();
    return tmp;
}

#endif /* VATOMIC16_XCHG */

#ifndef VATOMIC16_XCHG_ACQ
    #define VATOMIC16_XCHG_ACQ

static inline vuint16_t
vatomic16_xchg_acq(vatomic16_t *a, vuint16_t v)
{
    V_COMPILER_BARRIER();
    vuint16_t tmp =
        (vuint16_t)__atomic_exchange_n(&a->_v, (vuint16_t)v, __ATOMIC_ACQUIRE);
    V_COMPILER_BARRIER();
    return tmp;
}

#endif /* VATOMIC16_XCHG_ACQ */

#ifndef VATOMIC16_XCHG_REL
    #define VATOMIC16_XCHG_REL

static inline vuint16_t
vatomic16_xchg_rel(vatomic16_t *a, vuint16_t v)
{
    V_COMPILER_BARRIER();
    vuint16_t tmp =
        (vuint16_t)__atomic_exchange_n(&a->_v, (vuint16_t)v, __ATOMIC_RELEASE);
    V_COMPILER_BARRIER();
    return tmp;
}

#endif /* VATOMIC16_XCHG_REL */

#ifndef VATOMIC16_XCHG_RLX
    #define VATOMIC16_XCHG_RLX

static inline vuint16_t
vatomic16_xchg_rlx(vatomic16_t *a, vuint16_t v)
{
    V_COMPILER_BARRIER();
    vuint16_t tmp =
        (vuint16_t)__atomic_exchange_n(&a->_v, (vuint16_t)v, __ATOMIC_RELAXED);
    V_COMPILER_BARRIER();
    return tmp;
}

#endif /* VATOMIC16_XCHG_RLX */

#ifndef VATOMIC32_XCHG
    #define VATOMIC32_XCHG

static inline vuint32_t
vatomic32_xchg(vatomic32_t *a, vuint32_t v)
{
    V_COMPILER_BARRIER();
    vuint32_t tmp =
        (vuint32_t)__atomic_exchange_n(&a->_v, (vuint32_t)v, __ATOMIC_SEQ_CST);
    V_COMPILER_BARRIER();
    return tmp;
}

#endif /* VATOMIC32_XCHG */

#ifndef VATOMIC32_XCHG_ACQ
    #define VATOMIC32_XCHG_ACQ

static inline vuint32_t
vatomic32_xchg_acq(vatomic32_t *a, vuint32_t v)
{
    V_COMPILER_BARRIER();
    vuint32_t tmp =
        (vuint32_t)__atomic_exchange_n(&a->_v, (vuint32_t)v, __ATOMIC_ACQUIRE);
    V_COMPILER_BARRIER();
    return tmp;
}

#endif /* VATOMIC32_XCHG_ACQ */

#ifndef VATOMIC32_XCHG_REL
    #define VATOMIC32_XCHG_REL

static inline vuint32_t
vatomic32_xchg_rel(vatomic32_t *a, vuint32_t v)
{
    V_COMPILER_BARRIER();
    vuint32_t tmp =
        (vuint32_t)__atomic_exchange_n(&a->_v, (vuint32_t)v, __ATOMIC_RELEASE);
    V_COMPILER_BARRIER();
    return tmp;
}

#endif /* VATOMIC32_XCHG_REL */

#ifndef VATOMIC32_XCHG_RLX
    #define VATOMIC32_XCHG_RLX

static inline vuint32_t
vatomic32_xchg_rlx(vatomic32_t *a, vuint32_t v)
{
    V_COMPILER_BARRIER();
    vuint32_t tmp =
        (vuint32_t)__atomic_exchange_n(&a->_v, (vuint32_t)v, __ATOMIC_RELAXED);
    V_COMPILER_BARRIER();
    return tmp;
}

#endif /* VATOMIC32_XCHG_RLX */

#ifndef VATOMIC64_XCHG
    #define VATOMIC64_XCHG

static inline vuint64_t
vatomic64_xchg(vatomic64_t *a, vuint64_t v)
{
    V_COMPILER_BARRIER();
    vuint64_t tmp =
        (vuint64_t)__atomic_exchange_n(&a->_v, (vuint64_t)v, __ATOMIC_SEQ_CST);
    V_COMPILER_BARRIER();
    return tmp;
}

#endif /* VATOMIC64_XCHG */

#ifndef VATOMIC64_XCHG_ACQ
    #define VATOMIC64_XCHG_ACQ

static inline vuint64_t
vatomic64_xchg_acq(vatomic64_t *a, vuint64_t v)
{
    V_COMPILER_BARRIER();
    vuint64_t tmp =
        (vuint64_t)__atomic_exchange_n(&a->_v, (vuint64_t)v, __ATOMIC_ACQUIRE);
    V_COMPILER_BARRIER();
    return tmp;
}

#endif /* VATOMIC64_XCHG_ACQ */

#ifndef VATOMIC64_XCHG_REL
    #define VATOMIC64_XCHG_REL

static inline vuint64_t
vatomic64_xchg_rel(vatomic64_t *a, vuint64_t v)
{
    V_COMPILER_BARRIER();
    vuint64_t tmp =
        (vuint64_t)__atomic_exchange_n(&a->_v, (vuint64_t)v, __ATOMIC_RELEASE);
    V_COMPILER_BARRIER();
    return tmp;
}

#endif /* VATOMIC64_XCHG_REL */

#ifndef VATOMIC64_XCHG_RLX
    #define VATOMIC64_XCHG_RLX

static inline vuint64_t
vatomic64_xchg_rlx(vatomic64_t *a, vuint64_t v)
{
    V_COMPILER_BARRIER();
    vuint64_t tmp =
        (vuint64_t)__atomic_exchange_n(&a->_v, (vuint64_t)v, __ATOMIC_RELAXED);
    V_COMPILER_BARRIER();
    return tmp;
}

#endif /* VATOMIC64_XCHG_RLX */

#ifndef VATOMICSZ_XCHG
    #define VATOMICSZ_XCHG

static inline vsize_t
vatomicsz_xchg(vatomicsz_t *a, vsize_t v)
{
    V_COMPILER_BARRIER();
    vsize_t tmp =
        (vsize_t)__atomic_exchange_n(&a->_v, (vsize_t)v, __ATOMIC_SEQ_CST);
    V_COMPILER_BARRIER();
    return tmp;
}

#endif /* VATOMICSZ_XCHG */

#ifndef VATOMICSZ_XCHG_ACQ
    #define VATOMICSZ_XCHG_ACQ

static inline vsize_t
vatomicsz_xchg_acq(vatomicsz_t *a, vsize_t v)
{
    V_COMPILER_BARRIER();
    vsize_t tmp =
        (vsize_t)__atomic_exchange_n(&a->_v, (vsize_t)v, __ATOMIC_ACQUIRE);
    V_COMPILER_BARRIER();
    return tmp;
}

#endif /* VATOMICSZ_XCHG_ACQ */

#ifndef VATOMICSZ_XCHG_REL
    #define VATOMICSZ_XCHG_REL

static inline vsize_t
vatomicsz_xchg_rel(vatomicsz_t *a, vsize_t v)
{
    V_COMPILER_BARRIER();
    vsize_t tmp =
        (vsize_t)__atomic_exchange_n(&a->_v, (vsize_t)v, __ATOMIC_RELEASE);
    V_COMPILER_BARRIER();
    return tmp;
}

#endif /* VATOMICSZ_XCHG_REL */

#ifndef VATOMICSZ_XCHG_RLX
    #define VATOMICSZ_XCHG_RLX

static inline vsize_t
vatomicsz_xchg_rlx(vatomicsz_t *a, vsize_t v)
{
    V_COMPILER_BARRIER();
    vsize_t tmp =
        (vsize_t)__atomic_exchange_n(&a->_v, (vsize_t)v, __ATOMIC_RELAXED);
    V_COMPILER_BARRIER();
    return tmp;
}

#endif /* VATOMICSZ_XCHG_RLX */

#ifndef VATOMICPTR_XCHG
    #define VATOMICPTR_XCHG

static inline void *
vatomicptr_xchg(vatomicptr_t *a, void *v)
{
    V_COMPILER_BARRIER();
    void *tmp =
        (void *)__atomic_exchange_n(&a->_v, (void *)v, __ATOMIC_SEQ_CST);
    V_COMPILER_BARRIER();
    return tmp;
}

#endif /* VATOMICPTR_XCHG */

#ifndef VATOMICPTR_XCHG_ACQ
    #define VATOMICPTR_XCHG_ACQ

static inline void *
vatomicptr_xchg_acq(vatomicptr_t *a, void *v)
{
    V_COMPILER_BARRIER();
    void *tmp =
        (void *)__atomic_exchange_n(&a->_v, (void *)v, __ATOMIC_ACQUIRE);
    V_COMPILER_BARRIER();
    return tmp;
}

#endif /* VATOMICPTR_XCHG_ACQ */

#ifndef VATOMICPTR_XCHG_REL
    #define VATOMICPTR_XCHG_REL

static inline void *
vatomicptr_xchg_rel(vatomicptr_t *a, void *v)
{
    V_COMPILER_BARRIER();
    void *tmp =
        (void *)__atomic_exchange_n(&a->_v, (void *)v, __ATOMIC_RELEASE);
    V_COMPILER_BARRIER();
    return tmp;
}

#endif /* VATOMICPTR_XCHG_REL */

#ifndef VATOMICPTR_XCHG_RLX
    #define VATOMICPTR_XCHG_RLX

static inline void *
vatomicptr_xchg_rlx(vatomicptr_t *a, void *v)
{
    V_COMPILER_BARRIER();
    void *tmp =
        (void *)__atomic_exchange_n(&a->_v, (void *)v, __ATOMIC_RELAXED);
    V_COMPILER_BARRIER();
    return tmp;
}

#endif /* VATOMICPTR_XCHG_RLX */

/* *****************************************************************************
 * vatomic_cmpxchg
 * ****************************************************************************/

#ifndef VATOMIC8_CMPXCHG
    #define VATOMIC8_CMPXCHG

static inline vuint8_t
vatomic8_cmpxchg(vatomic8_t *a, vuint8_t e, vuint8_t v)
{
    vuint8_t exp = (vuint8_t)e;
    V_COMPILER_BARRIER();
    __atomic_compare_exchange_n(&a->_v, &exp, (vuint8_t)v, 0, __ATOMIC_SEQ_CST,
                                __ATOMIC_SEQ_CST);
    V_COMPILER_BARRIER();
    return exp;
}

#endif /* VATOMIC8_CMPXCHG */

#ifndef VATOMIC8_CMPXCHG_ACQ
    #define VATOMIC8_CMPXCHG_ACQ

static inline vuint8_t
vatomic8_cmpxchg_acq(vatomic8_t *a, vuint8_t e, vuint8_t v)
{
    vuint8_t exp = (vuint8_t)e;
    V_COMPILER_BARRIER();
    __atomic_compare_exchange_n(&a->_v, &exp, (vuint8_t)v, 0, __ATOMIC_ACQUIRE,
                                __ATOMIC_ACQUIRE);
    V_COMPILER_BARRIER();
    return exp;
}

#endif /* VATOMIC8_CMPXCHG_ACQ */

#ifndef VATOMIC8_CMPXCHG_REL
    #define VATOMIC8_CMPXCHG_REL

static inline vuint8_t
vatomic8_cmpxchg_rel(vatomic8_t *a, vuint8_t e, vuint8_t v)
{
    vuint8_t exp = (vuint8_t)e;
    V_COMPILER_BARRIER();
    __atomic_compare_exchange_n(&a->_v, &exp, (vuint8_t)v, 0, __ATOMIC_RELEASE,
                                __ATOMIC_RELAXED);
    V_COMPILER_BARRIER();
    return exp;
}

#endif /* VATOMIC8_CMPXCHG_REL */

#ifndef VATOMIC8_CMPXCHG_RLX
    #define VATOMIC8_CMPXCHG_RLX

static inline vuint8_t
vatomic8_cmpxchg_rlx(vatomic8_t *a, vuint8_t e, vuint8_t v)
{
    vuint8_t exp = (vuint8_t)e;
    V_COMPILER_BARRIER();
    __atomic_compare_exchange_n(&a->_v, &exp, (vuint8_t)v, 0, __ATOMIC_RELAXED,
                                __ATOMIC_RELAXED);
    V_COMPILER_BARRIER();
    return exp;
}

#endif /* VATOMIC8_CMPXCHG_RLX */

#ifndef VATOMIC16_CMPXCHG
    #define VATOMIC16_CMPXCHG

static inline vuint16_t
vatomic16_cmpxchg(vatomic16_t *a, vuint16_t e, vuint16_t v)
{
    vuint16_t exp = (vuint16_t)e;
    V_COMPILER_BARRIER();
    __atomic_compare_exchange_n(&a->_v, &exp, (vuint16_t)v, 0, __ATOMIC_SEQ_CST,
                                __ATOMIC_SEQ_CST);
    V_COMPILER_BARRIER();
    return exp;
}

#endif /* VATOMIC16_CMPXCHG */

#ifndef VATOMIC16_CMPXCHG_ACQ
    #define VATOMIC16_CMPXCHG_ACQ

static inline vuint16_t
vatomic16_cmpxchg_acq(vatomic16_t *a, vuint16_t e, vuint16_t v)
{
    vuint16_t exp = (vuint16_t)e;
    V_COMPILER_BARRIER();
    __atomic_compare_exchange_n(&a->_v, &exp, (vuint16_t)v, 0, __ATOMIC_ACQUIRE,
                                __ATOMIC_ACQUIRE);
    V_COMPILER_BARRIER();
    return exp;
}

#endif /* VATOMIC16_CMPXCHG_ACQ */

#ifndef VATOMIC16_CMPXCHG_REL
    #define VATOMIC16_CMPXCHG_REL

static inline vuint16_t
vatomic16_cmpxchg_rel(vatomic16_t *a, vuint16_t e, vuint16_t v)
{
    vuint16_t exp = (vuint16_t)e;
    V_COMPILER_BARRIER();
    __atomic_compare_exchange_n(&a->_v, &exp, (vuint16_t)v, 0, __ATOMIC_RELEASE,
                                __ATOMIC_RELAXED);
    V_COMPILER_BARRIER();
    return exp;
}

#endif /* VATOMIC16_CMPXCHG_REL */

#ifndef VATOMIC16_CMPXCHG_RLX
    #define VATOMIC16_CMPXCHG_RLX

static inline vuint16_t
vatomic16_cmpxchg_rlx(vatomic16_t *a, vuint16_t e, vuint16_t v)
{
    vuint16_t exp = (vuint16_t)e;
    V_COMPILER_BARRIER();
    __atomic_compare_exchange_n(&a->_v, &exp, (vuint16_t)v, 0, __ATOMIC_RELAXED,
                                __ATOMIC_RELAXED);
    V_COMPILER_BARRIER();
    return exp;
}

#endif /* VATOMIC16_CMPXCHG_RLX */

#ifndef VATOMIC32_CMPXCHG
    #define VATOMIC32_CMPXCHG

static inline vuint32_t
vatomic32_cmpxchg(vatomic32_t *a, vuint32_t e, vuint32_t v)
{
    vuint32_t exp = (vuint32_t)e;
    V_COMPILER_BARRIER();
    __atomic_compare_exchange_n(&a->_v, &exp, (vuint32_t)v, 0, __ATOMIC_SEQ_CST,
                                __ATOMIC_SEQ_CST);
    V_COMPILER_BARRIER();
    return exp;
}

#endif /* VATOMIC32_CMPXCHG */

#ifndef VATOMIC32_CMPXCHG_ACQ
    #define VATOMIC32_CMPXCHG_ACQ

static inline vuint32_t
vatomic32_cmpxchg_acq(vatomic32_t *a, vuint32_t e, vuint32_t v)
{
    vuint32_t exp = (vuint32_t)e;
    V_COMPILER_BARRIER();
    __atomic_compare_exchange_n(&a->_v, &exp, (vuint32_t)v, 0, __ATOMIC_ACQUIRE,
                                __ATOMIC_ACQUIRE);
    V_COMPILER_BARRIER();
    return exp;
}

#endif /* VATOMIC32_CMPXCHG_ACQ */

#ifndef VATOMIC32_CMPXCHG_REL
    #define VATOMIC32_CMPXCHG_REL

static inline vuint32_t
vatomic32_cmpxchg_rel(vatomic32_t *a, vuint32_t e, vuint32_t v)
{
    vuint32_t exp = (vuint32_t)e;
    V_COMPILER_BARRIER();
    __atomic_compare_exchange_n(&a->_v, &exp, (vuint32_t)v, 0, __ATOMIC_RELEASE,
                                __ATOMIC_RELAXED);
    V_COMPILER_BARRIER();
    return exp;
}

#endif /* VATOMIC32_CMPXCHG_REL */

#ifndef VATOMIC32_CMPXCHG_RLX
    #define VATOMIC32_CMPXCHG_RLX

static inline vuint32_t
vatomic32_cmpxchg_rlx(vatomic32_t *a, vuint32_t e, vuint32_t v)
{
    vuint32_t exp = (vuint32_t)e;
    V_COMPILER_BARRIER();
    __atomic_compare_exchange_n(&a->_v, &exp, (vuint32_t)v, 0, __ATOMIC_RELAXED,
                                __ATOMIC_RELAXED);
    V_COMPILER_BARRIER();
    return exp;
}

#endif /* VATOMIC32_CMPXCHG_RLX */

#ifndef VATOMIC64_CMPXCHG
    #define VATOMIC64_CMPXCHG

static inline vuint64_t
vatomic64_cmpxchg(vatomic64_t *a, vuint64_t e, vuint64_t v)
{
    vuint64_t exp = (vuint64_t)e;
    V_COMPILER_BARRIER();
    __atomic_compare_exchange_n(&a->_v, &exp, (vuint64_t)v, 0, __ATOMIC_SEQ_CST,
                                __ATOMIC_SEQ_CST);
    V_COMPILER_BARRIER();
    return exp;
}

#endif /* VATOMIC64_CMPXCHG */

#ifndef VATOMIC64_CMPXCHG_ACQ
    #define VATOMIC64_CMPXCHG_ACQ

static inline vuint64_t
vatomic64_cmpxchg_acq(vatomic64_t *a, vuint64_t e, vuint64_t v)
{
    vuint64_t exp = (vuint64_t)e;
    V_COMPILER_BARRIER();
    __atomic_compare_exchange_n(&a->_v, &exp, (vuint64_t)v, 0, __ATOMIC_ACQUIRE,
                                __ATOMIC_ACQUIRE);
    V_COMPILER_BARRIER();
    return exp;
}

#endif /* VATOMIC64_CMPXCHG_ACQ */

#ifndef VATOMIC64_CMPXCHG_REL
    #define VATOMIC64_CMPXCHG_REL

static inline vuint64_t
vatomic64_cmpxchg_rel(vatomic64_t *a, vuint64_t e, vuint64_t v)
{
    vuint64_t exp = (vuint64_t)e;
    V_COMPILER_BARRIER();
    __atomic_compare_exchange_n(&a->_v, &exp, (vuint64_t)v, 0, __ATOMIC_RELEASE,
                                __ATOMIC_RELAXED);
    V_COMPILER_BARRIER();
    return exp;
}

#endif /* VATOMIC64_CMPXCHG_REL */

#ifndef VATOMIC64_CMPXCHG_RLX
    #define VATOMIC64_CMPXCHG_RLX

static inline vuint64_t
vatomic64_cmpxchg_rlx(vatomic64_t *a, vuint64_t e, vuint64_t v)
{
    vuint64_t exp = (vuint64_t)e;
    V_COMPILER_BARRIER();
    __atomic_compare_exchange_n(&a->_v, &exp, (vuint64_t)v, 0, __ATOMIC_RELAXED,
                                __ATOMIC_RELAXED);
    V_COMPILER_BARRIER();
    return exp;
}

#endif /* VATOMIC64_CMPXCHG_RLX */

#ifndef VATOMICSZ_CMPXCHG
    #define VATOMICSZ_CMPXCHG

static inline vsize_t
vatomicsz_cmpxchg(vatomicsz_t *a, vsize_t e, vsize_t v)
{
    vsize_t exp = (vsize_t)e;
    V_COMPILER_BARRIER();
    __atomic_compare_exchange_n(&a->_v, &exp, (vsize_t)v, 0, __ATOMIC_SEQ_CST,
                                __ATOMIC_SEQ_CST);
    V_COMPILER_BARRIER();
    return exp;
}

#endif /* VATOMICSZ_CMPXCHG */

#ifndef VATOMICSZ_CMPXCHG_ACQ
    #define VATOMICSZ_CMPXCHG_ACQ

static inline vsize_t
vatomicsz_cmpxchg_acq(vatomicsz_t *a, vsize_t e, vsize_t v)
{
    vsize_t exp = (vsize_t)e;
    V_COMPILER_BARRIER();
    __atomic_compare_exchange_n(&a->_v, &exp, (vsize_t)v, 0, __ATOMIC_ACQUIRE,
                                __ATOMIC_ACQUIRE);
    V_COMPILER_BARRIER();
    return exp;
}

#endif /* VATOMICSZ_CMPXCHG_ACQ */

#ifndef VATOMICSZ_CMPXCHG_REL
    #define VATOMICSZ_CMPXCHG_REL

static inline vsize_t
vatomicsz_cmpxchg_rel(vatomicsz_t *a, vsize_t e, vsize_t v)
{
    vsize_t exp = (vsize_t)e;
    V_COMPILER_BARRIER();
    __atomic_compare_exchange_n(&a->_v, &exp, (vsize_t)v, 0, __ATOMIC_RELEASE,
                                __ATOMIC_RELAXED);
    V_COMPILER_BARRIER();
    return exp;
}

#endif /* VATOMICSZ_CMPXCHG_REL */

#ifndef VATOMICSZ_CMPXCHG_RLX
    #define VATOMICSZ_CMPXCHG_RLX

static inline vsize_t
vatomicsz_cmpxchg_rlx(vatomicsz_t *a, vsize_t e, vsize_t v)
{
    vsize_t exp = (vsize_t)e;
    V_COMPILER_BARRIER();
    __atomic_compare_exchange_n(&a->_v, &exp, (vsize_t)v, 0, __ATOMIC_RELAXED,
                                __ATOMIC_RELAXED);
    V_COMPILER_BARRIER();
    return exp;
}

#endif /* VATOMICSZ_CMPXCHG_RLX */

#ifndef VATOMICPTR_CMPXCHG
    #define VATOMICPTR_CMPXCHG

static inline void *
vatomicptr_cmpxchg(vatomicptr_t *a, void *e, void *v)
{
    void *exp = (void *)e;
    V_COMPILER_BARRIER();
    __atomic_compare_exchange_n(&a->_v, &exp, (void *)v, 0, __ATOMIC_SEQ_CST,
                                __ATOMIC_SEQ_CST);
    V_COMPILER_BARRIER();
    return exp;
}

#endif /* VATOMICPTR_CMPXCHG */

#ifndef VATOMICPTR_CMPXCHG_ACQ
    #define VATOMICPTR_CMPXCHG_ACQ

static inline void *
vatomicptr_cmpxchg_acq(vatomicptr_t *a, void *e, void *v)
{
    void *exp = (void *)e;
    V_COMPILER_BARRIER();
    __atomic_compare_exchange_n(&a->_v, &exp, (void *)v, 0, __ATOMIC_ACQUIRE,
                                __ATOMIC_ACQUIRE);
    V_COMPILER_BARRIER();
    return exp;
}

#endif /* VATOMICPTR_CMPXCHG_ACQ */

#ifndef VATOMICPTR_CMPXCHG_REL
    #define VATOMICPTR_CMPXCHG_REL

static inline void *
vatomicptr_cmpxchg_rel(vatomicptr_t *a, void *e, void *v)
{
    void *exp = (void *)e;
    V_COMPILER_BARRIER();
    __atomic_compare_exchange_n(&a->_v, &exp, (void *)v, 0, __ATOMIC_RELEASE,
                                __ATOMIC_RELAXED);
    V_COMPILER_BARRIER();
    return exp;
}

#endif /* VATOMICPTR_CMPXCHG_REL */

#ifndef VATOMICPTR_CMPXCHG_RLX
    #define VATOMICPTR_CMPXCHG_RLX

static inline void *
vatomicptr_cmpxchg_rlx(vatomicptr_t *a, void *e, void *v)
{
    void *exp = (void *)e;
    V_COMPILER_BARRIER();
    __atomic_compare_exchange_n(&a->_v, &exp, (void *)v, 0, __ATOMIC_RELAXED,
                                __ATOMIC_RELAXED);
    V_COMPILER_BARRIER();
    return exp;
}

#endif /* VATOMICPTR_CMPXCHG_RLX */

/* *****************************************************************************
 * vatomic_get_and
 * ****************************************************************************/

#ifndef VATOMIC8_GET_AND
    #define VATOMIC8_GET_AND

static inline vuint8_t
vatomic8_get_and(vatomic8_t *a, vuint8_t v)
{
    V_COMPILER_BARRIER();
    vuint8_t tmp =
        (vuint8_t)__atomic_fetch_and(&a->_v, (vuint8_t)v, __ATOMIC_SEQ_CST);
    V_COMPILER_BARRIER();
    return tmp;
}

#endif /* VATOMIC8_GET_AND */

#ifndef VATOMIC8_GET_AND_ACQ
    #define VATOMIC8_GET_AND_ACQ

static inline vuint8_t
vatomic8_get_and_acq(vatomic8_t *a, vuint8_t v)
{
    V_COMPILER_BARRIER();
    vuint8_t tmp =
        (vuint8_t)__atomic_fetch_and(&a->_v, (vuint8_t)v, __ATOMIC_ACQUIRE);
    V_COMPILER_BARRIER();
    return tmp;
}

#endif /* VATOMIC8_GET_AND_ACQ */

#ifndef VATOMIC8_GET_AND_REL
    #define VATOMIC8_GET_AND_REL

static inline vuint8_t
vatomic8_get_and_rel(vatomic8_t *a, vuint8_t v)
{
    V_COMPILER_BARRIER();
    vuint8_t tmp =
        (vuint8_t)__atomic_fetch_and(&a->_v, (vuint8_t)v, __ATOMIC_RELEASE);
    V_COMPILER_BARRIER();
    return tmp;
}

#endif /* VATOMIC8_GET_AND_REL */

#ifndef VATOMIC8_GET_AND_RLX
    #define VATOMIC8_GET_AND_RLX

static inline vuint8_t
vatomic8_get_and_rlx(vatomic8_t *a, vuint8_t v)
{
    V_COMPILER_BARRIER();
    vuint8_t tmp =
        (vuint8_t)__atomic_fetch_and(&a->_v, (vuint8_t)v, __ATOMIC_RELAXED);
    V_COMPILER_BARRIER();
    return tmp;
}

#endif /* VATOMIC8_GET_AND_RLX */

#ifndef VATOMIC16_GET_AND
    #define VATOMIC16_GET_AND

static inline vuint16_t
vatomic16_get_and(vatomic16_t *a, vuint16_t v)
{
    V_COMPILER_BARRIER();
    vuint16_t tmp =
        (vuint16_t)__atomic_fetch_and(&a->_v, (vuint16_t)v, __ATOMIC_SEQ_CST);
    V_COMPILER_BARRIER();
    return tmp;
}

#endif /* VATOMIC16_GET_AND */

#ifndef VATOMIC16_GET_AND_ACQ
    #define VATOMIC16_GET_AND_ACQ

static inline vuint16_t
vatomic16_get_and_acq(vatomic16_t *a, vuint16_t v)
{
    V_COMPILER_BARRIER();
    vuint16_t tmp =
        (vuint16_t)__atomic_fetch_and(&a->_v, (vuint16_t)v, __ATOMIC_ACQUIRE);
    V_COMPILER_BARRIER();
    return tmp;
}

#endif /* VATOMIC16_GET_AND_ACQ */

#ifndef VATOMIC16_GET_AND_REL
    #define VATOMIC16_GET_AND_REL

static inline vuint16_t
vatomic16_get_and_rel(vatomic16_t *a, vuint16_t v)
{
    V_COMPILER_BARRIER();
    vuint16_t tmp =
        (vuint16_t)__atomic_fetch_and(&a->_v, (vuint16_t)v, __ATOMIC_RELEASE);
    V_COMPILER_BARRIER();
    return tmp;
}

#endif /* VATOMIC16_GET_AND_REL */

#ifndef VATOMIC16_GET_AND_RLX
    #define VATOMIC16_GET_AND_RLX

static inline vuint16_t
vatomic16_get_and_rlx(vatomic16_t *a, vuint16_t v)
{
    V_COMPILER_BARRIER();
    vuint16_t tmp =
        (vuint16_t)__atomic_fetch_and(&a->_v, (vuint16_t)v, __ATOMIC_RELAXED);
    V_COMPILER_BARRIER();
    return tmp;
}

#endif /* VATOMIC16_GET_AND_RLX */

#ifndef VATOMIC32_GET_AND
    #define VATOMIC32_GET_AND

static inline vuint32_t
vatomic32_get_and(vatomic32_t *a, vuint32_t v)
{
    V_COMPILER_BARRIER();
    vuint32_t tmp =
        (vuint32_t)__atomic_fetch_and(&a->_v, (vuint32_t)v, __ATOMIC_SEQ_CST);
    V_COMPILER_BARRIER();
    return tmp;
}

#endif /* VATOMIC32_GET_AND */

#ifndef VATOMIC32_GET_AND_ACQ
    #define VATOMIC32_GET_AND_ACQ

static inline vuint32_t
vatomic32_get_and_acq(vatomic32_t *a, vuint32_t v)
{
    V_COMPILER_BARRIER();
    vuint32_t tmp =
        (vuint32_t)__atomic_fetch_and(&a->_v, (vuint32_t)v, __ATOMIC_ACQUIRE);
    V_COMPILER_BARRIER();
    return tmp;
}

#endif /* VATOMIC32_GET_AND_ACQ */

#ifndef VATOMIC32_GET_AND_REL
    #define VATOMIC32_GET_AND_REL

static inline vuint32_t
vatomic32_get_and_rel(vatomic32_t *a, vuint32_t v)
{
    V_COMPILER_BARRIER();
    vuint32_t tmp =
        (vuint32_t)__atomic_fetch_and(&a->_v, (vuint32_t)v, __ATOMIC_RELEASE);
    V_COMPILER_BARRIER();
    return tmp;
}

#endif /* VATOMIC32_GET_AND_REL */

#ifndef VATOMIC32_GET_AND_RLX
    #define VATOMIC32_GET_AND_RLX

static inline vuint32_t
vatomic32_get_and_rlx(vatomic32_t *a, vuint32_t v)
{
    V_COMPILER_BARRIER();
    vuint32_t tmp =
        (vuint32_t)__atomic_fetch_and(&a->_v, (vuint32_t)v, __ATOMIC_RELAXED);
    V_COMPILER_BARRIER();
    return tmp;
}

#endif /* VATOMIC32_GET_AND_RLX */

#ifndef VATOMIC64_GET_AND
    #define VATOMIC64_GET_AND

static inline vuint64_t
vatomic64_get_and(vatomic64_t *a, vuint64_t v)
{
    V_COMPILER_BARRIER();
    vuint64_t tmp =
        (vuint64_t)__atomic_fetch_and(&a->_v, (vuint64_t)v, __ATOMIC_SEQ_CST);
    V_COMPILER_BARRIER();
    return tmp;
}

#endif /* VATOMIC64_GET_AND */

#ifndef VATOMIC64_GET_AND_ACQ
    #define VATOMIC64_GET_AND_ACQ

static inline vuint64_t
vatomic64_get_and_acq(vatomic64_t *a, vuint64_t v)
{
    V_COMPILER_BARRIER();
    vuint64_t tmp =
        (vuint64_t)__atomic_fetch_and(&a->_v, (vuint64_t)v, __ATOMIC_ACQUIRE);
    V_COMPILER_BARRIER();
    return tmp;
}

#endif /* VATOMIC64_GET_AND_ACQ */

#ifndef VATOMIC64_GET_AND_REL
    #define VATOMIC64_GET_AND_REL

static inline vuint64_t
vatomic64_get_and_rel(vatomic64_t *a, vuint64_t v)
{
    V_COMPILER_BARRIER();
    vuint64_t tmp =
        (vuint64_t)__atomic_fetch_and(&a->_v, (vuint64_t)v, __ATOMIC_RELEASE);
    V_COMPILER_BARRIER();
    return tmp;
}

#endif /* VATOMIC64_GET_AND_REL */

#ifndef VATOMIC64_GET_AND_RLX
    #define VATOMIC64_GET_AND_RLX

static inline vuint64_t
vatomic64_get_and_rlx(vatomic64_t *a, vuint64_t v)
{
    V_COMPILER_BARRIER();
    vuint64_t tmp =
        (vuint64_t)__atomic_fetch_and(&a->_v, (vuint64_t)v, __ATOMIC_RELAXED);
    V_COMPILER_BARRIER();
    return tmp;
}

#endif /* VATOMIC64_GET_AND_RLX */

#ifndef VATOMICSZ_GET_AND
    #define VATOMICSZ_GET_AND

static inline vsize_t
vatomicsz_get_and(vatomicsz_t *a, vsize_t v)
{
    V_COMPILER_BARRIER();
    vsize_t tmp =
        (vsize_t)__atomic_fetch_and(&a->_v, (vsize_t)v, __ATOMIC_SEQ_CST);
    V_COMPILER_BARRIER();
    return tmp;
}

#endif /* VATOMICSZ_GET_AND */

#ifndef VATOMICSZ_GET_AND_ACQ
    #define VATOMICSZ_GET_AND_ACQ

static inline vsize_t
vatomicsz_get_and_acq(vatomicsz_t *a, vsize_t v)
{
    V_COMPILER_BARRIER();
    vsize_t tmp =
        (vsize_t)__atomic_fetch_and(&a->_v, (vsize_t)v, __ATOMIC_ACQUIRE);
    V_COMPILER_BARRIER();
    return tmp;
}

#endif /* VATOMICSZ_GET_AND_ACQ */

#ifndef VATOMICSZ_GET_AND_REL
    #define VATOMICSZ_GET_AND_REL

static inline vsize_t
vatomicsz_get_and_rel(vatomicsz_t *a, vsize_t v)
{
    V_COMPILER_BARRIER();
    vsize_t tmp =
        (vsize_t)__atomic_fetch_and(&a->_v, (vsize_t)v, __ATOMIC_RELEASE);
    V_COMPILER_BARRIER();
    return tmp;
}

#endif /* VATOMICSZ_GET_AND_REL */

#ifndef VATOMICSZ_GET_AND_RLX
    #define VATOMICSZ_GET_AND_RLX

static inline vsize_t
vatomicsz_get_and_rlx(vatomicsz_t *a, vsize_t v)
{
    V_COMPILER_BARRIER();
    vsize_t tmp =
        (vsize_t)__atomic_fetch_and(&a->_v, (vsize_t)v, __ATOMIC_RELAXED);
    V_COMPILER_BARRIER();
    return tmp;
}

#endif /* VATOMICSZ_GET_AND_RLX */

/* *****************************************************************************
 * vatomic_get_or
 * ****************************************************************************/

#ifndef VATOMIC8_GET_OR
    #define VATOMIC8_GET_OR

static inline vuint8_t
vatomic8_get_or(vatomic8_t *a, vuint8_t v)
{
    V_COMPILER_BARRIER();
    vuint8_t tmp =
        (vuint8_t)__atomic_fetch_or(&a->_v, (vuint8_t)v, __ATOMIC_SEQ_CST);
    V_COMPILER_BARRIER();
    return tmp;
}

#endif /* VATOMIC8_GET_OR */

#ifndef VATOMIC8_GET_OR_ACQ
    #define VATOMIC8_GET_OR_ACQ

static inline vuint8_t
vatomic8_get_or_acq(vatomic8_t *a, vuint8_t v)
{
    V_COMPILER_BARRIER();
    vuint8_t tmp =
        (vuint8_t)__atomic_fetch_or(&a->_v, (vuint8_t)v, __ATOMIC_ACQUIRE);
    V_COMPILER_BARRIER();
    return tmp;
}

#endif /* VATOMIC8_GET_OR_ACQ */

#ifndef VATOMIC8_GET_OR_REL
    #define VATOMIC8_GET_OR_REL

static inline vuint8_t
vatomic8_get_or_rel(vatomic8_t *a, vuint8_t v)
{
    V_COMPILER_BARRIER();
    vuint8_t tmp =
        (vuint8_t)__atomic_fetch_or(&a->_v, (vuint8_t)v, __ATOMIC_RELEASE);
    V_COMPILER_BARRIER();
    return tmp;
}

#endif /* VATOMIC8_GET_OR_REL */

#ifndef VATOMIC8_GET_OR_RLX
    #define VATOMIC8_GET_OR_RLX

static inline vuint8_t
vatomic8_get_or_rlx(vatomic8_t *a, vuint8_t v)
{
    V_COMPILER_BARRIER();
    vuint8_t tmp =
        (vuint8_t)__atomic_fetch_or(&a->_v, (vuint8_t)v, __ATOMIC_RELAXED);
    V_COMPILER_BARRIER();
    return tmp;
}

#endif /* VATOMIC8_GET_OR_RLX */

#ifndef VATOMIC16_GET_OR
    #define VATOMIC16_GET_OR

static inline vuint16_t
vatomic16_get_or(vatomic16_t *a, vuint16_t v)
{
    V_COMPILER_BARRIER();
    vuint16_t tmp =
        (vuint16_t)__atomic_fetch_or(&a->_v, (vuint16_t)v, __ATOMIC_SEQ_CST);
    V_COMPILER_BARRIER();
    return tmp;
}

#endif /* VATOMIC16_GET_OR */

#ifndef VATOMIC16_GET_OR_ACQ
    #define VATOMIC16_GET_OR_ACQ

static inline vuint16_t
vatomic16_get_or_acq(vatomic16_t *a, vuint16_t v)
{
    V_COMPILER_BARRIER();
    vuint16_t tmp =
        (vuint16_t)__atomic_fetch_or(&a->_v, (vuint16_t)v, __ATOMIC_ACQUIRE);
    V_COMPILER_BARRIER();
    return tmp;
}

#endif /* VATOMIC16_GET_OR_ACQ */

#ifndef VATOMIC16_GET_OR_REL
    #define VATOMIC16_GET_OR_REL

static inline vuint16_t
vatomic16_get_or_rel(vatomic16_t *a, vuint16_t v)
{
    V_COMPILER_BARRIER();
    vuint16_t tmp =
        (vuint16_t)__atomic_fetch_or(&a->_v, (vuint16_t)v, __ATOMIC_RELEASE);
    V_COMPILER_BARRIER();
    return tmp;
}

#endif /* VATOMIC16_GET_OR_REL */

#ifndef VATOMIC16_GET_OR_RLX
    #define VATOMIC16_GET_OR_RLX

static inline vuint16_t
vatomic16_get_or_rlx(vatomic16_t *a, vuint16_t v)
{
    V_COMPILER_BARRIER();
    vuint16_t tmp =
        (vuint16_t)__atomic_fetch_or(&a->_v, (vuint16_t)v, __ATOMIC_RELAXED);
    V_COMPILER_BARRIER();
    return tmp;
}

#endif /* VATOMIC16_GET_OR_RLX */

#ifndef VATOMIC32_GET_OR
    #define VATOMIC32_GET_OR

static inline vuint32_t
vatomic32_get_or(vatomic32_t *a, vuint32_t v)
{
    V_COMPILER_BARRIER();
    vuint32_t tmp =
        (vuint32_t)__atomic_fetch_or(&a->_v, (vuint32_t)v, __ATOMIC_SEQ_CST);
    V_COMPILER_BARRIER();
    return tmp;
}

#endif /* VATOMIC32_GET_OR */

#ifndef VATOMIC32_GET_OR_ACQ
    #define VATOMIC32_GET_OR_ACQ

static inline vuint32_t
vatomic32_get_or_acq(vatomic32_t *a, vuint32_t v)
{
    V_COMPILER_BARRIER();
    vuint32_t tmp =
        (vuint32_t)__atomic_fetch_or(&a->_v, (vuint32_t)v, __ATOMIC_ACQUIRE);
    V_COMPILER_BARRIER();
    return tmp;
}

#endif /* VATOMIC32_GET_OR_ACQ */

#ifndef VATOMIC32_GET_OR_REL
    #define VATOMIC32_GET_OR_REL

static inline vuint32_t
vatomic32_get_or_rel(vatomic32_t *a, vuint32_t v)
{
    V_COMPILER_BARRIER();
    vuint32_t tmp =
        (vuint32_t)__atomic_fetch_or(&a->_v, (vuint32_t)v, __ATOMIC_RELEASE);
    V_COMPILER_BARRIER();
    return tmp;
}

#endif /* VATOMIC32_GET_OR_REL */

#ifndef VATOMIC32_GET_OR_RLX
    #define VATOMIC32_GET_OR_RLX

static inline vuint32_t
vatomic32_get_or_rlx(vatomic32_t *a, vuint32_t v)
{
    V_COMPILER_BARRIER();
    vuint32_t tmp =
        (vuint32_t)__atomic_fetch_or(&a->_v, (vuint32_t)v, __ATOMIC_RELAXED);
    V_COMPILER_BARRIER();
    return tmp;
}

#endif /* VATOMIC32_GET_OR_RLX */

#ifndef VATOMIC64_GET_OR
    #define VATOMIC64_GET_OR

static inline vuint64_t
vatomic64_get_or(vatomic64_t *a, vuint64_t v)
{
    V_COMPILER_BARRIER();
    vuint64_t tmp =
        (vuint64_t)__atomic_fetch_or(&a->_v, (vuint64_t)v, __ATOMIC_SEQ_CST);
    V_COMPILER_BARRIER();
    return tmp;
}

#endif /* VATOMIC64_GET_OR */

#ifndef VATOMIC64_GET_OR_ACQ
    #define VATOMIC64_GET_OR_ACQ

static inline vuint64_t
vatomic64_get_or_acq(vatomic64_t *a, vuint64_t v)
{
    V_COMPILER_BARRIER();
    vuint64_t tmp =
        (vuint64_t)__atomic_fetch_or(&a->_v, (vuint64_t)v, __ATOMIC_ACQUIRE);
    V_COMPILER_BARRIER();
    return tmp;
}

#endif /* VATOMIC64_GET_OR_ACQ */

#ifndef VATOMIC64_GET_OR_REL
    #define VATOMIC64_GET_OR_REL

static inline vuint64_t
vatomic64_get_or_rel(vatomic64_t *a, vuint64_t v)
{
    V_COMPILER_BARRIER();
    vuint64_t tmp =
        (vuint64_t)__atomic_fetch_or(&a->_v, (vuint64_t)v, __ATOMIC_RELEASE);
    V_COMPILER_BARRIER();
    return tmp;
}

#endif /* VATOMIC64_GET_OR_REL */

#ifndef VATOMIC64_GET_OR_RLX
    #define VATOMIC64_GET_OR_RLX

static inline vuint64_t
vatomic64_get_or_rlx(vatomic64_t *a, vuint64_t v)
{
    V_COMPILER_BARRIER();
    vuint64_t tmp =
        (vuint64_t)__atomic_fetch_or(&a->_v, (vuint64_t)v, __ATOMIC_RELAXED);
    V_COMPILER_BARRIER();
    return tmp;
}

#endif /* VATOMIC64_GET_OR_RLX */

#ifndef VATOMICSZ_GET_OR
    #define VATOMICSZ_GET_OR

static inline vsize_t
vatomicsz_get_or(vatomicsz_t *a, vsize_t v)
{
    V_COMPILER_BARRIER();
    vsize_t tmp =
        (vsize_t)__atomic_fetch_or(&a->_v, (vsize_t)v, __ATOMIC_SEQ_CST);
    V_COMPILER_BARRIER();
    return tmp;
}

#endif /* VATOMICSZ_GET_OR */

#ifndef VATOMICSZ_GET_OR_ACQ
    #define VATOMICSZ_GET_OR_ACQ

static inline vsize_t
vatomicsz_get_or_acq(vatomicsz_t *a, vsize_t v)
{
    V_COMPILER_BARRIER();
    vsize_t tmp =
        (vsize_t)__atomic_fetch_or(&a->_v, (vsize_t)v, __ATOMIC_ACQUIRE);
    V_COMPILER_BARRIER();
    return tmp;
}

#endif /* VATOMICSZ_GET_OR_ACQ */

#ifndef VATOMICSZ_GET_OR_REL
    #define VATOMICSZ_GET_OR_REL

static inline vsize_t
vatomicsz_get_or_rel(vatomicsz_t *a, vsize_t v)
{
    V_COMPILER_BARRIER();
    vsize_t tmp =
        (vsize_t)__atomic_fetch_or(&a->_v, (vsize_t)v, __ATOMIC_RELEASE);
    V_COMPILER_BARRIER();
    return tmp;
}

#endif /* VATOMICSZ_GET_OR_REL */

#ifndef VATOMICSZ_GET_OR_RLX
    #define VATOMICSZ_GET_OR_RLX

static inline vsize_t
vatomicsz_get_or_rlx(vatomicsz_t *a, vsize_t v)
{
    V_COMPILER_BARRIER();
    vsize_t tmp =
        (vsize_t)__atomic_fetch_or(&a->_v, (vsize_t)v, __ATOMIC_RELAXED);
    V_COMPILER_BARRIER();
    return tmp;
}

#endif /* VATOMICSZ_GET_OR_RLX */

/* *****************************************************************************
 * vatomic_get_xor
 * ****************************************************************************/

#ifndef VATOMIC8_GET_XOR
    #define VATOMIC8_GET_XOR

static inline vuint8_t
vatomic8_get_xor(vatomic8_t *a, vuint8_t v)
{
    V_COMPILER_BARRIER();
    vuint8_t tmp =
        (vuint8_t)__atomic_fetch_xor(&a->_v, (vuint8_t)v, __ATOMIC_SEQ_CST);
    V_COMPILER_BARRIER();
    return tmp;
}

#endif /* VATOMIC8_GET_XOR */

#ifndef VATOMIC8_GET_XOR_ACQ
    #define VATOMIC8_GET_XOR_ACQ

static inline vuint8_t
vatomic8_get_xor_acq(vatomic8_t *a, vuint8_t v)
{
    V_COMPILER_BARRIER();
    vuint8_t tmp =
        (vuint8_t)__atomic_fetch_xor(&a->_v, (vuint8_t)v, __ATOMIC_ACQUIRE);
    V_COMPILER_BARRIER();
    return tmp;
}

#endif /* VATOMIC8_GET_XOR_ACQ */

#ifndef VATOMIC8_GET_XOR_REL
    #define VATOMIC8_GET_XOR_REL

static inline vuint8_t
vatomic8_get_xor_rel(vatomic8_t *a, vuint8_t v)
{
    V_COMPILER_BARRIER();
    vuint8_t tmp =
        (vuint8_t)__atomic_fetch_xor(&a->_v, (vuint8_t)v, __ATOMIC_RELEASE);
    V_COMPILER_BARRIER();
    return tmp;
}

#endif /* VATOMIC8_GET_XOR_REL */

#ifndef VATOMIC8_GET_XOR_RLX
    #define VATOMIC8_GET_XOR_RLX

static inline vuint8_t
vatomic8_get_xor_rlx(vatomic8_t *a, vuint8_t v)
{
    V_COMPILER_BARRIER();
    vuint8_t tmp =
        (vuint8_t)__atomic_fetch_xor(&a->_v, (vuint8_t)v, __ATOMIC_RELAXED);
    V_COMPILER_BARRIER();
    return tmp;
}

#endif /* VATOMIC8_GET_XOR_RLX */

#ifndef VATOMIC16_GET_XOR
    #define VATOMIC16_GET_XOR

static inline vuint16_t
vatomic16_get_xor(vatomic16_t *a, vuint16_t v)
{
    V_COMPILER_BARRIER();
    vuint16_t tmp =
        (vuint16_t)__atomic_fetch_xor(&a->_v, (vuint16_t)v, __ATOMIC_SEQ_CST);
    V_COMPILER_BARRIER();
    return tmp;
}

#endif /* VATOMIC16_GET_XOR */

#ifndef VATOMIC16_GET_XOR_ACQ
    #define VATOMIC16_GET_XOR_ACQ

static inline vuint16_t
vatomic16_get_xor_acq(vatomic16_t *a, vuint16_t v)
{
    V_COMPILER_BARRIER();
    vuint16_t tmp =
        (vuint16_t)__atomic_fetch_xor(&a->_v, (vuint16_t)v, __ATOMIC_ACQUIRE);
    V_COMPILER_BARRIER();
    return tmp;
}

#endif /* VATOMIC16_GET_XOR_ACQ */

#ifndef VATOMIC16_GET_XOR_REL
    #define VATOMIC16_GET_XOR_REL

static inline vuint16_t
vatomic16_get_xor_rel(vatomic16_t *a, vuint16_t v)
{
    V_COMPILER_BARRIER();
    vuint16_t tmp =
        (vuint16_t)__atomic_fetch_xor(&a->_v, (vuint16_t)v, __ATOMIC_RELEASE);
    V_COMPILER_BARRIER();
    return tmp;
}

#endif /* VATOMIC16_GET_XOR_REL */

#ifndef VATOMIC16_GET_XOR_RLX
    #define VATOMIC16_GET_XOR_RLX

static inline vuint16_t
vatomic16_get_xor_rlx(vatomic16_t *a, vuint16_t v)
{
    V_COMPILER_BARRIER();
    vuint16_t tmp =
        (vuint16_t)__atomic_fetch_xor(&a->_v, (vuint16_t)v, __ATOMIC_RELAXED);
    V_COMPILER_BARRIER();
    return tmp;
}

#endif /* VATOMIC16_GET_XOR_RLX */

#ifndef VATOMIC32_GET_XOR
    #define VATOMIC32_GET_XOR

static inline vuint32_t
vatomic32_get_xor(vatomic32_t *a, vuint32_t v)
{
    V_COMPILER_BARRIER();
    vuint32_t tmp =
        (vuint32_t)__atomic_fetch_xor(&a->_v, (vuint32_t)v, __ATOMIC_SEQ_CST);
    V_COMPILER_BARRIER();
    return tmp;
}

#endif /* VATOMIC32_GET_XOR */

#ifndef VATOMIC32_GET_XOR_ACQ
    #define VATOMIC32_GET_XOR_ACQ

static inline vuint32_t
vatomic32_get_xor_acq(vatomic32_t *a, vuint32_t v)
{
    V_COMPILER_BARRIER();
    vuint32_t tmp =
        (vuint32_t)__atomic_fetch_xor(&a->_v, (vuint32_t)v, __ATOMIC_ACQUIRE);
    V_COMPILER_BARRIER();
    return tmp;
}

#endif /* VATOMIC32_GET_XOR_ACQ */

#ifndef VATOMIC32_GET_XOR_REL
    #define VATOMIC32_GET_XOR_REL

static inline vuint32_t
vatomic32_get_xor_rel(vatomic32_t *a, vuint32_t v)
{
    V_COMPILER_BARRIER();
    vuint32_t tmp =
        (vuint32_t)__atomic_fetch_xor(&a->_v, (vuint32_t)v, __ATOMIC_RELEASE);
    V_COMPILER_BARRIER();
    return tmp;
}

#endif /* VATOMIC32_GET_XOR_REL */

#ifndef VATOMIC32_GET_XOR_RLX
    #define VATOMIC32_GET_XOR_RLX

static inline vuint32_t
vatomic32_get_xor_rlx(vatomic32_t *a, vuint32_t v)
{
    V_COMPILER_BARRIER();
    vuint32_t tmp =
        (vuint32_t)__atomic_fetch_xor(&a->_v, (vuint32_t)v, __ATOMIC_RELAXED);
    V_COMPILER_BARRIER();
    return tmp;
}

#endif /* VATOMIC32_GET_XOR_RLX */

#ifndef VATOMIC64_GET_XOR
    #define VATOMIC64_GET_XOR

static inline vuint64_t
vatomic64_get_xor(vatomic64_t *a, vuint64_t v)
{
    V_COMPILER_BARRIER();
    vuint64_t tmp =
        (vuint64_t)__atomic_fetch_xor(&a->_v, (vuint64_t)v, __ATOMIC_SEQ_CST);
    V_COMPILER_BARRIER();
    return tmp;
}

#endif /* VATOMIC64_GET_XOR */

#ifndef VATOMIC64_GET_XOR_ACQ
    #define VATOMIC64_GET_XOR_ACQ

static inline vuint64_t
vatomic64_get_xor_acq(vatomic64_t *a, vuint64_t v)
{
    V_COMPILER_BARRIER();
    vuint64_t tmp =
        (vuint64_t)__atomic_fetch_xor(&a->_v, (vuint64_t)v, __ATOMIC_ACQUIRE);
    V_COMPILER_BARRIER();
    return tmp;
}

#endif /* VATOMIC64_GET_XOR_ACQ */

#ifndef VATOMIC64_GET_XOR_REL
    #define VATOMIC64_GET_XOR_REL

static inline vuint64_t
vatomic64_get_xor_rel(vatomic64_t *a, vuint64_t v)
{
    V_COMPILER_BARRIER();
    vuint64_t tmp =
        (vuint64_t)__atomic_fetch_xor(&a->_v, (vuint64_t)v, __ATOMIC_RELEASE);
    V_COMPILER_BARRIER();
    return tmp;
}

#endif /* VATOMIC64_GET_XOR_REL */

#ifndef VATOMIC64_GET_XOR_RLX
    #define VATOMIC64_GET_XOR_RLX

static inline vuint64_t
vatomic64_get_xor_rlx(vatomic64_t *a, vuint64_t v)
{
    V_COMPILER_BARRIER();
    vuint64_t tmp =
        (vuint64_t)__atomic_fetch_xor(&a->_v, (vuint64_t)v, __ATOMIC_RELAXED);
    V_COMPILER_BARRIER();
    return tmp;
}

#endif /* VATOMIC64_GET_XOR_RLX */

#ifndef VATOMICSZ_GET_XOR
    #define VATOMICSZ_GET_XOR

static inline vsize_t
vatomicsz_get_xor(vatomicsz_t *a, vsize_t v)
{
    V_COMPILER_BARRIER();
    vsize_t tmp =
        (vsize_t)__atomic_fetch_xor(&a->_v, (vsize_t)v, __ATOMIC_SEQ_CST);
    V_COMPILER_BARRIER();
    return tmp;
}

#endif /* VATOMICSZ_GET_XOR */

#ifndef VATOMICSZ_GET_XOR_ACQ
    #define VATOMICSZ_GET_XOR_ACQ

static inline vsize_t
vatomicsz_get_xor_acq(vatomicsz_t *a, vsize_t v)
{
    V_COMPILER_BARRIER();
    vsize_t tmp =
        (vsize_t)__atomic_fetch_xor(&a->_v, (vsize_t)v, __ATOMIC_ACQUIRE);
    V_COMPILER_BARRIER();
    return tmp;
}

#endif /* VATOMICSZ_GET_XOR_ACQ */

#ifndef VATOMICSZ_GET_XOR_REL
    #define VATOMICSZ_GET_XOR_REL

static inline vsize_t
vatomicsz_get_xor_rel(vatomicsz_t *a, vsize_t v)
{
    V_COMPILER_BARRIER();
    vsize_t tmp =
        (vsize_t)__atomic_fetch_xor(&a->_v, (vsize_t)v, __ATOMIC_RELEASE);
    V_COMPILER_BARRIER();
    return tmp;
}

#endif /* VATOMICSZ_GET_XOR_REL */

#ifndef VATOMICSZ_GET_XOR_RLX
    #define VATOMICSZ_GET_XOR_RLX

static inline vsize_t
vatomicsz_get_xor_rlx(vatomicsz_t *a, vsize_t v)
{
    V_COMPILER_BARRIER();
    vsize_t tmp =
        (vsize_t)__atomic_fetch_xor(&a->_v, (vsize_t)v, __ATOMIC_RELAXED);
    V_COMPILER_BARRIER();
    return tmp;
}

#endif /* VATOMICSZ_GET_XOR_RLX */

/* *****************************************************************************
 * vatomic_get_add
 * ****************************************************************************/

#ifndef VATOMIC8_GET_ADD
    #define VATOMIC8_GET_ADD

static inline vuint8_t
vatomic8_get_add(vatomic8_t *a, vuint8_t v)
{
    V_COMPILER_BARRIER();
    vuint8_t tmp = (vuint8_t)__atomic_fetch_add(&a->_v, v, __ATOMIC_SEQ_CST);
    V_COMPILER_BARRIER();
    return tmp;
}

#endif /* VATOMIC8_GET_ADD */

#ifndef VATOMIC8_GET_ADD_ACQ
    #define VATOMIC8_GET_ADD_ACQ

static inline vuint8_t
vatomic8_get_add_acq(vatomic8_t *a, vuint8_t v)
{
    V_COMPILER_BARRIER();
    vuint8_t tmp = (vuint8_t)__atomic_fetch_add(&a->_v, v, __ATOMIC_ACQUIRE);
    V_COMPILER_BARRIER();
    return tmp;
}

#endif /* VATOMIC8_GET_ADD_ACQ */

#ifndef VATOMIC8_GET_ADD_REL
    #define VATOMIC8_GET_ADD_REL

static inline vuint8_t
vatomic8_get_add_rel(vatomic8_t *a, vuint8_t v)
{
    V_COMPILER_BARRIER();
    vuint8_t tmp = (vuint8_t)__atomic_fetch_add(&a->_v, v, __ATOMIC_RELEASE);
    V_COMPILER_BARRIER();
    return tmp;
}

#endif /* VATOMIC8_GET_ADD_REL */

#ifndef VATOMIC8_GET_ADD_RLX
    #define VATOMIC8_GET_ADD_RLX

static inline vuint8_t
vatomic8_get_add_rlx(vatomic8_t *a, vuint8_t v)
{
    V_COMPILER_BARRIER();
    vuint8_t tmp = (vuint8_t)__atomic_fetch_add(&a->_v, v, __ATOMIC_RELAXED);
    V_COMPILER_BARRIER();
    return tmp;
}

#endif /* VATOMIC8_GET_ADD_RLX */

#ifndef VATOMIC16_GET_ADD
    #define VATOMIC16_GET_ADD

static inline vuint16_t
vatomic16_get_add(vatomic16_t *a, vuint16_t v)
{
    V_COMPILER_BARRIER();
    vuint16_t tmp = (vuint16_t)__atomic_fetch_add(&a->_v, v, __ATOMIC_SEQ_CST);
    V_COMPILER_BARRIER();
    return tmp;
}

#endif /* VATOMIC16_GET_ADD */

#ifndef VATOMIC16_GET_ADD_ACQ
    #define VATOMIC16_GET_ADD_ACQ

static inline vuint16_t
vatomic16_get_add_acq(vatomic16_t *a, vuint16_t v)
{
    V_COMPILER_BARRIER();
    vuint16_t tmp = (vuint16_t)__atomic_fetch_add(&a->_v, v, __ATOMIC_ACQUIRE);
    V_COMPILER_BARRIER();
    return tmp;
}

#endif /* VATOMIC16_GET_ADD_ACQ */

#ifndef VATOMIC16_GET_ADD_REL
    #define VATOMIC16_GET_ADD_REL

static inline vuint16_t
vatomic16_get_add_rel(vatomic16_t *a, vuint16_t v)
{
    V_COMPILER_BARRIER();
    vuint16_t tmp = (vuint16_t)__atomic_fetch_add(&a->_v, v, __ATOMIC_RELEASE);
    V_COMPILER_BARRIER();
    return tmp;
}

#endif /* VATOMIC16_GET_ADD_REL */

#ifndef VATOMIC16_GET_ADD_RLX
    #define VATOMIC16_GET_ADD_RLX

static inline vuint16_t
vatomic16_get_add_rlx(vatomic16_t *a, vuint16_t v)
{
    V_COMPILER_BARRIER();
    vuint16_t tmp = (vuint16_t)__atomic_fetch_add(&a->_v, v, __ATOMIC_RELAXED);
    V_COMPILER_BARRIER();
    return tmp;
}

#endif /* VATOMIC16_GET_ADD_RLX */

#ifndef VATOMIC32_GET_ADD
    #define VATOMIC32_GET_ADD

static inline vuint32_t
vatomic32_get_add(vatomic32_t *a, vuint32_t v)
{
    V_COMPILER_BARRIER();
    vuint32_t tmp = (vuint32_t)__atomic_fetch_add(&a->_v, v, __ATOMIC_SEQ_CST);
    V_COMPILER_BARRIER();
    return tmp;
}

#endif /* VATOMIC32_GET_ADD */

#ifndef VATOMIC32_GET_ADD_ACQ
    #define VATOMIC32_GET_ADD_ACQ

static inline vuint32_t
vatomic32_get_add_acq(vatomic32_t *a, vuint32_t v)
{
    V_COMPILER_BARRIER();
    vuint32_t tmp = (vuint32_t)__atomic_fetch_add(&a->_v, v, __ATOMIC_ACQUIRE);
    V_COMPILER_BARRIER();
    return tmp;
}

#endif /* VATOMIC32_GET_ADD_ACQ */

#ifndef VATOMIC32_GET_ADD_REL
    #define VATOMIC32_GET_ADD_REL

static inline vuint32_t
vatomic32_get_add_rel(vatomic32_t *a, vuint32_t v)
{
    V_COMPILER_BARRIER();
    vuint32_t tmp = (vuint32_t)__atomic_fetch_add(&a->_v, v, __ATOMIC_RELEASE);
    V_COMPILER_BARRIER();
    return tmp;
}

#endif /* VATOMIC32_GET_ADD_REL */

#ifndef VATOMIC32_GET_ADD_RLX
    #define VATOMIC32_GET_ADD_RLX

static inline vuint32_t
vatomic32_get_add_rlx(vatomic32_t *a, vuint32_t v)
{
    V_COMPILER_BARRIER();
    vuint32_t tmp = (vuint32_t)__atomic_fetch_add(&a->_v, v, __ATOMIC_RELAXED);
    V_COMPILER_BARRIER();
    return tmp;
}

#endif /* VATOMIC32_GET_ADD_RLX */

#ifndef VATOMIC64_GET_ADD
    #define VATOMIC64_GET_ADD

static inline vuint64_t
vatomic64_get_add(vatomic64_t *a, vuint64_t v)
{
    V_COMPILER_BARRIER();
    vuint64_t tmp = (vuint64_t)__atomic_fetch_add(&a->_v, v, __ATOMIC_SEQ_CST);
    V_COMPILER_BARRIER();
    return tmp;
}

#endif /* VATOMIC64_GET_ADD */

#ifndef VATOMIC64_GET_ADD_ACQ
    #define VATOMIC64_GET_ADD_ACQ

static inline vuint64_t
vatomic64_get_add_acq(vatomic64_t *a, vuint64_t v)
{
    V_COMPILER_BARRIER();
    vuint64_t tmp = (vuint64_t)__atomic_fetch_add(&a->_v, v, __ATOMIC_ACQUIRE);
    V_COMPILER_BARRIER();
    return tmp;
}

#endif /* VATOMIC64_GET_ADD_ACQ */

#ifndef VATOMIC64_GET_ADD_REL
    #define VATOMIC64_GET_ADD_REL

static inline vuint64_t
vatomic64_get_add_rel(vatomic64_t *a, vuint64_t v)
{
    V_COMPILER_BARRIER();
    vuint64_t tmp = (vuint64_t)__atomic_fetch_add(&a->_v, v, __ATOMIC_RELEASE);
    V_COMPILER_BARRIER();
    return tmp;
}

#endif /* VATOMIC64_GET_ADD_REL */

#ifndef VATOMIC64_GET_ADD_RLX
    #define VATOMIC64_GET_ADD_RLX

static inline vuint64_t
vatomic64_get_add_rlx(vatomic64_t *a, vuint64_t v)
{
    V_COMPILER_BARRIER();
    vuint64_t tmp = (vuint64_t)__atomic_fetch_add(&a->_v, v, __ATOMIC_RELAXED);
    V_COMPILER_BARRIER();
    return tmp;
}

#endif /* VATOMIC64_GET_ADD_RLX */

#ifndef VATOMICSZ_GET_ADD
    #define VATOMICSZ_GET_ADD

static inline vsize_t
vatomicsz_get_add(vatomicsz_t *a, vsize_t v)
{
    V_COMPILER_BARRIER();
    vsize_t tmp = (vsize_t)__atomic_fetch_add(&a->_v, v, __ATOMIC_SEQ_CST);
    V_COMPILER_BARRIER();
    return tmp;
}

#endif /* VATOMICSZ_GET_ADD */

#ifndef VATOMICSZ_GET_ADD_ACQ
    #define VATOMICSZ_GET_ADD_ACQ

static inline vsize_t
vatomicsz_get_add_acq(vatomicsz_t *a, vsize_t v)
{
    V_COMPILER_BARRIER();
    vsize_t tmp = (vsize_t)__atomic_fetch_add(&a->_v, v, __ATOMIC_ACQUIRE);
    V_COMPILER_BARRIER();
    return tmp;
}

#endif /* VATOMICSZ_GET_ADD_ACQ */

#ifndef VATOMICSZ_GET_ADD_REL
    #define VATOMICSZ_GET_ADD_REL

static inline vsize_t
vatomicsz_get_add_rel(vatomicsz_t *a, vsize_t v)
{
    V_COMPILER_BARRIER();
    vsize_t tmp = (vsize_t)__atomic_fetch_add(&a->_v, v, __ATOMIC_RELEASE);
    V_COMPILER_BARRIER();
    return tmp;
}

#endif /* VATOMICSZ_GET_ADD_REL */

#ifndef VATOMICSZ_GET_ADD_RLX
    #define VATOMICSZ_GET_ADD_RLX

static inline vsize_t
vatomicsz_get_add_rlx(vatomicsz_t *a, vsize_t v)
{
    V_COMPILER_BARRIER();
    vsize_t tmp = (vsize_t)__atomic_fetch_add(&a->_v, v, __ATOMIC_RELAXED);
    V_COMPILER_BARRIER();
    return tmp;
}

#endif /* VATOMICSZ_GET_ADD_RLX */

/* *****************************************************************************
 * vatomic_get_sub
 * ****************************************************************************/

#ifndef VATOMIC8_GET_SUB
    #define VATOMIC8_GET_SUB

static inline vuint8_t
vatomic8_get_sub(vatomic8_t *a, vuint8_t v)
{
    V_COMPILER_BARRIER();
    vuint8_t tmp = __atomic_fetch_sub(&a->_v, v, __ATOMIC_SEQ_CST);
    V_COMPILER_BARRIER();
    return tmp;
}

#endif /* VATOMIC8_GET_SUB */

#ifndef VATOMIC8_GET_SUB_ACQ
    #define VATOMIC8_GET_SUB_ACQ

static inline vuint8_t
vatomic8_get_sub_acq(vatomic8_t *a, vuint8_t v)
{
    V_COMPILER_BARRIER();
    vuint8_t tmp = __atomic_fetch_sub(&a->_v, v, __ATOMIC_ACQUIRE);
    V_COMPILER_BARRIER();
    return tmp;
}

#endif /* VATOMIC8_GET_SUB_ACQ */

#ifndef VATOMIC8_GET_SUB_REL
    #define VATOMIC8_GET_SUB_REL

static inline vuint8_t
vatomic8_get_sub_rel(vatomic8_t *a, vuint8_t v)
{
    V_COMPILER_BARRIER();
    vuint8_t tmp = __atomic_fetch_sub(&a->_v, v, __ATOMIC_RELEASE);
    V_COMPILER_BARRIER();
    return tmp;
}

#endif /* VATOMIC8_GET_SUB_REL */

#ifndef VATOMIC8_GET_SUB_RLX
    #define VATOMIC8_GET_SUB_RLX

static inline vuint8_t
vatomic8_get_sub_rlx(vatomic8_t *a, vuint8_t v)
{
    V_COMPILER_BARRIER();
    vuint8_t tmp = __atomic_fetch_sub(&a->_v, v, __ATOMIC_RELAXED);
    V_COMPILER_BARRIER();
    return tmp;
}

#endif /* VATOMIC8_GET_SUB_RLX */

#ifndef VATOMIC16_GET_SUB
    #define VATOMIC16_GET_SUB

static inline vuint16_t
vatomic16_get_sub(vatomic16_t *a, vuint16_t v)
{
    V_COMPILER_BARRIER();
    vuint16_t tmp = __atomic_fetch_sub(&a->_v, v, __ATOMIC_SEQ_CST);
    V_COMPILER_BARRIER();
    return tmp;
}

#endif /* VATOMIC16_GET_SUB */

#ifndef VATOMIC16_GET_SUB_ACQ
    #define VATOMIC16_GET_SUB_ACQ

static inline vuint16_t
vatomic16_get_sub_acq(vatomic16_t *a, vuint16_t v)
{
    V_COMPILER_BARRIER();
    vuint16_t tmp = __atomic_fetch_sub(&a->_v, v, __ATOMIC_ACQUIRE);
    V_COMPILER_BARRIER();
    return tmp;
}

#endif /* VATOMIC16_GET_SUB_ACQ */

#ifndef VATOMIC16_GET_SUB_REL
    #define VATOMIC16_GET_SUB_REL

static inline vuint16_t
vatomic16_get_sub_rel(vatomic16_t *a, vuint16_t v)
{
    V_COMPILER_BARRIER();
    vuint16_t tmp = __atomic_fetch_sub(&a->_v, v, __ATOMIC_RELEASE);
    V_COMPILER_BARRIER();
    return tmp;
}

#endif /* VATOMIC16_GET_SUB_REL */

#ifndef VATOMIC16_GET_SUB_RLX
    #define VATOMIC16_GET_SUB_RLX

static inline vuint16_t
vatomic16_get_sub_rlx(vatomic16_t *a, vuint16_t v)
{
    V_COMPILER_BARRIER();
    vuint16_t tmp = __atomic_fetch_sub(&a->_v, v, __ATOMIC_RELAXED);
    V_COMPILER_BARRIER();
    return tmp;
}

#endif /* VATOMIC16_GET_SUB_RLX */

#ifndef VATOMIC32_GET_SUB
    #define VATOMIC32_GET_SUB

static inline vuint32_t
vatomic32_get_sub(vatomic32_t *a, vuint32_t v)
{
    V_COMPILER_BARRIER();
    vuint32_t tmp = __atomic_fetch_sub(&a->_v, v, __ATOMIC_SEQ_CST);
    V_COMPILER_BARRIER();
    return tmp;
}

#endif /* VATOMIC32_GET_SUB */

#ifndef VATOMIC32_GET_SUB_ACQ
    #define VATOMIC32_GET_SUB_ACQ

static inline vuint32_t
vatomic32_get_sub_acq(vatomic32_t *a, vuint32_t v)
{
    V_COMPILER_BARRIER();
    vuint32_t tmp = __atomic_fetch_sub(&a->_v, v, __ATOMIC_ACQUIRE);
    V_COMPILER_BARRIER();
    return tmp;
}

#endif /* VATOMIC32_GET_SUB_ACQ */

#ifndef VATOMIC32_GET_SUB_REL
    #define VATOMIC32_GET_SUB_REL

static inline vuint32_t
vatomic32_get_sub_rel(vatomic32_t *a, vuint32_t v)
{
    V_COMPILER_BARRIER();
    vuint32_t tmp = __atomic_fetch_sub(&a->_v, v, __ATOMIC_RELEASE);
    V_COMPILER_BARRIER();
    return tmp;
}

#endif /* VATOMIC32_GET_SUB_REL */

#ifndef VATOMIC32_GET_SUB_RLX
    #define VATOMIC32_GET_SUB_RLX

static inline vuint32_t
vatomic32_get_sub_rlx(vatomic32_t *a, vuint32_t v)
{
    V_COMPILER_BARRIER();
    vuint32_t tmp = __atomic_fetch_sub(&a->_v, v, __ATOMIC_RELAXED);
    V_COMPILER_BARRIER();
    return tmp;
}

#endif /* VATOMIC32_GET_SUB_RLX */

#ifndef VATOMIC64_GET_SUB
    #define VATOMIC64_GET_SUB

static inline vuint64_t
vatomic64_get_sub(vatomic64_t *a, vuint64_t v)
{
    V_COMPILER_BARRIER();
    vuint64_t tmp = __atomic_fetch_sub(&a->_v, v, __ATOMIC_SEQ_CST);
    V_COMPILER_BARRIER();
    return tmp;
}

#endif /* VATOMIC64_GET_SUB */

#ifndef VATOMIC64_GET_SUB_ACQ
    #define VATOMIC64_GET_SUB_ACQ

static inline vuint64_t
vatomic64_get_sub_acq(vatomic64_t *a, vuint64_t v)
{
    V_COMPILER_BARRIER();
    vuint64_t tmp = __atomic_fetch_sub(&a->_v, v, __ATOMIC_ACQUIRE);
    V_COMPILER_BARRIER();
    return tmp;
}

#endif /* VATOMIC64_GET_SUB_ACQ */

#ifndef VATOMIC64_GET_SUB_REL
    #define VATOMIC64_GET_SUB_REL

static inline vuint64_t
vatomic64_get_sub_rel(vatomic64_t *a, vuint64_t v)
{
    V_COMPILER_BARRIER();
    vuint64_t tmp = __atomic_fetch_sub(&a->_v, v, __ATOMIC_RELEASE);
    V_COMPILER_BARRIER();
    return tmp;
}

#endif /* VATOMIC64_GET_SUB_REL */

#ifndef VATOMIC64_GET_SUB_RLX
    #define VATOMIC64_GET_SUB_RLX

static inline vuint64_t
vatomic64_get_sub_rlx(vatomic64_t *a, vuint64_t v)
{
    V_COMPILER_BARRIER();
    vuint64_t tmp = __atomic_fetch_sub(&a->_v, v, __ATOMIC_RELAXED);
    V_COMPILER_BARRIER();
    return tmp;
}

#endif /* VATOMIC64_GET_SUB_RLX */

#ifndef VATOMICSZ_GET_SUB
    #define VATOMICSZ_GET_SUB

static inline vsize_t
vatomicsz_get_sub(vatomicsz_t *a, vsize_t v)
{
    V_COMPILER_BARRIER();
    vsize_t tmp = __atomic_fetch_sub(&a->_v, v, __ATOMIC_SEQ_CST);
    V_COMPILER_BARRIER();
    return tmp;
}

#endif /* VATOMICSZ_GET_SUB */

#ifndef VATOMICSZ_GET_SUB_ACQ
    #define VATOMICSZ_GET_SUB_ACQ

static inline vsize_t
vatomicsz_get_sub_acq(vatomicsz_t *a, vsize_t v)
{
    V_COMPILER_BARRIER();
    vsize_t tmp = __atomic_fetch_sub(&a->_v, v, __ATOMIC_ACQUIRE);
    V_COMPILER_BARRIER();
    return tmp;
}

#endif /* VATOMICSZ_GET_SUB_ACQ */

#ifndef VATOMICSZ_GET_SUB_REL
    #define VATOMICSZ_GET_SUB_REL

static inline vsize_t
vatomicsz_get_sub_rel(vatomicsz_t *a, vsize_t v)
{
    V_COMPILER_BARRIER();
    vsize_t tmp = __atomic_fetch_sub(&a->_v, v, __ATOMIC_RELEASE);
    V_COMPILER_BARRIER();
    return tmp;
}

#endif /* VATOMICSZ_GET_SUB_REL */

#ifndef VATOMICSZ_GET_SUB_RLX
    #define VATOMICSZ_GET_SUB_RLX

static inline vsize_t
vatomicsz_get_sub_rlx(vatomicsz_t *a, vsize_t v)
{
    V_COMPILER_BARRIER();
    vsize_t tmp = __atomic_fetch_sub(&a->_v, v, __ATOMIC_RELAXED);
    V_COMPILER_BARRIER();
    return tmp;
}

#endif /* VATOMICSZ_GET_SUB_RLX */

#endif /* VATOMIC_BUILTINS_H */
