/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cmp;

import org.bouncycastle.asn1.ASN1Choice;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.x509.AttributeCertificate;
import org.bouncycastle.asn1.x509.X509CertificateStructure;

public class CMPCertificate
extends ASN1Encodable
implements ASN1Choice {
    private X509CertificateStructure x509v3PKCert;
    private AttributeCertificate x509v2AttrCert;

    public CMPCertificate(AttributeCertificate attributeCertificate) {
        this.x509v2AttrCert = attributeCertificate;
    }

    public CMPCertificate(X509CertificateStructure x509CertificateStructure) {
        if (x509CertificateStructure.getVersion() != 3) {
            throw new IllegalArgumentException("only version 3 certificates allowed");
        }
        this.x509v3PKCert = x509CertificateStructure;
    }

    public static CMPCertificate getInstance(Object object) {
        if (object instanceof CMPCertificate) {
            return (CMPCertificate)object;
        }
        if (object instanceof ASN1Sequence) {
            return new CMPCertificate(X509CertificateStructure.getInstance(object));
        }
        if (object instanceof ASN1TaggedObject) {
            return new CMPCertificate(AttributeCertificate.getInstance(((ASN1TaggedObject)object).getObject()));
        }
        throw new IllegalArgumentException("Invalid object: " + object.getClass().getName());
    }

    public boolean isX509v3PKCert() {
        return this.x509v3PKCert != null;
    }

    public X509CertificateStructure getX509v3PKCert() {
        return this.x509v3PKCert;
    }

    public AttributeCertificate getX509v2AttrCert() {
        return this.x509v2AttrCert;
    }

    @Override
    public DERObject toASN1Object() {
        if (this.x509v2AttrCert != null) {
            return new DERTaggedObject(true, 1, this.x509v2AttrCert);
        }
        return this.x509v3PKCert.toASN1Object();
    }
}

