/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.stress.operations;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.stress.Operation;
import org.apache.cassandra.stress.generate.DistributionFactory;
import org.apache.cassandra.stress.generate.DistributionFixed;
import org.apache.cassandra.stress.generate.PartitionGenerator;
import org.apache.cassandra.stress.operations.FixedOpDistribution;
import org.apache.cassandra.stress.operations.OpDistribution;
import org.apache.cassandra.stress.operations.OpDistributionFactory;
import org.apache.cassandra.stress.operations.SampledOpDistribution;
import org.apache.cassandra.stress.util.Timer;
import org.apache.cassandra.stress.util.Timing;
import org.apache.commons.math3.distribution.EnumeratedDistribution;
import org.apache.commons.math3.util.Pair;

public abstract class SampledOpDistributionFactory<T>
implements OpDistributionFactory {
    final Map<T, Double> ratios;
    final DistributionFactory clustering;

    protected SampledOpDistributionFactory(Map<T, Double> ratios, DistributionFactory clustering) {
        this.ratios = ratios;
        this.clustering = clustering;
    }

    protected abstract List<? extends Operation> get(Timer var1, PartitionGenerator var2, T var3);

    protected abstract PartitionGenerator newGenerator();

    @Override
    public OpDistribution get(Timing timing, int sampleCount) {
        PartitionGenerator generator = this.newGenerator();
        ArrayList<Pair> operations = new ArrayList<Pair>();
        for (Map.Entry<T, Double> ratio : this.ratios.entrySet()) {
            List<Operation> ops = this.get(timing.newTimer(ratio.getKey().toString(), sampleCount), generator, ratio.getKey());
            for (Operation op : ops) {
                operations.add(new Pair((Object)op, (Object)(ratio.getValue() / (double)ops.size())));
            }
        }
        return new SampledOpDistribution((EnumeratedDistribution<Operation>)new EnumeratedDistribution(operations), this.clustering.get());
    }

    @Override
    public String desc() {
        ArrayList<T> keys = new ArrayList<T>();
        for (Map.Entry<T, Double> ratio : this.ratios.entrySet()) {
            keys.add(ratio.getKey());
        }
        return ((Object)keys).toString();
    }

    @Override
    public Iterable<OpDistributionFactory> each() {
        ArrayList<OpDistributionFactory> out = new ArrayList<OpDistributionFactory>();
        for (final Map.Entry<T, Double> ratio : this.ratios.entrySet()) {
            out.add(new OpDistributionFactory(){

                @Override
                public OpDistribution get(Timing timing, int sampleCount) {
                    List<Operation> ops = SampledOpDistributionFactory.this.get(timing.newTimer(ratio.getKey().toString(), sampleCount), SampledOpDistributionFactory.this.newGenerator(), ratio.getKey());
                    if (ops.size() == 1) {
                        return new FixedOpDistribution(ops.get(0));
                    }
                    ArrayList<Pair> ratios = new ArrayList<Pair>();
                    for (Operation op : ops) {
                        ratios.add(new Pair((Object)op, (Object)(1.0 / (double)ops.size())));
                    }
                    return new SampledOpDistribution((EnumeratedDistribution<Operation>)new EnumeratedDistribution(ratios), new DistributionFixed(1L));
                }

                @Override
                public String desc() {
                    return ratio.getKey().toString();
                }

                @Override
                public Iterable<OpDistributionFactory> each() {
                    return Collections.singleton(this);
                }
            });
        }
        return out;
    }
}

