/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.stress.settings;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.cassandra.stress.generate.DistributionFactory;
import org.apache.cassandra.stress.generate.PartitionGenerator;
import org.apache.cassandra.stress.generate.SeedManager;
import org.apache.cassandra.stress.generate.values.Bytes;
import org.apache.cassandra.stress.generate.values.Generator;
import org.apache.cassandra.stress.generate.values.GeneratorConfig;
import org.apache.cassandra.stress.generate.values.HexBytes;
import org.apache.cassandra.stress.operations.FixedOpDistribution;
import org.apache.cassandra.stress.operations.OpDistribution;
import org.apache.cassandra.stress.operations.OpDistributionFactory;
import org.apache.cassandra.stress.operations.predefined.PredefinedOperation;
import org.apache.cassandra.stress.settings.Command;
import org.apache.cassandra.stress.settings.GroupedOptions;
import org.apache.cassandra.stress.settings.Option;
import org.apache.cassandra.stress.settings.OptionDistribution;
import org.apache.cassandra.stress.settings.OptionSimple;
import org.apache.cassandra.stress.settings.SettingsCommand;
import org.apache.cassandra.stress.settings.StressSettings;
import org.apache.cassandra.stress.util.Timing;

public class SettingsCommandPreDefined
extends SettingsCommand {
    public final DistributionFactory add;
    public final int keySize;

    @Override
    public OpDistributionFactory getFactory(final StressSettings settings) {
        final SeedManager seeds = new SeedManager(settings);
        return new OpDistributionFactory(){

            @Override
            public OpDistribution get(Timing timing, int sampleCount) {
                return new FixedOpDistribution(PredefinedOperation.operation(SettingsCommandPreDefined.this.type, timing.newTimer(SettingsCommandPreDefined.this.type.toString(), sampleCount), SettingsCommandPreDefined.this.newGenerator(settings), seeds, settings, SettingsCommandPreDefined.this.add));
            }

            @Override
            public String desc() {
                return SettingsCommandPreDefined.this.type.toString();
            }

            @Override
            public Iterable<OpDistributionFactory> each() {
                return Collections.singleton(this);
            }
        };
    }

    PartitionGenerator newGenerator(StressSettings settings) {
        List<String> names = settings.columns.namestrs;
        List<Generator> partitionKey = Collections.singletonList(new HexBytes("key", new GeneratorConfig("randomstrkey", null, OptionDistribution.get("fixed(" + this.keySize + ")"), null)));
        ArrayList<Generator> columns = new ArrayList<Generator>();
        for (int i = 0; i < settings.columns.maxColumnsPerKey; ++i) {
            columns.add(new Bytes(names.get(i), new GeneratorConfig("randomstr" + names.get(i), null, settings.columns.sizeDistribution, null)));
        }
        return new PartitionGenerator(partitionKey, Collections.emptyList(), columns, PartitionGenerator.Order.ARBITRARY);
    }

    public SettingsCommandPreDefined(Command type, Options options) {
        super(type, options.parent);
        this.add = options.add.get();
        this.keySize = Integer.parseInt(options.keysize.value());
    }

    @Override
    public void truncateTables(StressSettings settings) {
        this.truncateTables(settings, settings.schema.keyspace, "standard1", "counter1", "counter3");
    }

    public static SettingsCommandPreDefined build(Command type, String[] params) {
        GroupedOptions options = GroupedOptions.select((String[])params, (GroupedOptions[])new Options[]{new Options(new SettingsCommand.Uncertainty()), new Options(new SettingsCommand.Count()), new Options(new SettingsCommand.Duration())});
        if (options == null) {
            SettingsCommandPreDefined.printHelp(type);
            System.out.println("Invalid " + (Object)((Object)type) + " options provided, see output for valid options");
            System.exit(1);
        }
        return new SettingsCommandPreDefined(type, (Options)options);
    }

    static void printHelp(Command type) {
        SettingsCommandPreDefined.printHelp(type.toString().toLowerCase());
    }

    static void printHelp(String type) {
        GroupedOptions.printOptions(System.out, type.toLowerCase(), new SettingsCommand.Uncertainty(), new SettingsCommand.Count(), new SettingsCommand.Duration());
    }

    static Runnable helpPrinter(final Command type) {
        return new Runnable(){

            @Override
            public void run() {
                SettingsCommandPreDefined.printHelp(type);
            }
        };
    }

    static class Options
    extends GroupedOptions {
        final SettingsCommand.Options parent;
        final OptionDistribution add = new OptionDistribution("add=", "fixed(1)", "Distribution of value of counter increments");
        final OptionSimple keysize = new OptionSimple("keysize=", "[0-9]+", "10", "Key size in bytes", false);

        protected Options(SettingsCommand.Options parent) {
            this.parent = parent;
        }

        @Override
        public List<? extends Option> options() {
            return Options.merge(this.parent.options(), Arrays.asList(this.add, this.keysize));
        }
    }
}

