/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.stress.settings;

import com.datastax.driver.core.BatchStatement;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.stress.generate.DistributionFactory;
import org.apache.cassandra.stress.generate.RatioDistributionFactory;
import org.apache.cassandra.stress.settings.GroupedOptions;
import org.apache.cassandra.stress.settings.Option;
import org.apache.cassandra.stress.settings.OptionDistribution;
import org.apache.cassandra.stress.settings.OptionRatioDistribution;
import org.apache.cassandra.stress.settings.OptionSimple;

public class SettingsInsert
implements Serializable {
    public final DistributionFactory revisit;
    public final DistributionFactory visits;
    public final DistributionFactory batchsize;
    public final RatioDistributionFactory selectRatio;
    public final BatchStatement.Type batchType;

    private SettingsInsert(InsertOptions options) {
        this.visits = options.visits.get();
        this.revisit = options.revisit.get();
        this.batchsize = options.partitions.get();
        this.selectRatio = options.selectRatio.get();
        this.batchType = !options.batchType.setByUser() ? null : BatchStatement.Type.valueOf((String)options.batchType.value());
    }

    public static SettingsInsert get(Map<String, String[]> clArgs) {
        String[] params = clArgs.remove("-insert");
        if (params == null) {
            return new SettingsInsert(new InsertOptions());
        }
        InsertOptions options = (InsertOptions)GroupedOptions.select((String[])params, (GroupedOptions[])new InsertOptions[]{new InsertOptions()});
        if (options == null) {
            SettingsInsert.printHelp();
            System.out.println("Invalid -insert options provided, see output for valid options");
            System.exit(1);
        }
        return new SettingsInsert(options);
    }

    public static void printHelp() {
        GroupedOptions.printOptions(System.out, "-insert", new InsertOptions());
    }

    public static Runnable helpPrinter() {
        return new Runnable(){

            @Override
            public void run() {
                SettingsInsert.printHelp();
            }
        };
    }

    private static class InsertOptions
    extends GroupedOptions {
        final OptionDistribution visits = new OptionDistribution("visits=", "fixed(1)", "The target number of inserts to split a partition into; if more than one, the partition will be placed in the revisit set");
        final OptionDistribution revisit = new OptionDistribution("revisit=", "uniform(1..1M)", "The distribution with which we revisit partial writes (see visits); implicitly defines size of revisit collection");
        final OptionDistribution partitions = new OptionDistribution("partitions=", null, "The number of partitions to update in a single batch", false);
        final OptionSimple batchType = new OptionSimple("batchtype=", "unlogged|logged|counter", null, "Specify the type of batch statement (LOGGED, UNLOGGED or COUNTER)", false);
        final OptionRatioDistribution selectRatio = new OptionRatioDistribution("select-ratio=", null, "The uniform probability of visiting any CQL row in the generated partition", false);

        private InsertOptions() {
        }

        @Override
        public List<? extends Option> options() {
            return Arrays.asList(this.revisit, this.visits, this.partitions, this.batchType, this.selectRatio);
        }
    }
}

