/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.thrift;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.thrift.ColumnParent;
import org.apache.cassandra.thrift.ColumnSlice;
import org.apache.cassandra.thrift.ConsistencyLevel;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.thrift.EncodingUtils;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.meta_data.EnumMetaData;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.ListMetaData;
import org.apache.thrift.meta_data.StructMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TList;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;
import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;

public class MultiSliceRequest
implements TBase<MultiSliceRequest, _Fields>,
Serializable,
Cloneable,
Comparable<MultiSliceRequest> {
    private static final TStruct STRUCT_DESC = new TStruct("MultiSliceRequest");
    private static final TField KEY_FIELD_DESC = new TField("key", 11, 1);
    private static final TField COLUMN_PARENT_FIELD_DESC = new TField("column_parent", 12, 2);
    private static final TField COLUMN_SLICES_FIELD_DESC = new TField("column_slices", 15, 3);
    private static final TField REVERSED_FIELD_DESC = new TField("reversed", 2, 4);
    private static final TField COUNT_FIELD_DESC = new TField("count", 8, 5);
    private static final TField CONSISTENCY_LEVEL_FIELD_DESC = new TField("consistency_level", 8, 6);
    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    public ByteBuffer key;
    public ColumnParent column_parent;
    public List<ColumnSlice> column_slices;
    public boolean reversed;
    public int count;
    public ConsistencyLevel consistency_level;
    private static final int __REVERSED_ISSET_ID = 0;
    private static final int __COUNT_ISSET_ID = 1;
    private byte __isset_bitfield = 0;
    private _Fields[] optionals = new _Fields[]{_Fields.KEY, _Fields.COLUMN_PARENT, _Fields.COLUMN_SLICES, _Fields.REVERSED, _Fields.COUNT, _Fields.CONSISTENCY_LEVEL};
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public MultiSliceRequest() {
        this.reversed = false;
        this.count = 1000;
        this.consistency_level = ConsistencyLevel.ONE;
    }

    public MultiSliceRequest(MultiSliceRequest other) {
        this.__isset_bitfield = other.__isset_bitfield;
        if (other.isSetKey()) {
            this.key = TBaseHelper.copyBinary((ByteBuffer)other.key);
        }
        if (other.isSetColumn_parent()) {
            this.column_parent = new ColumnParent(other.column_parent);
        }
        if (other.isSetColumn_slices()) {
            ArrayList<ColumnSlice> __this__column_slices = new ArrayList<ColumnSlice>(other.column_slices.size());
            for (ColumnSlice other_element : other.column_slices) {
                __this__column_slices.add(new ColumnSlice(other_element));
            }
            this.column_slices = __this__column_slices;
        }
        this.reversed = other.reversed;
        this.count = other.count;
        if (other.isSetConsistency_level()) {
            this.consistency_level = other.consistency_level;
        }
    }

    public MultiSliceRequest deepCopy() {
        return new MultiSliceRequest(this);
    }

    public void clear() {
        this.key = null;
        this.column_parent = null;
        this.column_slices = null;
        this.reversed = false;
        this.count = 1000;
        this.consistency_level = ConsistencyLevel.ONE;
    }

    public byte[] getKey() {
        this.setKey(TBaseHelper.rightSize((ByteBuffer)this.key));
        return this.key == null ? null : this.key.array();
    }

    public ByteBuffer bufferForKey() {
        return this.key;
    }

    public MultiSliceRequest setKey(byte[] key) {
        this.setKey(key == null ? (ByteBuffer)null : ByteBuffer.wrap(key));
        return this;
    }

    public MultiSliceRequest setKey(ByteBuffer key) {
        this.key = key;
        return this;
    }

    public void unsetKey() {
        this.key = null;
    }

    public boolean isSetKey() {
        return this.key != null;
    }

    public void setKeyIsSet(boolean value) {
        if (!value) {
            this.key = null;
        }
    }

    public ColumnParent getColumn_parent() {
        return this.column_parent;
    }

    public MultiSliceRequest setColumn_parent(ColumnParent column_parent) {
        this.column_parent = column_parent;
        return this;
    }

    public void unsetColumn_parent() {
        this.column_parent = null;
    }

    public boolean isSetColumn_parent() {
        return this.column_parent != null;
    }

    public void setColumn_parentIsSet(boolean value) {
        if (!value) {
            this.column_parent = null;
        }
    }

    public int getColumn_slicesSize() {
        return this.column_slices == null ? 0 : this.column_slices.size();
    }

    public Iterator<ColumnSlice> getColumn_slicesIterator() {
        return this.column_slices == null ? null : this.column_slices.iterator();
    }

    public void addToColumn_slices(ColumnSlice elem) {
        if (this.column_slices == null) {
            this.column_slices = new ArrayList<ColumnSlice>();
        }
        this.column_slices.add(elem);
    }

    public List<ColumnSlice> getColumn_slices() {
        return this.column_slices;
    }

    public MultiSliceRequest setColumn_slices(List<ColumnSlice> column_slices) {
        this.column_slices = column_slices;
        return this;
    }

    public void unsetColumn_slices() {
        this.column_slices = null;
    }

    public boolean isSetColumn_slices() {
        return this.column_slices != null;
    }

    public void setColumn_slicesIsSet(boolean value) {
        if (!value) {
            this.column_slices = null;
        }
    }

    public boolean isReversed() {
        return this.reversed;
    }

    public MultiSliceRequest setReversed(boolean reversed) {
        this.reversed = reversed;
        this.setReversedIsSet(true);
        return this;
    }

    public void unsetReversed() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)0);
    }

    public boolean isSetReversed() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)0);
    }

    public void setReversedIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)0, (boolean)value);
    }

    public int getCount() {
        return this.count;
    }

    public MultiSliceRequest setCount(int count) {
        this.count = count;
        this.setCountIsSet(true);
        return this;
    }

    public void unsetCount() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)1);
    }

    public boolean isSetCount() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)1);
    }

    public void setCountIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)1, (boolean)value);
    }

    public ConsistencyLevel getConsistency_level() {
        return this.consistency_level;
    }

    public MultiSliceRequest setConsistency_level(ConsistencyLevel consistency_level) {
        this.consistency_level = consistency_level;
        return this;
    }

    public void unsetConsistency_level() {
        this.consistency_level = null;
    }

    public boolean isSetConsistency_level() {
        return this.consistency_level != null;
    }

    public void setConsistency_levelIsSet(boolean value) {
        if (!value) {
            this.consistency_level = null;
        }
    }

    public void setFieldValue(_Fields field, Object value) {
        switch (field) {
            case KEY: {
                if (value == null) {
                    this.unsetKey();
                    break;
                }
                this.setKey((ByteBuffer)value);
                break;
            }
            case COLUMN_PARENT: {
                if (value == null) {
                    this.unsetColumn_parent();
                    break;
                }
                this.setColumn_parent((ColumnParent)value);
                break;
            }
            case COLUMN_SLICES: {
                if (value == null) {
                    this.unsetColumn_slices();
                    break;
                }
                this.setColumn_slices((List)value);
                break;
            }
            case REVERSED: {
                if (value == null) {
                    this.unsetReversed();
                    break;
                }
                this.setReversed((Boolean)value);
                break;
            }
            case COUNT: {
                if (value == null) {
                    this.unsetCount();
                    break;
                }
                this.setCount((Integer)value);
                break;
            }
            case CONSISTENCY_LEVEL: {
                if (value == null) {
                    this.unsetConsistency_level();
                    break;
                }
                this.setConsistency_level((ConsistencyLevel)((Object)value));
            }
        }
    }

    public Object getFieldValue(_Fields field) {
        switch (field) {
            case KEY: {
                return this.getKey();
            }
            case COLUMN_PARENT: {
                return this.getColumn_parent();
            }
            case COLUMN_SLICES: {
                return this.getColumn_slices();
            }
            case REVERSED: {
                return this.isReversed();
            }
            case COUNT: {
                return this.getCount();
            }
            case CONSISTENCY_LEVEL: {
                return this.getConsistency_level();
            }
        }
        throw new IllegalStateException();
    }

    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case KEY: {
                return this.isSetKey();
            }
            case COLUMN_PARENT: {
                return this.isSetColumn_parent();
            }
            case COLUMN_SLICES: {
                return this.isSetColumn_slices();
            }
            case REVERSED: {
                return this.isSetReversed();
            }
            case COUNT: {
                return this.isSetCount();
            }
            case CONSISTENCY_LEVEL: {
                return this.isSetConsistency_level();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof MultiSliceRequest) {
            return this.equals((MultiSliceRequest)that);
        }
        return false;
    }

    public boolean equals(MultiSliceRequest that) {
        if (that == null) {
            return false;
        }
        boolean this_present_key = this.isSetKey();
        boolean that_present_key = that.isSetKey();
        if (this_present_key || that_present_key) {
            if (!this_present_key || !that_present_key) {
                return false;
            }
            if (!this.key.equals(that.key)) {
                return false;
            }
        }
        boolean this_present_column_parent = this.isSetColumn_parent();
        boolean that_present_column_parent = that.isSetColumn_parent();
        if (this_present_column_parent || that_present_column_parent) {
            if (!this_present_column_parent || !that_present_column_parent) {
                return false;
            }
            if (!this.column_parent.equals(that.column_parent)) {
                return false;
            }
        }
        boolean this_present_column_slices = this.isSetColumn_slices();
        boolean that_present_column_slices = that.isSetColumn_slices();
        if (this_present_column_slices || that_present_column_slices) {
            if (!this_present_column_slices || !that_present_column_slices) {
                return false;
            }
            if (!this.column_slices.equals(that.column_slices)) {
                return false;
            }
        }
        boolean this_present_reversed = this.isSetReversed();
        boolean that_present_reversed = that.isSetReversed();
        if (this_present_reversed || that_present_reversed) {
            if (!this_present_reversed || !that_present_reversed) {
                return false;
            }
            if (this.reversed != that.reversed) {
                return false;
            }
        }
        boolean this_present_count = this.isSetCount();
        boolean that_present_count = that.isSetCount();
        if (this_present_count || that_present_count) {
            if (!this_present_count || !that_present_count) {
                return false;
            }
            if (this.count != that.count) {
                return false;
            }
        }
        boolean this_present_consistency_level = this.isSetConsistency_level();
        boolean that_present_consistency_level = that.isSetConsistency_level();
        if (this_present_consistency_level || that_present_consistency_level) {
            if (!this_present_consistency_level || !that_present_consistency_level) {
                return false;
            }
            if (!this.consistency_level.equals((Object)that.consistency_level)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        boolean present_key = this.isSetKey();
        builder.append(present_key);
        if (present_key) {
            builder.append((Object)this.key);
        }
        boolean present_column_parent = this.isSetColumn_parent();
        builder.append(present_column_parent);
        if (present_column_parent) {
            builder.append((Object)this.column_parent);
        }
        boolean present_column_slices = this.isSetColumn_slices();
        builder.append(present_column_slices);
        if (present_column_slices) {
            builder.append(this.column_slices);
        }
        boolean present_reversed = this.isSetReversed();
        builder.append(present_reversed);
        if (present_reversed) {
            builder.append(this.reversed);
        }
        boolean present_count = this.isSetCount();
        builder.append(present_count);
        if (present_count) {
            builder.append(this.count);
        }
        boolean present_consistency_level = this.isSetConsistency_level();
        builder.append(present_consistency_level);
        if (present_consistency_level) {
            builder.append(this.consistency_level.getValue());
        }
        return builder.toHashCode();
    }

    @Override
    public int compareTo(MultiSliceRequest other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        lastComparison = Boolean.valueOf(this.isSetKey()).compareTo(other.isSetKey());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetKey() && (lastComparison = TBaseHelper.compareTo((Comparable)this.key, (Comparable)other.key)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetColumn_parent()).compareTo(other.isSetColumn_parent());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetColumn_parent() && (lastComparison = TBaseHelper.compareTo((Comparable)this.column_parent, (Comparable)other.column_parent)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetColumn_slices()).compareTo(other.isSetColumn_slices());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetColumn_slices() && (lastComparison = TBaseHelper.compareTo(this.column_slices, other.column_slices)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetReversed()).compareTo(other.isSetReversed());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetReversed() && (lastComparison = TBaseHelper.compareTo((boolean)this.reversed, (boolean)other.reversed)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetCount()).compareTo(other.isSetCount());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetCount() && (lastComparison = TBaseHelper.compareTo((int)this.count, (int)other.count)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetConsistency_level()).compareTo(other.isSetConsistency_level());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetConsistency_level() && (lastComparison = TBaseHelper.compareTo((Comparable)((Object)this.consistency_level), (Comparable)((Object)other.consistency_level))) != 0) {
            return lastComparison;
        }
        return 0;
    }

    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    public void read(TProtocol iprot) throws TException {
        schemes.get(iprot.getScheme()).getScheme().read(iprot, (TBase)this);
    }

    public void write(TProtocol oprot) throws TException {
        schemes.get(oprot.getScheme()).getScheme().write(oprot, (TBase)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("MultiSliceRequest(");
        boolean first = true;
        if (this.isSetKey()) {
            sb.append("key:");
            if (this.key == null) {
                sb.append("null");
            } else {
                TBaseHelper.toString((ByteBuffer)this.key, (StringBuilder)sb);
            }
            first = false;
        }
        if (this.isSetColumn_parent()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("column_parent:");
            if (this.column_parent == null) {
                sb.append("null");
            } else {
                sb.append(this.column_parent);
            }
            first = false;
        }
        if (this.isSetColumn_slices()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("column_slices:");
            if (this.column_slices == null) {
                sb.append("null");
            } else {
                sb.append(this.column_slices);
            }
            first = false;
        }
        if (this.isSetReversed()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("reversed:");
            sb.append(this.reversed);
            first = false;
        }
        if (this.isSetCount()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("count:");
            sb.append(this.count);
            first = false;
        }
        if (this.isSetConsistency_level()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("consistency_level:");
            if (this.consistency_level == null) {
                sb.append("null");
            } else {
                sb.append((Object)this.consistency_level);
            }
            first = false;
        }
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (this.column_parent != null) {
            this.column_parent.validate();
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.__isset_bitfield = 0;
            this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    static {
        schemes.put(StandardScheme.class, new MultiSliceRequestStandardSchemeFactory());
        schemes.put(TupleScheme.class, new MultiSliceRequestTupleSchemeFactory());
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.KEY, new FieldMetaData("key", 2, new FieldValueMetaData(11, true)));
        tmpMap.put(_Fields.COLUMN_PARENT, new FieldMetaData("column_parent", 2, (FieldValueMetaData)new StructMetaData(12, ColumnParent.class)));
        tmpMap.put(_Fields.COLUMN_SLICES, new FieldMetaData("column_slices", 2, (FieldValueMetaData)new ListMetaData(15, (FieldValueMetaData)new StructMetaData(12, ColumnSlice.class))));
        tmpMap.put(_Fields.REVERSED, new FieldMetaData("reversed", 2, new FieldValueMetaData(2)));
        tmpMap.put(_Fields.COUNT, new FieldMetaData("count", 2, new FieldValueMetaData(8)));
        tmpMap.put(_Fields.CONSISTENCY_LEVEL, new FieldMetaData("consistency_level", 2, (FieldValueMetaData)new EnumMetaData(16, ConsistencyLevel.class)));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(MultiSliceRequest.class, metaDataMap);
    }

    private static class MultiSliceRequestTupleScheme
    extends TupleScheme<MultiSliceRequest> {
        private MultiSliceRequestTupleScheme() {
        }

        public void write(TProtocol prot, MultiSliceRequest struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            BitSet optionals = new BitSet();
            if (struct.isSetKey()) {
                optionals.set(0);
            }
            if (struct.isSetColumn_parent()) {
                optionals.set(1);
            }
            if (struct.isSetColumn_slices()) {
                optionals.set(2);
            }
            if (struct.isSetReversed()) {
                optionals.set(3);
            }
            if (struct.isSetCount()) {
                optionals.set(4);
            }
            if (struct.isSetConsistency_level()) {
                optionals.set(5);
            }
            oprot.writeBitSet(optionals, 6);
            if (struct.isSetKey()) {
                oprot.writeBinary(struct.key);
            }
            if (struct.isSetColumn_parent()) {
                struct.column_parent.write((TProtocol)oprot);
            }
            if (struct.isSetColumn_slices()) {
                oprot.writeI32(struct.column_slices.size());
                for (ColumnSlice _iter220 : struct.column_slices) {
                    _iter220.write((TProtocol)oprot);
                }
            }
            if (struct.isSetReversed()) {
                oprot.writeBool(struct.reversed);
            }
            if (struct.isSetCount()) {
                oprot.writeI32(struct.count);
            }
            if (struct.isSetConsistency_level()) {
                oprot.writeI32(struct.consistency_level.getValue());
            }
        }

        public void read(TProtocol prot, MultiSliceRequest struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            BitSet incoming = iprot.readBitSet(6);
            if (incoming.get(0)) {
                struct.key = iprot.readBinary();
                struct.setKeyIsSet(true);
            }
            if (incoming.get(1)) {
                struct.column_parent = new ColumnParent();
                struct.column_parent.read((TProtocol)iprot);
                struct.setColumn_parentIsSet(true);
            }
            if (incoming.get(2)) {
                TList _list221 = new TList(12, iprot.readI32());
                struct.column_slices = new ArrayList<ColumnSlice>(_list221.size);
                for (int _i222 = 0; _i222 < _list221.size; ++_i222) {
                    ColumnSlice _elem223 = new ColumnSlice();
                    _elem223.read((TProtocol)iprot);
                    struct.column_slices.add(_elem223);
                }
                struct.setColumn_slicesIsSet(true);
            }
            if (incoming.get(3)) {
                struct.reversed = iprot.readBool();
                struct.setReversedIsSet(true);
            }
            if (incoming.get(4)) {
                struct.count = iprot.readI32();
                struct.setCountIsSet(true);
            }
            if (incoming.get(5)) {
                struct.consistency_level = ConsistencyLevel.findByValue(iprot.readI32());
                struct.setConsistency_levelIsSet(true);
            }
        }
    }

    private static class MultiSliceRequestTupleSchemeFactory
    implements SchemeFactory {
        private MultiSliceRequestTupleSchemeFactory() {
        }

        public MultiSliceRequestTupleScheme getScheme() {
            return new MultiSliceRequestTupleScheme();
        }
    }

    private static class MultiSliceRequestStandardScheme
    extends StandardScheme<MultiSliceRequest> {
        private MultiSliceRequestStandardScheme() {
        }

        public void read(TProtocol iprot, MultiSliceRequest struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 11) {
                            struct.key = iprot.readBinary();
                            struct.setKeyIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 12) {
                            struct.column_parent = new ColumnParent();
                            struct.column_parent.read(iprot);
                            struct.setColumn_parentIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 3: {
                        if (schemeField.type == 15) {
                            TList _list216 = iprot.readListBegin();
                            struct.column_slices = new ArrayList<ColumnSlice>(_list216.size);
                            for (int _i217 = 0; _i217 < _list216.size; ++_i217) {
                                ColumnSlice _elem218 = new ColumnSlice();
                                _elem218.read(iprot);
                                struct.column_slices.add(_elem218);
                            }
                            iprot.readListEnd();
                            struct.setColumn_slicesIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 4: {
                        if (schemeField.type == 2) {
                            struct.reversed = iprot.readBool();
                            struct.setReversedIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 5: {
                        if (schemeField.type == 8) {
                            struct.count = iprot.readI32();
                            struct.setCountIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 6: {
                        if (schemeField.type == 8) {
                            struct.consistency_level = ConsistencyLevel.findByValue(iprot.readI32());
                            struct.setConsistency_levelIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            struct.validate();
        }

        public void write(TProtocol oprot, MultiSliceRequest struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (struct.key != null && struct.isSetKey()) {
                oprot.writeFieldBegin(KEY_FIELD_DESC);
                oprot.writeBinary(struct.key);
                oprot.writeFieldEnd();
            }
            if (struct.column_parent != null && struct.isSetColumn_parent()) {
                oprot.writeFieldBegin(COLUMN_PARENT_FIELD_DESC);
                struct.column_parent.write(oprot);
                oprot.writeFieldEnd();
            }
            if (struct.column_slices != null && struct.isSetColumn_slices()) {
                oprot.writeFieldBegin(COLUMN_SLICES_FIELD_DESC);
                oprot.writeListBegin(new TList(12, struct.column_slices.size()));
                for (ColumnSlice _iter219 : struct.column_slices) {
                    _iter219.write(oprot);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            if (struct.isSetReversed()) {
                oprot.writeFieldBegin(REVERSED_FIELD_DESC);
                oprot.writeBool(struct.reversed);
                oprot.writeFieldEnd();
            }
            if (struct.isSetCount()) {
                oprot.writeFieldBegin(COUNT_FIELD_DESC);
                oprot.writeI32(struct.count);
                oprot.writeFieldEnd();
            }
            if (struct.consistency_level != null && struct.isSetConsistency_level()) {
                oprot.writeFieldBegin(CONSISTENCY_LEVEL_FIELD_DESC);
                oprot.writeI32(struct.consistency_level.getValue());
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }

    private static class MultiSliceRequestStandardSchemeFactory
    implements SchemeFactory {
        private MultiSliceRequestStandardSchemeFactory() {
        }

        public MultiSliceRequestStandardScheme getScheme() {
            return new MultiSliceRequestStandardScheme();
        }
    }

    public static enum _Fields implements TFieldIdEnum
    {
        KEY(1, "key"),
        COLUMN_PARENT(2, "column_parent"),
        COLUMN_SLICES(3, "column_slices"),
        REVERSED(4, "reversed"),
        COUNT(5, "count"),
        CONSISTENCY_LEVEL(6, "consistency_level");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return KEY;
                }
                case 2: {
                    return COLUMN_PARENT;
                }
                case 3: {
                    return COLUMN_SLICES;
                }
                case 4: {
                    return REVERSED;
                }
                case 5: {
                    return COUNT;
                }
                case 6: {
                    return CONSISTENCY_LEVEL;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        public short getThriftFieldId() {
            return this._thriftId;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

