/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.auth;

import java.util.Set;
import org.apache.cassandra.auth.IRoleManager;
import org.apache.cassandra.auth.RoleResource;
import org.apache.cassandra.auth.RolesCache;
import org.apache.cassandra.config.DatabaseDescriptor;

public class Roles {
    private static final RolesCache cache = new RolesCache(DatabaseDescriptor.getRoleManager());

    public static Set<RoleResource> getRoles(RoleResource primaryRole) {
        return cache.getRoles(primaryRole);
    }

    public static boolean hasSuperuserStatus(RoleResource role) {
        IRoleManager roleManager = DatabaseDescriptor.getRoleManager();
        for (RoleResource r : cache.getRoles(role)) {
            if (!roleManager.isSuper(r)) continue;
            return true;
        }
        return false;
    }
}

