/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.compaction;

import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.cassandra.db.compaction.AbstractCompactedRow;
import org.apache.cassandra.db.compaction.CompactionController;
import org.apache.cassandra.db.compaction.CompactionInfo;
import org.apache.cassandra.db.compaction.OperationType;
import org.apache.cassandra.io.sstable.ISSTableScanner;
import org.apache.cassandra.utils.CloseableIterator;

public abstract class AbstractCompactionIterable
extends CompactionInfo.Holder
implements Iterable<AbstractCompactedRow> {
    protected final OperationType type;
    protected final CompactionController controller;
    protected final long totalBytes;
    protected volatile long bytesRead;
    protected final List<ISSTableScanner> scanners;
    protected final UUID compactionId;
    protected final AtomicLong[] mergeCounters;

    public AbstractCompactionIterable(CompactionController controller, OperationType type, List<ISSTableScanner> scanners, UUID compactionId) {
        this.controller = controller;
        this.type = type;
        this.scanners = scanners;
        this.bytesRead = 0L;
        this.compactionId = compactionId;
        long bytes = 0L;
        for (ISSTableScanner scanner : scanners) {
            bytes += scanner.getLengthInBytes();
        }
        this.totalBytes = bytes;
        this.mergeCounters = new AtomicLong[scanners.size()];
        for (int i = 0; i < this.mergeCounters.length; ++i) {
            this.mergeCounters[i] = new AtomicLong();
        }
    }

    @Override
    public CompactionInfo getCompactionInfo() {
        return new CompactionInfo(this.controller.cfs.metadata, this.type, this.bytesRead, this.totalBytes, this.compactionId);
    }

    protected void updateCounterFor(int rows) {
        assert (rows > 0 && rows - 1 < this.mergeCounters.length);
        this.mergeCounters[rows - 1].incrementAndGet();
    }

    public long[] getMergedRowCounts() {
        long[] counters = new long[this.mergeCounters.length];
        for (int i = 0; i < counters.length; ++i) {
            counters[i] = this.mergeCounters[i].get();
        }
        return counters;
    }

    @Override
    public abstract CloseableIterator<AbstractCompactedRow> iterator();
}

