/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.marshal;

import java.nio.ByteBuffer;
import java.util.UUID;
import org.apache.cassandra.cql3.CQL3Type;
import org.apache.cassandra.cql3.Constants;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.UUIDType;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.serializers.TimeUUIDSerializer;
import org.apache.cassandra.serializers.TypeSerializer;

public class TimeUUIDType
extends AbstractType<UUID> {
    public static final TimeUUIDType instance = new TimeUUIDType();

    TimeUUIDType() {
    }

    @Override
    public boolean isEmptyValueMeaningless() {
        return true;
    }

    @Override
    public int compare(ByteBuffer b1, ByteBuffer b2) {
        boolean p2;
        int s1 = b1.position();
        int s2 = b2.position();
        int l1 = b1.limit();
        int l2 = b2.limit();
        boolean p1 = l1 - s1 == 16;
        boolean bl = p2 = l2 - s2 == 16;
        if (!(p1 & p2)) {
            assert (p1 | l1 == s1);
            assert (p2 | l2 == s2);
            return p1 ? 1 : (p2 ? -1 : 0);
        }
        long msb1 = b1.getLong(s1);
        long msb2 = b2.getLong(s2);
        msb1 = TimeUUIDType.reorderTimestampBytes(msb1);
        msb2 = TimeUUIDType.reorderTimestampBytes(msb2);
        assert ((msb1 & TimeUUIDType.topbyte(240L)) == TimeUUIDType.topbyte(16L));
        assert ((msb2 & TimeUUIDType.topbyte(240L)) == TimeUUIDType.topbyte(16L));
        int c = Long.compare(msb1, msb2);
        if (c != 0) {
            return c;
        }
        long lsb1 = TimeUUIDType.signedBytesToNativeLong(b1.getLong(s1 + 8));
        long lsb2 = TimeUUIDType.signedBytesToNativeLong(b2.getLong(s2 + 8));
        return Long.compare(lsb1, lsb2);
    }

    private static long signedBytesToNativeLong(long signedBytes) {
        return signedBytes ^ 0x80808080808080L;
    }

    private static long topbyte(long topbyte) {
        return topbyte << 56;
    }

    protected static long reorderTimestampBytes(long input) {
        return input << 48 | input << 16 & 0xFFFF00000000L | input >>> 32;
    }

    @Override
    public ByteBuffer fromString(String source) throws MarshalException {
        ByteBuffer parsed = UUIDType.parse(source);
        if (parsed == null) {
            throw new MarshalException(String.format("Unknown timeuuid representation: %s", source));
        }
        if (parsed.remaining() == 16 && UUIDType.version(parsed) != 1) {
            throw new MarshalException("TimeUUID supports only version 1 UUIDs");
        }
        return parsed;
    }

    @Override
    public Term fromJSONObject(Object parsed) throws MarshalException {
        try {
            return new Constants.Value(this.fromString((String)parsed));
        }
        catch (ClassCastException exc) {
            throw new MarshalException(String.format("Expected a string representation of a timeuuid, but got a %s: %s", parsed.getClass().getSimpleName(), parsed));
        }
    }

    @Override
    public CQL3Type asCQL3Type() {
        return CQL3Type.Native.TIMEUUID;
    }

    @Override
    public TypeSerializer<UUID> getSerializer() {
        return TimeUUIDSerializer.instance;
    }
}

