/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools.nodetool;

import com.google.common.collect.Iterables;
import io.airlift.command.Arguments;
import io.airlift.command.Command;
import io.airlift.command.Option;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.cassandra.tools.NodeProbe;
import org.apache.cassandra.tools.NodeTool;
import org.apache.commons.lang3.StringUtils;

@Command(name="snapshot", description="Take a snapshot of specified keyspaces or a snapshot of the specified table")
public class Snapshot
extends NodeTool.NodeToolCmd {
    @Arguments(usage="[<keyspaces...>]", description="List of keyspaces. By default, all keyspaces")
    private List<String> keyspaces = new ArrayList<String>();
    @Option(title="table", name={"-cf", "--column-family", "--table"}, description="The table name (you must specify one and only one keyspace for using this option)")
    private String table = null;
    @Option(title="tag", name={"-t", "--tag"}, description="The name of the snapshot")
    private String snapshotName = Long.toString(System.currentTimeMillis());
    @Option(title="ktlist", name={"-kt", "--kt-list", "-kc", "--kc.list"}, description="The list of Keyspace.table to take snapshot.(you must not specify only keyspace)")
    private String ktList = null;

    @Override
    public void execute(NodeProbe probe) {
        try {
            StringBuilder sb = new StringBuilder();
            sb.append("Requested creating snapshot(s) for ");
            if (null != this.ktList && !this.ktList.isEmpty()) {
                this.ktList = this.ktList.replace(" ", "");
                if (!this.keyspaces.isEmpty() || null != this.table) {
                    throw new IOException("When specifying the Keyspace columfamily list for a snapshot, you should not specify columnfamily");
                }
                sb.append("[").append(this.ktList).append("]");
                if (!this.snapshotName.isEmpty()) {
                    sb.append(" with snapshot name [").append(this.snapshotName).append("]");
                }
                System.out.println(sb.toString());
                probe.takeMultipleColumnFamilySnapshot(this.snapshotName, this.ktList.split(","));
                System.out.println("Snapshot directory: " + this.snapshotName);
            } else {
                if (this.keyspaces.isEmpty()) {
                    sb.append("[all keyspaces]");
                } else {
                    sb.append("[").append(StringUtils.join(this.keyspaces, (String)", ")).append("]");
                }
                if (!this.snapshotName.isEmpty()) {
                    sb.append(" with snapshot name [").append(this.snapshotName).append("]");
                }
                System.out.println(sb.toString());
                probe.takeSnapshot(this.snapshotName, this.table, (String[])Iterables.toArray(this.keyspaces, String.class));
                System.out.println("Snapshot directory: " + this.snapshotName);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error during taking a snapshot", e);
        }
    }
}

