/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils.memory;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.cassandra.db.Cell;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.utils.concurrent.OpOrder;
import org.apache.cassandra.utils.memory.MemtableAllocator;
import org.apache.cassandra.utils.memory.MemtableBufferAllocator;
import org.apache.cassandra.utils.memory.MemtablePool;

public class HeapPool
extends MemtablePool {
    public HeapPool(long maxOnHeapMemory, float cleanupThreshold, Runnable cleaner) {
        super(maxOnHeapMemory, 0L, cleanupThreshold, cleaner);
    }

    @Override
    public boolean needToCopyOnHeap() {
        return false;
    }

    @Override
    public MemtableAllocator newAllocator() {
        return new Allocator(this);
    }

    public static class Allocator
    extends MemtableBufferAllocator {
        Allocator(HeapPool pool) {
            super(pool.onHeap.newAllocator(), pool.offHeap.newAllocator());
        }

        @Override
        public ByteBuffer allocate(int size, OpOrder.Group opGroup) {
            super.onHeap().allocate(size, opGroup);
            return ByteBuffer.allocate(size);
        }

        @Override
        public MemtableAllocator.DataReclaimer reclaimer() {
            return new Reclaimer();
        }

        private class Reclaimer
        implements MemtableAllocator.DataReclaimer {
            List<Cell> delayed;

            private Reclaimer() {
            }

            @Override
            public Reclaimer reclaim(Cell cell) {
                if (this.delayed == null) {
                    this.delayed = new ArrayList<Cell>();
                }
                this.delayed.add(cell);
                return this;
            }

            @Override
            public Reclaimer reclaimImmediately(Cell cell) {
                Allocator.this.onHeap().released(cell.name().dataSize() + cell.value().remaining());
                return this;
            }

            @Override
            public Reclaimer reclaimImmediately(DecoratedKey key) {
                Allocator.this.onHeap().released(key.getKey().remaining());
                return this;
            }

            @Override
            public void cancel() {
                if (this.delayed != null) {
                    this.delayed.clear();
                }
            }

            @Override
            public void commit() {
                if (this.delayed != null) {
                    for (Cell cell : this.delayed) {
                        this.reclaimImmediately(cell);
                    }
                }
            }
        }
    }
}

