/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils.vint;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.cassandra.io.util.UnbufferedDataOutputStreamPlus;

public class EncodedDataOutputStream
extends UnbufferedDataOutputStreamPlus {
    private OutputStream out;

    public EncodedDataOutputStream(OutputStream out) {
        this.out = out;
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.out.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
    }

    @Override
    public void writeInt(int v) throws IOException {
        this.vintEncode(v);
    }

    @Override
    public void writeLong(long v) throws IOException {
        this.vintEncode(v);
    }

    @Override
    public void writeShort(int v) throws IOException {
        this.vintEncode(v);
    }

    private void vintEncode(long i) throws IOException {
        if (i >= -112L && i <= 127L) {
            this.writeByte((byte)i);
            return;
        }
        int len = -112;
        if (i < 0L) {
            i ^= 0xFFFFFFFFFFFFFFFFL;
            len = -120;
        }
        long tmp = i;
        while (tmp != 0L) {
            tmp >>= 8;
            --len;
        }
        this.writeByte((byte)len);
        for (int idx = len = len < -120 ? -(len + 120) : -(len + 112); idx != 0; --idx) {
            int shiftbits = (idx - 1) * 8;
            long mask = 255L << shiftbits;
            this.writeByte((byte)((i & mask) >> shiftbits));
        }
    }
}

