/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar.cmd;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.SigarProxy;
import org.hyperic.sigar.cmd.Shell;
import org.hyperic.sigar.pager.PageFetchException;
import org.hyperic.sigar.pager.StaticPageFetcher;
import org.hyperic.sigar.shell.CollectionCompleter;
import org.hyperic.sigar.shell.ProcessQueryCompleter;
import org.hyperic.sigar.shell.ShellCommandBase;
import org.hyperic.sigar.shell.ShellCommandExecException;
import org.hyperic.sigar.shell.ShellCommandUsageException;
import org.hyperic.sigar.util.GetlineCompleter;
import org.hyperic.sigar.util.PrintfFormat;

public abstract class SigarCommandBase
extends ShellCommandBase
implements GetlineCompleter {
    protected Shell shell;
    protected PrintStream out = System.out;
    protected PrintStream err = System.err;
    protected Sigar sigar;
    protected SigarProxy proxy;
    protected List output = new ArrayList();
    private CollectionCompleter completer;
    private GetlineCompleter ptqlCompleter;
    private Collection completions = new ArrayList();
    private PrintfFormat formatter;
    private ArrayList printfItems = new ArrayList();

    public SigarCommandBase(Shell shell) {
        this.shell = shell;
        this.out = shell.getOutStream();
        this.err = shell.getErrStream();
        this.sigar = shell.getSigar();
        this.proxy = shell.getSigarProxy();
        this.completer = new CollectionCompleter(shell);
        if (this.isPidCompleter()) {
            this.ptqlCompleter = new ProcessQueryCompleter(shell);
        }
    }

    public SigarCommandBase() {
        this(new Shell());
        this.shell.setPageSize(-1);
    }

    public void setOutputFormat(String format) {
        this.formatter = new PrintfFormat(format);
    }

    public PrintfFormat getFormatter() {
        return this.formatter;
    }

    public String sprintf(String format, Object[] items) {
        return new PrintfFormat(format).sprintf(items);
    }

    public void printf(String format, Object[] items) {
        this.println(this.sprintf(format, items));
    }

    public void printf(Object[] items) {
        PrintfFormat formatter = this.getFormatter();
        if (formatter == null) {
            this.printfItems.add(items);
        } else {
            this.println(formatter.sprintf(items));
        }
    }

    public void printf(List items) {
        this.printf(items.toArray(new Object[0]));
    }

    public void println(String line) {
        if (this.shell.isInteractive()) {
            this.output.add(line);
        } else {
            this.out.println(line);
        }
    }

    private void flushPrintfItems() {
        if (this.printfItems.size() == 0) {
            return;
        }
        int[] max = null;
        Iterator it = this.printfItems.iterator();
        while (it.hasNext()) {
            Object[] items = (Object[])it.next();
            if (max == null) {
                max = new int[items.length];
                Arrays.fill(max, 0);
            }
            for (int i = 0; i < items.length; ++i) {
                int len = items[i].toString().length();
                if (len <= max[i]) continue;
                max[i] = len;
            }
        }
        StringBuffer format = new StringBuffer();
        for (int i = 0; i < max.length; ++i) {
            format.append("%-" + max[i] + "s");
            if (i >= max.length - 1) continue;
            format.append("    ");
        }
        Iterator it2 = this.printfItems.iterator();
        while (it2.hasNext()) {
            this.printf(format.toString(), (Object[])it2.next());
        }
        this.printfItems.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        this.flushPrintfItems();
        try {
            this.shell.performPaging(new StaticPageFetcher(this.output));
        }
        catch (PageFetchException e) {
            this.err.println("Error paging: " + e.getMessage());
        }
        finally {
            this.output.clear();
        }
    }

    public abstract void output(String[] var1) throws SigarException;

    protected boolean validateArgs(String[] args) {
        return args.length == 0;
    }

    public void processCommand(String[] args) throws ShellCommandUsageException, ShellCommandExecException {
        if (!this.validateArgs(args)) {
            throw new ShellCommandUsageException(this.getSyntax());
        }
        try {
            this.output(args);
        }
        catch (SigarException e) {
            throw new ShellCommandExecException(e.getMessage());
        }
    }

    public Collection getCompletions() {
        return this.completions;
    }

    public GetlineCompleter getCompleter() {
        return null;
    }

    public boolean isPidCompleter() {
        return false;
    }

    public String completePid(String line) {
        if (line.length() >= 1 && Character.isDigit(line.charAt(0))) {
            return line;
        }
        return this.ptqlCompleter.complete(line);
    }

    public String complete(String line) {
        if (this.isPidCompleter()) {
            return this.completePid(line);
        }
        GetlineCompleter c = this.getCompleter();
        if (c != null) {
            return c.complete(line);
        }
        this.completer.setCollection(this.getCompletions());
        return this.completer.complete(line);
    }
}

