/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.config;

import com.google.common.collect.ImmutableSet;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Set;
import java.util.UUID;

public final class SchemaConstants {
    public static final String SYSTEM_KEYSPACE_NAME = "system";
    public static final String SCHEMA_KEYSPACE_NAME = "system_schema";
    public static final String TRACE_KEYSPACE_NAME = "system_traces";
    public static final String AUTH_KEYSPACE_NAME = "system_auth";
    public static final String DISTRIBUTED_KEYSPACE_NAME = "system_distributed";
    public static final Set<String> LOCAL_SYSTEM_KEYSPACE_NAMES = ImmutableSet.of((Object)"system", (Object)"system_schema");
    public static final Set<String> REPLICATED_SYSTEM_KEYSPACE_NAMES = ImmutableSet.of((Object)"system_traces", (Object)"system_auth", (Object)"system_distributed");
    public static final int NAME_LENGTH = 48;
    public static final UUID emptyVersion;

    public static boolean isLocalSystemKeyspace(String keyspaceName) {
        return LOCAL_SYSTEM_KEYSPACE_NAMES.contains(keyspaceName.toLowerCase());
    }

    public static boolean isReplicatedSystemKeyspace(String keyspaceName) {
        return REPLICATED_SYSTEM_KEYSPACE_NAMES.contains(keyspaceName.toLowerCase());
    }

    static {
        try {
            emptyVersion = UUID.nameUUIDFromBytes(MessageDigest.getInstance("MD5").digest());
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError();
        }
    }
}

