/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.cql3.AbstractMarker;
import org.apache.cassandra.cql3.AssignmentTestable;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.cql3.Constants;
import org.apache.cassandra.cql3.Maps;
import org.apache.cassandra.cql3.Operation;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.cql3.Terms;
import org.apache.cassandra.cql3.UpdateParameters;
import org.apache.cassandra.cql3.VariableSpecifications;
import org.apache.cassandra.cql3.functions.Function;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.MapType;
import org.apache.cassandra.db.marshal.SetType;
import org.apache.cassandra.db.rows.CellPath;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.serializers.CollectionSerializer;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.serializers.SetSerializer;
import org.apache.cassandra.transport.ProtocolVersion;
import org.apache.cassandra.utils.ByteBufferUtil;

public abstract class Sets {
    private Sets() {
    }

    public static ColumnSpecification valueSpecOf(ColumnSpecification column) {
        return new ColumnSpecification(column.ksName, column.cfName, new ColumnIdentifier("value(" + column.name + ")", true), ((SetType)column.type).getElementsType());
    }

    public static class ElementDiscarder
    extends Operation {
        public ElementDiscarder(ColumnDefinition column, Term k) {
            super(column, k);
        }

        @Override
        public void execute(DecoratedKey partitionKey, UpdateParameters params) throws InvalidRequestException {
            assert (this.column.type.isMultiCell()) : "Attempted to delete a single element in a frozen set";
            Term.Terminal elt = this.t.bind(params.options);
            if (elt == null) {
                throw new InvalidRequestException("Invalid null set element");
            }
            params.addTombstone(this.column, CellPath.create(elt.get(params.options.getProtocolVersion())));
        }
    }

    public static class Discarder
    extends Operation {
        public Discarder(ColumnDefinition column, Term t) {
            super(column, t);
        }

        @Override
        public void execute(DecoratedKey partitionKey, UpdateParameters params) throws InvalidRequestException {
            assert (this.column.type.isMultiCell()) : "Attempted to remove items from a frozen set";
            Term.Terminal value = this.t.bind(params.options);
            if (value == null || value == Constants.UNSET_VALUE) {
                return;
            }
            SortedSet<ByteBuffer> toDiscard = value instanceof Value ? ((Value)value).elements : Collections.singleton(value.get(params.options.getProtocolVersion()));
            for (ByteBuffer bb : toDiscard) {
                params.addTombstone(this.column, CellPath.create(bb));
            }
        }
    }

    public static class Adder
    extends Operation {
        public Adder(ColumnDefinition column, Term t) {
            super(column, t);
        }

        @Override
        public void execute(DecoratedKey partitionKey, UpdateParameters params) throws InvalidRequestException {
            assert (this.column.type.isMultiCell()) : "Attempted to add items to a frozen set";
            Term.Terminal value = this.t.bind(params.options);
            if (value != Constants.UNSET_VALUE) {
                Adder.doAdd(value, this.column, params);
            }
        }

        static void doAdd(Term.Terminal value, ColumnDefinition column, UpdateParameters params) throws InvalidRequestException {
            if (column.type.isMultiCell()) {
                if (value == null) {
                    return;
                }
                for (ByteBuffer bb : ((Value)value).elements) {
                    if (bb == ByteBufferUtil.UNSET_BYTE_BUFFER) continue;
                    params.addCell(column, CellPath.create(bb), ByteBufferUtil.EMPTY_BYTE_BUFFER);
                }
            } else if (value == null) {
                params.addTombstone(column);
            } else {
                params.addCell(column, value.get(ProtocolVersion.CURRENT));
            }
        }
    }

    public static class Setter
    extends Operation {
        public Setter(ColumnDefinition column, Term t) {
            super(column, t);
        }

        @Override
        public void execute(DecoratedKey partitionKey, UpdateParameters params) throws InvalidRequestException {
            Term.Terminal value = this.t.bind(params.options);
            if (value == Constants.UNSET_VALUE) {
                return;
            }
            if (this.column.type.isMultiCell()) {
                params.setComplexDeletionTimeForOverwrite(this.column);
            }
            Adder.doAdd(value, this.column, params);
        }
    }

    public static class Marker
    extends AbstractMarker {
        protected Marker(int bindIndex, ColumnSpecification receiver) {
            super(bindIndex, receiver);
            assert (receiver.type instanceof SetType);
        }

        @Override
        public Term.Terminal bind(QueryOptions options) throws InvalidRequestException {
            ByteBuffer value = options.getValues().get(this.bindIndex);
            if (value == null) {
                return null;
            }
            if (value == ByteBufferUtil.UNSET_BYTE_BUFFER) {
                return Constants.UNSET_VALUE;
            }
            return Value.fromSerialized(value, (SetType)this.receiver.type, options.getProtocolVersion());
        }
    }

    public static class DelayedValue
    extends Term.NonTerminal {
        private final Comparator<ByteBuffer> comparator;
        private final Set<Term> elements;

        public DelayedValue(Comparator<ByteBuffer> comparator, Set<Term> elements) {
            this.comparator = comparator;
            this.elements = elements;
        }

        @Override
        public boolean containsBindMarker() {
            return false;
        }

        @Override
        public void collectMarkerSpecification(VariableSpecifications boundNames) {
        }

        @Override
        public Term.Terminal bind(QueryOptions options) throws InvalidRequestException {
            TreeSet<ByteBuffer> buffers = new TreeSet<ByteBuffer>(this.comparator);
            for (Term t : this.elements) {
                ByteBuffer bytes = t.bindAndGet(options);
                if (bytes == null) {
                    throw new InvalidRequestException("null is not supported inside collections");
                }
                if (bytes == ByteBufferUtil.UNSET_BYTE_BUFFER) {
                    return Constants.UNSET_VALUE;
                }
                buffers.add(bytes);
            }
            return new Value(buffers);
        }

        @Override
        public void addFunctionsTo(List<Function> functions) {
            Terms.addFunctions(this.elements, functions);
        }
    }

    public static class Value
    extends Term.Terminal {
        public final SortedSet<ByteBuffer> elements;

        public Value(SortedSet<ByteBuffer> elements) {
            this.elements = elements;
        }

        public static Value fromSerialized(ByteBuffer value, SetType type, ProtocolVersion version) throws InvalidRequestException {
            try {
                Object s = ((SetSerializer)type.getSerializer()).deserializeForNativeProtocol(value, version);
                TreeSet<ByteBuffer> elements = new TreeSet<ByteBuffer>(type.getElementsType());
                Iterator iterator = s.iterator();
                while (iterator.hasNext()) {
                    Object element = iterator.next();
                    elements.add(type.getElementsType().decompose(element));
                }
                return new Value(elements);
            }
            catch (MarshalException e) {
                throw new InvalidRequestException(e.getMessage());
            }
        }

        @Override
        public ByteBuffer get(ProtocolVersion protocolVersion) {
            return CollectionSerializer.pack(this.elements, this.elements.size(), protocolVersion);
        }

        public boolean equals(SetType st, Value v) {
            if (this.elements.size() != v.elements.size()) {
                return false;
            }
            Iterator thisIter = this.elements.iterator();
            Iterator thatIter = v.elements.iterator();
            AbstractType elementsType = st.getElementsType();
            while (thisIter.hasNext()) {
                if (elementsType.compare((ByteBuffer)thisIter.next(), (ByteBuffer)thatIter.next()) == 0) continue;
                return false;
            }
            return true;
        }
    }

    public static class Literal
    extends Term.Raw {
        private final List<Term.Raw> elements;

        public Literal(List<Term.Raw> elements) {
            this.elements = elements;
        }

        @Override
        public Term prepare(String keyspace, ColumnSpecification receiver) throws InvalidRequestException {
            this.validateAssignableTo(keyspace, receiver);
            if (receiver.type instanceof MapType && this.elements.isEmpty()) {
                return new Maps.Value(Collections.emptyMap());
            }
            ColumnSpecification valueSpec = Sets.valueSpecOf(receiver);
            HashSet<Term> values = new HashSet<Term>(this.elements.size());
            boolean allTerminal = true;
            for (Term.Raw rt : this.elements) {
                Term t = rt.prepare(keyspace, valueSpec);
                if (t.containsBindMarker()) {
                    throw new InvalidRequestException(String.format("Invalid set literal for %s: bind variables are not supported inside collection literals", receiver.name));
                }
                if (t instanceof Term.NonTerminal) {
                    allTerminal = false;
                }
                values.add(t);
            }
            DelayedValue value = new DelayedValue(((SetType)receiver.type).getElementsType(), values);
            return allTerminal ? value.bind(QueryOptions.DEFAULT) : value;
        }

        private void validateAssignableTo(String keyspace, ColumnSpecification receiver) throws InvalidRequestException {
            if (!(receiver.type instanceof SetType)) {
                if (receiver.type instanceof MapType && this.elements.isEmpty()) {
                    return;
                }
                throw new InvalidRequestException(String.format("Invalid set literal for %s of type %s", receiver.name, receiver.type.asCQL3Type()));
            }
            ColumnSpecification valueSpec = Sets.valueSpecOf(receiver);
            for (Term.Raw rt : this.elements) {
                if (rt.testAssignment(keyspace, valueSpec).isAssignable()) continue;
                throw new InvalidRequestException(String.format("Invalid set literal for %s: value %s is not of type %s", receiver.name, rt, valueSpec.type.asCQL3Type()));
            }
        }

        @Override
        public AssignmentTestable.TestResult testAssignment(String keyspace, ColumnSpecification receiver) {
            if (!(receiver.type instanceof SetType)) {
                if (receiver.type instanceof MapType && this.elements.isEmpty()) {
                    return AssignmentTestable.TestResult.WEAKLY_ASSIGNABLE;
                }
                return AssignmentTestable.TestResult.NOT_ASSIGNABLE;
            }
            if (this.elements.isEmpty()) {
                return AssignmentTestable.TestResult.WEAKLY_ASSIGNABLE;
            }
            ColumnSpecification valueSpec = Sets.valueSpecOf(receiver);
            return AssignmentTestable.TestResult.testAll(keyspace, valueSpec, this.elements);
        }

        @Override
        public AbstractType<?> getExactTypeIfKnown(String keyspace) {
            for (Term.Raw term : this.elements) {
                AbstractType<?> type = term.getExactTypeIfKnown(keyspace);
                if (type == null) continue;
                return SetType.getInstance(type, false);
            }
            return null;
        }

        @Override
        public String getText() {
            return this.elements.stream().map(Term.Raw::getText).collect(Collectors.joining(", ", "{", "}"));
        }
    }
}

