/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.IOException;
import org.apache.cassandra.db.SnapshotCommand;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;

class SnapshotCommandSerializer
implements IVersionedSerializer<SnapshotCommand> {
    SnapshotCommandSerializer() {
    }

    @Override
    public void serialize(SnapshotCommand snapshot_command, DataOutputPlus out, int version) throws IOException {
        out.writeUTF(snapshot_command.keyspace);
        out.writeUTF(snapshot_command.column_family);
        out.writeUTF(snapshot_command.snapshot_name);
        out.writeBoolean(snapshot_command.clear_snapshot);
    }

    @Override
    public SnapshotCommand deserialize(DataInputPlus in, int version) throws IOException {
        String keyspace = in.readUTF();
        String column_family = in.readUTF();
        String snapshot_name = in.readUTF();
        boolean clear_snapshot = in.readBoolean();
        return new SnapshotCommand(keyspace, column_family, snapshot_name, clear_snapshot);
    }

    @Override
    public long serializedSize(SnapshotCommand sc, int version) {
        return TypeSizes.sizeof(sc.keyspace) + TypeSizes.sizeof(sc.column_family) + TypeSizes.sizeof(sc.snapshot_name) + TypeSizes.sizeof(sc.clear_snapshot);
    }
}

