/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.internal;

import java.util.List;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.CollectionType;
import org.apache.cassandra.db.marshal.CompositeType;
import org.apache.cassandra.index.internal.CassandraIndex;
import org.apache.cassandra.index.internal.composites.ClusteringColumnIndex;
import org.apache.cassandra.index.internal.composites.CollectionEntryIndex;
import org.apache.cassandra.index.internal.composites.CollectionKeyIndex;
import org.apache.cassandra.index.internal.composites.CollectionValueIndex;
import org.apache.cassandra.index.internal.composites.PartitionKeyIndex;
import org.apache.cassandra.index.internal.composites.RegularColumnIndex;
import org.apache.cassandra.index.internal.keys.KeysIndex;
import org.apache.cassandra.schema.IndexMetadata;

public interface CassandraIndexFunctions {
    public static final CassandraIndexFunctions KEYS_INDEX_FUNCTIONS = new CassandraIndexFunctions(){

        @Override
        public CassandraIndex newIndexInstance(ColumnFamilyStore baseCfs, IndexMetadata indexMetadata) {
            return new KeysIndex(baseCfs, indexMetadata);
        }
    };
    public static final CassandraIndexFunctions REGULAR_COLUMN_INDEX_FUNCTIONS = new CassandraIndexFunctions(){

        @Override
        public CassandraIndex newIndexInstance(ColumnFamilyStore baseCfs, IndexMetadata indexMetadata) {
            return new RegularColumnIndex(baseCfs, indexMetadata);
        }
    };
    public static final CassandraIndexFunctions CLUSTERING_COLUMN_INDEX_FUNCTIONS = new CassandraIndexFunctions(){

        @Override
        public CassandraIndex newIndexInstance(ColumnFamilyStore baseCfs, IndexMetadata indexMetadata) {
            return new ClusteringColumnIndex(baseCfs, indexMetadata);
        }

        @Override
        public CFMetaData.Builder addIndexClusteringColumns(CFMetaData.Builder builder, CFMetaData baseMetadata, ColumnDefinition columnDef) {
            ColumnDefinition def;
            int i;
            List<ColumnDefinition> cks = baseMetadata.clusteringColumns();
            for (i = 0; i < columnDef.position(); ++i) {
                def = cks.get(i);
                builder.addClusteringColumn(def.name, def.type);
            }
            for (i = columnDef.position() + 1; i < cks.size(); ++i) {
                def = cks.get(i);
                builder.addClusteringColumn(def.name, def.type);
            }
            return builder;
        }
    };
    public static final CassandraIndexFunctions PARTITION_KEY_INDEX_FUNCTIONS = new CassandraIndexFunctions(){

        @Override
        public CassandraIndex newIndexInstance(ColumnFamilyStore baseCfs, IndexMetadata indexMetadata) {
            return new PartitionKeyIndex(baseCfs, indexMetadata);
        }
    };
    public static final CassandraIndexFunctions COLLECTION_KEY_INDEX_FUNCTIONS = new CassandraIndexFunctions(){

        @Override
        public CassandraIndex newIndexInstance(ColumnFamilyStore baseCfs, IndexMetadata indexMetadata) {
            return new CollectionKeyIndex(baseCfs, indexMetadata);
        }

        @Override
        public AbstractType<?> getIndexedValueType(ColumnDefinition indexedColumn) {
            return ((CollectionType)indexedColumn.type).nameComparator();
        }
    };
    public static final CassandraIndexFunctions COLLECTION_VALUE_INDEX_FUNCTIONS = new CassandraIndexFunctions(){

        @Override
        public CassandraIndex newIndexInstance(ColumnFamilyStore baseCfs, IndexMetadata indexMetadata) {
            return new CollectionValueIndex(baseCfs, indexMetadata);
        }

        @Override
        public AbstractType<?> getIndexedValueType(ColumnDefinition indexedColumn) {
            return ((CollectionType)indexedColumn.type).valueComparator();
        }

        @Override
        public CFMetaData.Builder addIndexClusteringColumns(CFMetaData.Builder builder, CFMetaData baseMetadata, ColumnDefinition columnDef) {
            for (ColumnDefinition def : baseMetadata.clusteringColumns()) {
                builder.addClusteringColumn(def.name, def.type);
            }
            builder.addClusteringColumn("cell_path", ((CollectionType)columnDef.type).nameComparator());
            return builder;
        }
    };
    public static final CassandraIndexFunctions COLLECTION_ENTRY_INDEX_FUNCTIONS = new CassandraIndexFunctions(){

        @Override
        public CassandraIndex newIndexInstance(ColumnFamilyStore baseCfs, IndexMetadata indexMetadata) {
            return new CollectionEntryIndex(baseCfs, indexMetadata);
        }

        @Override
        public AbstractType<?> getIndexedValueType(ColumnDefinition indexedColumn) {
            CollectionType colType = (CollectionType)indexedColumn.type;
            return CompositeType.getInstance(colType.nameComparator(), colType.valueComparator());
        }
    };

    public CassandraIndex newIndexInstance(ColumnFamilyStore var1, IndexMetadata var2);

    default public AbstractType<?> getIndexedValueType(ColumnDefinition indexedColumn) {
        return indexedColumn.type;
    }

    default public CFMetaData.Builder addIndexClusteringColumns(CFMetaData.Builder builder, CFMetaData baseMetadata, ColumnDefinition cfDef) {
        for (ColumnDefinition def : baseMetadata.clusteringColumns()) {
            builder.addClusteringColumn(def.name, def.type);
        }
        return builder;
    }
}

