/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sasi;

import com.googlecode.concurrenttrees.common.Iterables;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.function.BiFunction;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.cql3.Operator;
import org.apache.cassandra.cql3.statements.IndexTarget;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.PartitionColumns;
import org.apache.cassandra.db.RangeTombstone;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.compaction.CompactionManager;
import org.apache.cassandra.db.compaction.OperationType;
import org.apache.cassandra.db.filter.RowFilter;
import org.apache.cassandra.db.lifecycle.Tracker;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.partitions.PartitionIterator;
import org.apache.cassandra.db.partitions.PartitionUpdate;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.dht.Murmur3Partitioner;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.index.Index;
import org.apache.cassandra.index.IndexRegistry;
import org.apache.cassandra.index.SecondaryIndexBuilder;
import org.apache.cassandra.index.TargetParser;
import org.apache.cassandra.index.sasi.SASIIndexBuilder;
import org.apache.cassandra.index.sasi.conf.ColumnIndex;
import org.apache.cassandra.index.sasi.conf.IndexMode;
import org.apache.cassandra.index.sasi.disk.OnDiskIndexBuilder;
import org.apache.cassandra.index.sasi.disk.PerSSTableIndexWriter;
import org.apache.cassandra.index.sasi.plan.QueryPlan;
import org.apache.cassandra.index.transactions.IndexTransaction;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.format.SSTableFlushObserver;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.notifications.INotification;
import org.apache.cassandra.notifications.INotificationConsumer;
import org.apache.cassandra.notifications.MemtableDiscardedNotification;
import org.apache.cassandra.notifications.MemtableRenewedNotification;
import org.apache.cassandra.notifications.MemtableSwitchedNotification;
import org.apache.cassandra.notifications.SSTableAddedNotification;
import org.apache.cassandra.notifications.SSTableListChangedNotification;
import org.apache.cassandra.schema.IndexMetadata;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.Pair;
import org.apache.cassandra.utils.concurrent.OpOrder;

public class SASIIndex
implements Index,
INotificationConsumer {
    private static final SASIIndexBuildingSupport INDEX_BUILDER_SUPPORT = new SASIIndexBuildingSupport();
    private final ColumnFamilyStore baseCfs;
    private final IndexMetadata config;
    private final ColumnIndex index;

    public SASIIndex(ColumnFamilyStore baseCfs, IndexMetadata config) {
        this.baseCfs = baseCfs;
        this.config = config;
        ColumnDefinition column = (ColumnDefinition)TargetParser.parse((CFMetaData)baseCfs.metadata, (IndexMetadata)config).left;
        this.index = new ColumnIndex(baseCfs.metadata.getKeyValidator(), column, config);
        Tracker tracker = baseCfs.getTracker();
        tracker.subscribe(this);
        TreeMap<SSTableReader, Map<ColumnDefinition, ColumnIndex>> toRebuild = new TreeMap<SSTableReader, Map<ColumnDefinition, ColumnIndex>>((a, b) -> Integer.compare(a.descriptor.generation, b.descriptor.generation));
        for (SSTableReader sstable : this.index.init(tracker.getView().liveSSTables())) {
            HashMap<ColumnDefinition, ColumnIndex> perSSTable = (HashMap<ColumnDefinition, ColumnIndex>)toRebuild.get(sstable);
            if (perSSTable == null) {
                perSSTable = new HashMap<ColumnDefinition, ColumnIndex>();
                toRebuild.put(sstable, perSSTable);
            }
            perSSTable.put(this.index.getDefinition(), this.index);
        }
        CompactionManager.instance.submitIndexBuild(new SASIIndexBuilder(baseCfs, toRebuild));
    }

    public static Map<String, String> validateOptions(Map<String, String> options, CFMetaData cfm) {
        if (!(cfm.partitioner instanceof Murmur3Partitioner)) {
            throw new ConfigurationException("SASI only supports Murmur3Partitioner.");
        }
        String targetColumn = options.get("target");
        if (targetColumn == null) {
            throw new ConfigurationException("unknown target column");
        }
        Pair<ColumnDefinition, IndexTarget.Type> target = TargetParser.parse(cfm, targetColumn);
        if (target == null) {
            throw new ConfigurationException("failed to retrieve target column for: " + targetColumn);
        }
        if (((ColumnDefinition)target.left).isComplex()) {
            throw new ConfigurationException("complex columns are not yet supported by SASI");
        }
        if (((ColumnDefinition)target.left).isPartitionKey()) {
            throw new ConfigurationException("partition key columns are not yet supported by SASI");
        }
        IndexMode.validateAnalyzer(options);
        IndexMode mode = IndexMode.getMode((ColumnDefinition)target.left, options);
        if (mode.mode == OnDiskIndexBuilder.Mode.SPARSE) {
            if (mode.isLiteral) {
                throw new ConfigurationException("SPARSE mode is only supported on non-literal columns.");
            }
            if (mode.isAnalyzed) {
                throw new ConfigurationException("SPARSE mode doesn't support analyzers.");
            }
        }
        return Collections.emptyMap();
    }

    @Override
    public void register(IndexRegistry registry) {
        registry.registerIndex(this);
    }

    @Override
    public IndexMetadata getIndexMetadata() {
        return this.config;
    }

    @Override
    public Callable<?> getInitializationTask() {
        return null;
    }

    @Override
    public Callable<?> getMetadataReloadTask(IndexMetadata indexMetadata) {
        return null;
    }

    @Override
    public Callable<?> getBlockingFlushTask() {
        return null;
    }

    @Override
    public Callable<?> getInvalidateTask() {
        return this.getTruncateTask(FBUtilities.timestampMicros());
    }

    @Override
    public Callable<?> getTruncateTask(long truncatedAt) {
        return () -> {
            this.index.dropData(truncatedAt);
            return null;
        };
    }

    @Override
    public boolean shouldBuildBlocking() {
        return true;
    }

    @Override
    public Optional<ColumnFamilyStore> getBackingTable() {
        return Optional.empty();
    }

    public boolean indexes(PartitionColumns columns) {
        return columns.contains(this.index.getDefinition());
    }

    @Override
    public boolean dependsOn(ColumnDefinition column) {
        return this.index.getDefinition().compareTo(column) == 0;
    }

    @Override
    public boolean supportsExpression(ColumnDefinition column, Operator operator) {
        return this.dependsOn(column) && this.index.supports(operator);
    }

    @Override
    public AbstractType<?> customExpressionValueType() {
        return null;
    }

    @Override
    public RowFilter getPostIndexQueryFilter(RowFilter filter) {
        return filter.withoutExpressions();
    }

    @Override
    public long getEstimatedResultRows() {
        return Long.MIN_VALUE;
    }

    @Override
    public void validate(PartitionUpdate update) throws InvalidRequestException {
    }

    @Override
    public Index.Indexer indexerFor(final DecoratedKey key, PartitionColumns columns, int nowInSec, final OpOrder.Group opGroup, final IndexTransaction.Type transactionType) {
        return new Index.Indexer(){

            @Override
            public void begin() {
            }

            @Override
            public void partitionDelete(DeletionTime deletionTime) {
            }

            @Override
            public void rangeTombstone(RangeTombstone tombstone) {
            }

            @Override
            public void insertRow(Row row) {
                if (this.isNewData()) {
                    this.adjustMemtableSize(SASIIndex.this.index.index(key, row), opGroup);
                }
            }

            @Override
            public void updateRow(Row oldRow, Row newRow) {
                this.insertRow(newRow);
            }

            @Override
            public void removeRow(Row row) {
            }

            @Override
            public void finish() {
            }

            private boolean isNewData() {
                return transactionType == IndexTransaction.Type.UPDATE;
            }

            public void adjustMemtableSize(long additionalSpace, OpOrder.Group opGroup2) {
                SASIIndex.this.baseCfs.getTracker().getView().getCurrentMemtable().getAllocator().onHeap().allocate(additionalSpace, opGroup2);
            }
        };
    }

    @Override
    public Index.Searcher searcherFor(ReadCommand command) throws InvalidRequestException {
        CFMetaData config = command.metadata();
        ColumnFamilyStore cfs = Schema.instance.getColumnFamilyStoreInstance(config.cfId);
        return controller -> new QueryPlan(cfs, command, DatabaseDescriptor.getRangeRpcTimeout()).execute(controller);
    }

    @Override
    public SSTableFlushObserver getFlushObserver(Descriptor descriptor, OperationType opType) {
        return SASIIndex.newWriter(this.baseCfs.metadata.getKeyValidator(), descriptor, Collections.singletonMap(this.index.getDefinition(), this.index), opType);
    }

    @Override
    public BiFunction<PartitionIterator, ReadCommand, PartitionIterator> postProcessorFor(ReadCommand command) {
        return (partitionIterator, readCommand) -> partitionIterator;
    }

    @Override
    public Index.IndexBuildingSupport getBuildTaskSupport() {
        return INDEX_BUILDER_SUPPORT;
    }

    @Override
    public void handleNotification(INotification notification, Object sender) {
        if (notification instanceof SSTableAddedNotification) {
            SSTableAddedNotification notice = (SSTableAddedNotification)notification;
            this.index.update(Collections.emptyList(), Iterables.toList(notice.added));
        } else if (notification instanceof SSTableListChangedNotification) {
            SSTableListChangedNotification notice = (SSTableListChangedNotification)notification;
            this.index.update(notice.removed, notice.added);
        } else if (notification instanceof MemtableRenewedNotification) {
            this.index.switchMemtable();
        } else if (notification instanceof MemtableSwitchedNotification) {
            this.index.switchMemtable(((MemtableSwitchedNotification)notification).memtable);
        } else if (notification instanceof MemtableDiscardedNotification) {
            this.index.discardMemtable(((MemtableDiscardedNotification)notification).memtable);
        }
    }

    public ColumnIndex getIndex() {
        return this.index;
    }

    protected static PerSSTableIndexWriter newWriter(AbstractType<?> keyValidator, Descriptor descriptor, Map<ColumnDefinition, ColumnIndex> indexes, OperationType opType) {
        return new PerSSTableIndexWriter(keyValidator, descriptor, opType, indexes);
    }

    private static class SASIIndexBuildingSupport
    implements Index.IndexBuildingSupport {
        private SASIIndexBuildingSupport() {
        }

        @Override
        public SecondaryIndexBuilder getIndexBuildTask(ColumnFamilyStore cfs, Set<Index> indexes, Collection<SSTableReader> sstablesToRebuild) {
            TreeMap<SSTableReader, Map<ColumnDefinition, ColumnIndex>> sstables = new TreeMap<SSTableReader, Map<ColumnDefinition, ColumnIndex>>((a, b) -> Integer.compare(a.descriptor.generation, b.descriptor.generation));
            indexes.stream().filter(i -> i instanceof SASIIndex).forEach(i -> {
                SASIIndex sasi = (SASIIndex)i;
                sasi.index.dropData(sstablesToRebuild);
                sstablesToRebuild.stream().filter(sstable -> !sasi.index.hasSSTable((SSTableReader)sstable)).forEach(sstable -> {
                    HashMap<ColumnDefinition, ColumnIndex> toBuild = (HashMap<ColumnDefinition, ColumnIndex>)sstables.get(sstable);
                    if (toBuild == null) {
                        toBuild = new HashMap<ColumnDefinition, ColumnIndex>();
                        sstables.put((SSTableReader)sstable, (Map<ColumnDefinition, ColumnIndex>)toBuild);
                    }
                    toBuild.put(sasi.index.getDefinition(), sasi.index);
                });
            });
            return new SASIIndexBuilder(cfs, sstables);
        }
    }
}

