/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sasi.conf;

import com.google.common.annotations.VisibleForTesting;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.cql3.Operator;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.Memtable;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.AsciiType;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.db.rows.Cell;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.index.sasi.analyzer.AbstractAnalyzer;
import org.apache.cassandra.index.sasi.conf.DataTracker;
import org.apache.cassandra.index.sasi.conf.IndexMode;
import org.apache.cassandra.index.sasi.conf.view.View;
import org.apache.cassandra.index.sasi.disk.OnDiskIndexBuilder;
import org.apache.cassandra.index.sasi.disk.Token;
import org.apache.cassandra.index.sasi.memory.IndexMemtable;
import org.apache.cassandra.index.sasi.plan.Expression;
import org.apache.cassandra.index.sasi.utils.RangeIterator;
import org.apache.cassandra.index.sasi.utils.RangeUnionIterator;
import org.apache.cassandra.io.sstable.Component;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.schema.IndexMetadata;
import org.apache.cassandra.utils.FBUtilities;

public class ColumnIndex {
    private static final String FILE_NAME_FORMAT = "SI_%s.db";
    private final AbstractType<?> keyValidator;
    private final ColumnDefinition column;
    private final Optional<IndexMetadata> config;
    private final AtomicReference<IndexMemtable> memtable;
    private final ConcurrentMap<Memtable, IndexMemtable> pendingFlush = new ConcurrentHashMap<Memtable, IndexMemtable>();
    private final IndexMode mode;
    private final Component component;
    private final DataTracker tracker;
    private final boolean isTokenized;

    public ColumnIndex(AbstractType<?> keyValidator, ColumnDefinition column, IndexMetadata metadata) {
        this.keyValidator = keyValidator;
        this.column = column;
        this.config = metadata == null ? Optional.empty() : Optional.of(metadata);
        this.mode = IndexMode.getMode(column, this.config);
        this.memtable = new AtomicReference<IndexMemtable>(new IndexMemtable(this));
        this.tracker = new DataTracker(keyValidator, this);
        this.component = new Component(Component.Type.SECONDARY_INDEX, String.format(FILE_NAME_FORMAT, this.getIndexName()));
        this.isTokenized = this.getAnalyzer().isTokenizing();
    }

    public Iterable<SSTableReader> init(Set<SSTableReader> sstables) {
        return this.tracker.update(Collections.emptySet(), sstables);
    }

    public AbstractType<?> keyValidator() {
        return this.keyValidator;
    }

    public long index(DecoratedKey key, Row row) {
        return this.getCurrentMemtable().index(key, ColumnIndex.getValueOf(this.column, row, FBUtilities.nowInSeconds()));
    }

    public void switchMemtable() {
        this.memtable.set(new IndexMemtable(this));
    }

    public void switchMemtable(Memtable parent) {
        this.pendingFlush.putIfAbsent(parent, this.memtable.getAndSet(new IndexMemtable(this)));
    }

    public void discardMemtable(Memtable parent) {
        this.pendingFlush.remove(parent);
    }

    @VisibleForTesting
    public IndexMemtable getCurrentMemtable() {
        return this.memtable.get();
    }

    @VisibleForTesting
    public Collection<IndexMemtable> getPendingMemtables() {
        return this.pendingFlush.values();
    }

    public RangeIterator<Long, Token> searchMemtable(Expression e) {
        RangeUnionIterator.Builder<Long, Token> builder = new RangeUnionIterator.Builder<Long, Token>();
        builder.add(this.getCurrentMemtable().search(e));
        for (IndexMemtable memtable : this.getPendingMemtables()) {
            builder.add(memtable.search(e));
        }
        return builder.build();
    }

    public void update(Collection<SSTableReader> oldSSTables, Collection<SSTableReader> newSSTables) {
        this.tracker.update(oldSSTables, newSSTables);
    }

    public ColumnDefinition getDefinition() {
        return this.column;
    }

    public AbstractType<?> getValidator() {
        return this.column.cellValueType();
    }

    public Component getComponent() {
        return this.component;
    }

    public IndexMode getMode() {
        return this.mode;
    }

    public String getColumnName() {
        return this.column.name.toString();
    }

    public String getIndexName() {
        return this.config.isPresent() ? this.config.get().name : "undefined";
    }

    public AbstractAnalyzer getAnalyzer() {
        AbstractAnalyzer analyzer = this.mode.getAnalyzer(this.getValidator());
        analyzer.init(this.config.isPresent() ? this.config.get().options : Collections.emptyMap(), this.column.cellValueType());
        return analyzer;
    }

    public View getView() {
        return this.tracker.getView();
    }

    public boolean hasSSTable(SSTableReader sstable) {
        return this.tracker.hasSSTable(sstable);
    }

    public void dropData(Collection<SSTableReader> sstablesToRebuild) {
        this.tracker.dropData(sstablesToRebuild);
    }

    public void dropData(long truncateUntil) {
        this.switchMemtable();
        this.tracker.dropData(truncateUntil);
    }

    public boolean isIndexed() {
        return this.mode != IndexMode.NOT_INDEXED;
    }

    public boolean isLiteral() {
        AbstractType<?> validator = this.getValidator();
        return this.isIndexed() ? this.mode.isLiteral : validator instanceof UTF8Type || validator instanceof AsciiType;
    }

    public boolean supports(Operator op) {
        if (op == Operator.LIKE) {
            return this.isLiteral();
        }
        Expression.Op operator = Expression.Op.valueOf(op);
        return !(this.isTokenized && operator == Expression.Op.EQ || this.isTokenized && this.mode.mode == OnDiskIndexBuilder.Mode.CONTAINS && operator == Expression.Op.PREFIX || this.isLiteral() && operator == Expression.Op.RANGE || !this.mode.supports(operator));
    }

    public static ByteBuffer getValueOf(ColumnDefinition column, Row row, int nowInSecs) {
        if (row == null) {
            return null;
        }
        switch (column.kind) {
            case CLUSTERING: {
                if (row.isStatic()) {
                    return null;
                }
                return row.clustering().get(column.position());
            }
            case STATIC: {
                if (!row.isStatic()) {
                    return null;
                }
            }
            case REGULAR: {
                Cell cell = row.getCell(column);
                return cell == null || !cell.isLive(nowInSecs) ? null : cell.value();
            }
        }
        return null;
    }
}

