/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.util;

import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Arrays;
import java.util.stream.Stream;
import org.apache.cassandra.io.FSReadError;
import org.apache.cassandra.io.compress.CompressionMetadata;
import org.apache.cassandra.io.util.ChannelProxy;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.io.util.Rebufferer;
import org.apache.cassandra.utils.JVMStabilityInspector;
import org.apache.cassandra.utils.Throwables;
import org.apache.cassandra.utils.concurrent.RefCounted;
import org.apache.cassandra.utils.concurrent.SharedCloseableImpl;
import org.slf4j.LoggerFactory;

public class MmappedRegions
extends SharedCloseableImpl {
    public static int MAX_SEGMENT_SIZE = Integer.MAX_VALUE;
    static final int REGION_ALLOC_SIZE = 15;
    private final State state;
    private volatile State copy;

    private MmappedRegions(ChannelProxy channel, CompressionMetadata metadata, long length) {
        this(new State(channel), metadata, length);
    }

    private MmappedRegions(State state, CompressionMetadata metadata, long length) {
        super(new Tidier(state));
        this.state = state;
        if (metadata != null) {
            assert (length == 0L) : "expected no length with metadata";
            this.updateState(metadata);
        } else if (length > 0L) {
            this.updateState(length);
        }
        this.copy = new State(state);
    }

    private MmappedRegions(MmappedRegions original) {
        super(original);
        this.state = original.copy;
    }

    public static MmappedRegions empty(ChannelProxy channel) {
        return new MmappedRegions(channel, null, 0L);
    }

    public static MmappedRegions map(ChannelProxy channel, CompressionMetadata metadata) {
        if (metadata == null) {
            throw new IllegalArgumentException("metadata cannot be null");
        }
        return new MmappedRegions(channel, metadata, 0L);
    }

    public static MmappedRegions map(ChannelProxy channel, long length) {
        if (length <= 0L) {
            throw new IllegalArgumentException("Length must be positive");
        }
        return new MmappedRegions(channel, null, length);
    }

    @Override
    public MmappedRegions sharedCopy() {
        return new MmappedRegions(this);
    }

    private boolean isCopy() {
        return this.copy == null;
    }

    public void extend(long length) {
        if (length < 0L) {
            throw new IllegalArgumentException("Length must not be negative");
        }
        assert (!this.isCopy()) : "Copies cannot be extended";
        if (length <= this.state.length) {
            return;
        }
        this.updateState(length);
        this.copy = new State(this.state);
    }

    private void updateState(long length) {
        long size;
        this.state.length = length;
        for (long pos = this.state.getPosition(); pos < length; pos += size) {
            size = Math.min((long)MAX_SEGMENT_SIZE, length - pos);
            this.state.add(pos, size);
        }
    }

    private void updateState(CompressionMetadata metadata) {
        long lastSegmentOffset = 0L;
        long segmentSize = 0L;
        for (long offset = 0L; offset < metadata.dataLength; offset += (long)metadata.chunkLength()) {
            CompressionMetadata.Chunk chunk = metadata.chunkFor(offset);
            if (segmentSize + (long)chunk.length + 4L > (long)MAX_SEGMENT_SIZE && segmentSize > 0L) {
                this.state.add(lastSegmentOffset, segmentSize);
                lastSegmentOffset += segmentSize;
                segmentSize = 0L;
            }
            segmentSize += (long)(chunk.length + 4);
        }
        if (segmentSize > 0L) {
            this.state.add(lastSegmentOffset, segmentSize);
        }
        this.state.length = lastSegmentOffset + segmentSize;
    }

    public boolean isValid(ChannelProxy channel) {
        return this.state.isValid(channel);
    }

    public boolean isEmpty() {
        return this.state.isEmpty();
    }

    public Region floor(long position) {
        assert (!this.isCleanedUp()) : "Attempted to use closed region";
        return this.state.floor(position);
    }

    public void closeQuietly() {
        Throwable err = this.close(null);
        if (err != null) {
            JVMStabilityInspector.inspectThrowable(err);
            LoggerFactory.getLogger(this.getClass()).error("Error while closing mmapped regions", err);
        }
    }

    public static final class Tidier
    implements RefCounted.Tidy {
        final State state;

        Tidier(State state) {
            this.state = state;
        }

        @Override
        public String name() {
            return this.state.channel.filePath();
        }

        @Override
        public void tidy() {
            try {
                Throwables.maybeFail(this.state.close(null));
            }
            catch (Exception e) {
                throw new FSReadError((Throwable)e, this.state.channel.filePath());
            }
        }
    }

    private static final class State {
        private final ChannelProxy channel;
        private ByteBuffer[] buffers;
        private long[] offsets;
        private long length;
        private int last;

        private State(ChannelProxy channel) {
            this.channel = channel.sharedCopy();
            this.buffers = new ByteBuffer[15];
            this.offsets = new long[15];
            this.length = 0L;
            this.last = -1;
        }

        private State(State original) {
            this.channel = original.channel;
            this.buffers = original.buffers;
            this.offsets = original.offsets;
            this.length = original.length;
            this.last = original.last;
        }

        private boolean isEmpty() {
            return this.last < 0;
        }

        private boolean isValid(ChannelProxy channel) {
            return this.channel.filePath().equals(channel.filePath());
        }

        private Region floor(long position) {
            assert (0L <= position && position <= this.length) : String.format("%d > %d", position, this.length);
            int idx = Arrays.binarySearch(this.offsets, 0, this.last + 1, position);
            assert (idx != -1) : String.format("Bad position %d for regions %s, last %d in %s", position, Arrays.toString(this.offsets), this.last, this.channel);
            if (idx < 0) {
                idx = -(idx + 2);
            }
            return new Region(this.offsets[idx], this.buffers[idx]);
        }

        private long getPosition() {
            return this.last < 0 ? 0L : this.offsets[this.last] + (long)this.buffers[this.last].capacity();
        }

        private void add(long pos, long size) {
            MappedByteBuffer buffer = this.channel.map(FileChannel.MapMode.READ_ONLY, pos, size);
            ++this.last;
            if (this.last == this.offsets.length) {
                this.offsets = Arrays.copyOf(this.offsets, this.offsets.length + 15);
                this.buffers = Arrays.copyOf(this.buffers, this.buffers.length + 15);
            }
            this.offsets[this.last] = pos;
            this.buffers[this.last] = buffer;
        }

        private Throwable close(Throwable accumulate) {
            accumulate = this.channel.close(accumulate);
            if (!FileUtils.isCleanerAvailable) {
                return accumulate;
            }
            return Throwables.perform(accumulate, this.channel.filePath(), Throwables.FileOpType.READ, Stream.of(this.buffers).map(buffer -> () -> {
                if (buffer != null) {
                    FileUtils.clean(buffer);
                }
            }));
        }
    }

    public static final class Region
    implements Rebufferer.BufferHolder {
        public final long offset;
        public final ByteBuffer buffer;

        public Region(long offset, ByteBuffer buffer) {
            this.offset = offset;
            this.buffer = buffer;
        }

        @Override
        public ByteBuffer buffer() {
            return this.buffer.duplicate();
        }

        @Override
        public long offset() {
            return this.offset;
        }

        public long end() {
            return this.offset + (long)this.buffer.capacity();
        }

        @Override
        public void release() {
        }
    }
}

