/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.net;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Collections;
import java.util.Map;
import org.apache.cassandra.concurrent.Stage;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.monitoring.ApproximateTime;
import org.apache.cassandra.exceptions.RequestFailureReason;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.io.util.DataInputBuffer;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.net.CallbackInfo;
import org.apache.cassandra.net.CompactEndpointSerializationHelper;
import org.apache.cassandra.net.MessagingService;

public class MessageIn<T> {
    public final InetAddress from;
    public final T payload;
    public final Map<String, byte[]> parameters;
    public final MessagingService.Verb verb;
    public final int version;
    public final long constructionTime;

    private MessageIn(InetAddress from, T payload, Map<String, byte[]> parameters, MessagingService.Verb verb, int version, long constructionTime) {
        this.from = from;
        this.payload = payload;
        this.parameters = parameters;
        this.verb = verb;
        this.version = version;
        this.constructionTime = constructionTime;
    }

    public static <T> MessageIn<T> create(InetAddress from, T payload, Map<String, byte[]> parameters, MessagingService.Verb verb, int version, long constructionTime) {
        return new MessageIn<T>(from, payload, parameters, verb, version, constructionTime);
    }

    public static <T> MessageIn<T> create(InetAddress from, T payload, Map<String, byte[]> parameters, MessagingService.Verb verb, int version) {
        return new MessageIn<T>(from, payload, parameters, verb, version, ApproximateTime.currentTimeMillis());
    }

    public static <T2> MessageIn<T2> read(DataInputPlus in, int version, int id) throws IOException {
        return MessageIn.read(in, version, id, ApproximateTime.currentTimeMillis());
    }

    public static <T2> MessageIn<T2> read(DataInputPlus in, int version, int id, long constructionTime) throws IOException {
        ImmutableMap parameters;
        InetAddress from = CompactEndpointSerializationHelper.deserialize(in);
        MessagingService.Verb verb = MessagingService.verbValues[in.readInt()];
        int parameterCount = in.readInt();
        if (parameterCount == 0) {
            parameters = Collections.emptyMap();
        } else {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (int i = 0; i < parameterCount; ++i) {
                String key = in.readUTF();
                byte[] value = new byte[in.readInt()];
                in.readFully(value);
                builder.put((Object)key, (Object)value);
            }
            parameters = builder.build();
        }
        int payloadSize = in.readInt();
        IVersionedSerializer<?> serializer = MessagingService.instance().verbSerializers.get((Object)verb);
        if (serializer instanceof MessagingService.CallbackDeterminedSerializer) {
            CallbackInfo callback = MessagingService.instance().getRegisteredCallback(id);
            if (callback == null) {
                in.skipBytesFully(payloadSize);
                return null;
            }
            serializer = callback.serializer;
        }
        if (payloadSize == 0 || serializer == null) {
            return MessageIn.create(from, null, (Map<String, byte[]>)parameters, verb, version, constructionTime);
        }
        Object payload = serializer.deserialize(in, version);
        return MessageIn.create(from, payload, (Map<String, byte[]>)parameters, verb, version, constructionTime);
    }

    public static long readConstructionTime(InetAddress from, DataInputPlus input, long currentTime) throws IOException {
        int partial = input.readInt();
        long sentConstructionTime = currentTime & 0xFFFFFFFF00000000L | ((long)partial & 0xFFFFFFFFL) << 2 >> 2;
        long elapsed = currentTime - sentConstructionTime;
        if (elapsed > 0L) {
            MessagingService.instance().metrics.addTimeTaken(from, elapsed);
        }
        boolean useSentTime = DatabaseDescriptor.hasCrossNodeTimeout() && elapsed > 0L;
        return useSentTime ? sentConstructionTime : currentTime;
    }

    public long getLifetimeInMS() {
        return ApproximateTime.currentTimeMillis() - this.constructionTime;
    }

    public boolean isCrossNode() {
        return !this.from.equals(DatabaseDescriptor.getBroadcastAddress());
    }

    public Stage getMessageType() {
        return MessagingService.verbStages.get((Object)this.verb);
    }

    public boolean doCallbackOnFailure() {
        return this.parameters.containsKey("CAL_BAC");
    }

    public boolean isFailureResponse() {
        return this.parameters.containsKey("FAIL");
    }

    public boolean containsFailureReason() {
        return this.parameters.containsKey("FAIL_REASON");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RequestFailureReason getFailureReason() {
        if (!this.containsFailureReason()) return RequestFailureReason.UNKNOWN;
        try (DataInputBuffer in = new DataInputBuffer(this.parameters.get("FAIL_REASON"));){
            RequestFailureReason requestFailureReason = RequestFailureReason.fromCode(in.readUnsignedShort());
            return requestFailureReason;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public long getTimeout() {
        return this.verb.getTimeout();
    }

    public long getSlowQueryTimeout() {
        return DatabaseDescriptor.getSlowQueryTimeout();
    }

    public String toString() {
        StringBuilder sbuf = new StringBuilder();
        sbuf.append("FROM:").append(this.from).append(" TYPE:").append((Object)this.getMessageType()).append(" VERB:").append((Object)this.verb);
        return sbuf.toString();
    }
}

