/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.concurrenttrees.radix.node.concrete;

import com.googlecode.concurrenttrees.common.CharSequences;
import com.googlecode.concurrenttrees.radix.node.Node;
import com.googlecode.concurrenttrees.radix.node.NodeFactory;
import com.googlecode.concurrenttrees.radix.node.concrete.chararray.CharArrayNodeDefault;
import com.googlecode.concurrenttrees.radix.node.concrete.chararray.CharArrayNodeLeafNullValue;
import com.googlecode.concurrenttrees.radix.node.concrete.chararray.CharArrayNodeLeafVoidValue;
import com.googlecode.concurrenttrees.radix.node.concrete.chararray.CharArrayNodeLeafWithValue;
import com.googlecode.concurrenttrees.radix.node.concrete.chararray.CharArrayNodeNonLeafNullValue;
import com.googlecode.concurrenttrees.radix.node.concrete.chararray.CharArrayNodeNonLeafVoidValue;
import com.googlecode.concurrenttrees.radix.node.concrete.voidvalue.VoidValue;
import com.googlecode.concurrenttrees.radix.node.util.NodeUtil;
import java.util.List;

public class DefaultCharArrayNodeFactory
implements NodeFactory {
    @Override
    public Node createNode(CharSequence edgeCharacters, Object value, List<Node> childNodes, boolean isRoot) {
        if (edgeCharacters == null) {
            throw new IllegalStateException("The edgeCharacters argument was null");
        }
        if (!isRoot && edgeCharacters.length() == 0) {
            throw new IllegalStateException("Invalid edge characters for non-root node: " + CharSequences.toString(edgeCharacters));
        }
        if (childNodes == null) {
            throw new IllegalStateException("The childNodes argument was null");
        }
        NodeUtil.ensureNoDuplicateEdges(childNodes);
        if (childNodes.isEmpty()) {
            if (value instanceof VoidValue) {
                return new CharArrayNodeLeafVoidValue(edgeCharacters);
            }
            if (value != null) {
                return new CharArrayNodeLeafWithValue(edgeCharacters, value);
            }
            return new CharArrayNodeLeafNullValue(edgeCharacters);
        }
        if (value instanceof VoidValue) {
            return new CharArrayNodeNonLeafVoidValue(edgeCharacters, childNodes);
        }
        if (value == null) {
            return new CharArrayNodeNonLeafNullValue(edgeCharacters, childNodes);
        }
        return new CharArrayNodeDefault(edgeCharacters, value, childNodes);
    }
}

