/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.concurrenttrees.radix.node.util;

import com.googlecode.concurrenttrees.radix.node.Node;
import com.googlecode.concurrenttrees.radix.node.util.AtomicReferenceArrayListAdapter;
import com.googlecode.concurrenttrees.radix.node.util.NodeCharacterComparator;
import com.googlecode.concurrenttrees.radix.node.util.NodeCharacterKey;
import com.googlecode.concurrenttrees.radix.node.util.NodeCharacterProvider;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicReferenceArray;

public class NodeUtil {
    private static final Comparator<NodeCharacterProvider> NODE_COMPARATOR = new NodeCharacterComparator();

    NodeUtil() {
    }

    public static int binarySearchForEdge(AtomicReferenceArray<Node> childNodes, Character edgeFirstCharacter) {
        AtomicReferenceArrayListAdapter<Node> childNodesList = new AtomicReferenceArrayListAdapter<Node>(childNodes);
        NodeCharacterKey searchKey = new NodeCharacterKey(edgeFirstCharacter);
        return Collections.binarySearch(childNodesList, searchKey, NODE_COMPARATOR);
    }

    public static void ensureNoDuplicateEdges(List<Node> nodes) {
        HashSet<Character> uniqueChars = new HashSet<Character>(nodes.size());
        for (Node node : nodes) {
            uniqueChars.add(node.getIncomingEdgeFirstCharacter());
        }
        if (nodes.size() != uniqueChars.size()) {
            throw new IllegalStateException("Duplicate edge detected in list of nodes supplied: " + nodes);
        }
    }
}

