/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.stress.settings;

import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.stress.generate.DistributionFactory;
import org.apache.cassandra.stress.generate.PartitionGenerator;
import org.apache.cassandra.stress.settings.GroupedOptions;
import org.apache.cassandra.stress.settings.Option;
import org.apache.cassandra.stress.settings.OptionDistribution;
import org.apache.cassandra.stress.settings.OptionSimple;
import org.apache.cassandra.stress.settings.SettingsCommand;
import org.apache.cassandra.stress.settings.SettingsCommandUser;
import org.apache.cassandra.stress.util.ResultLogger;

public class SettingsPopulation
implements Serializable {
    public final DistributionFactory distribution;
    public final DistributionFactory readlookback;
    public final PartitionGenerator.Order order;
    public final boolean wrap;
    public final long[] sequence;

    private SettingsPopulation(GenerateOptions options, DistributionOptions dist, SequentialOptions pop) {
        PartitionGenerator.Order order = this.order = !options.contents.setByUser() ? PartitionGenerator.Order.ARBITRARY : PartitionGenerator.Order.valueOf(options.contents.value().toUpperCase());
        if (dist != null) {
            this.distribution = dist.seed.get();
            this.sequence = null;
            this.readlookback = null;
            this.wrap = false;
        } else {
            this.distribution = null;
            String[] bounds = pop.populate.value().split("\\.\\.+");
            this.sequence = new long[]{OptionDistribution.parseLong(bounds[0]), OptionDistribution.parseLong(bounds[1])};
            this.readlookback = pop.lookback.get();
            this.wrap = !pop.nowrap.setByUser();
        }
    }

    public SettingsPopulation(DistributionOptions options) {
        this(options, options, null);
    }

    public SettingsPopulation(SequentialOptions options) {
        this(options, null, options);
    }

    public void printSettings(ResultLogger out) {
        if (this.distribution != null) {
            out.println("  Distribution: " + this.distribution.getConfigAsString());
        }
        if (this.sequence != null) {
            out.printf("  Sequence: %d..%d%n", this.sequence[0], this.sequence[1]);
        }
        if (this.readlookback != null) {
            out.println("  Read Look Back: " + this.readlookback.getConfigAsString());
        }
        out.printf("  Order: %s%n", new Object[]{this.order});
        out.printf("  Wrap: %b%n", this.wrap);
    }

    public static SettingsPopulation get(Map<String, String[]> clArgs, SettingsCommand command) {
        String defaultLimit = command.count <= 0L ? "1000000" : Long.toString(command.count);
        String[] params = clArgs.remove("-pop");
        if (params == null) {
            if (command instanceof SettingsCommandUser && ((SettingsCommandUser)command).hasInsertOnly()) {
                return new SettingsPopulation(new SequentialOptions(defaultLimit));
            }
            switch (command.type) {
                case WRITE: 
                case COUNTER_WRITE: {
                    return new SettingsPopulation(new SequentialOptions(defaultLimit));
                }
            }
            return new SettingsPopulation(new DistributionOptions(defaultLimit));
        }
        GroupedOptions options = GroupedOptions.select((String[])params, (GroupedOptions[])new GenerateOptions[]{new SequentialOptions(defaultLimit), new DistributionOptions(defaultLimit)});
        if (options == null) {
            SettingsPopulation.printHelp();
            System.out.println("Invalid -pop options provided, see output for valid options");
            System.exit(1);
        }
        return options instanceof SequentialOptions ? new SettingsPopulation((SequentialOptions)options) : new SettingsPopulation((DistributionOptions)options);
    }

    public static void printHelp() {
        GroupedOptions.printOptions(System.out, "-pop", new SequentialOptions("N"), new DistributionOptions("N"));
    }

    public static Runnable helpPrinter() {
        return new Runnable(){

            @Override
            public void run() {
                SettingsPopulation.printHelp();
            }
        };
    }

    private static final class SequentialOptions
    extends GenerateOptions {
        final OptionSimple populate;
        final OptionDistribution lookback = new OptionDistribution("read-lookback=", null, "Select read seeds from the recently visited write seeds", false);
        final OptionSimple nowrap = new OptionSimple("no-wrap", "", null, "Terminate the stress test once all seeds in the range have been visited", false);

        public SequentialOptions(String defaultLimit) {
            this.populate = new OptionSimple("seq=", "[0-9]+[MBK]?\\.\\.+[0-9]+[MBK]?", "1.." + defaultLimit, "Generate all seeds in sequence", true);
        }

        @Override
        public List<? extends Option> options() {
            return ImmutableList.builder().add((Object[])new Option[]{this.populate, this.nowrap, this.lookback}).addAll(super.options()).build();
        }
    }

    private static final class DistributionOptions
    extends GenerateOptions {
        final OptionDistribution seed;

        public DistributionOptions(String defaultLimit) {
            this.seed = new OptionDistribution("dist=", "gaussian(1.." + defaultLimit + ")", "Seeds are selected from this distribution");
        }

        @Override
        public List<? extends Option> options() {
            return ImmutableList.builder().add((Object)this.seed).addAll(super.options()).build();
        }
    }

    private static class GenerateOptions
    extends GroupedOptions {
        final OptionSimple contents = new OptionSimple("contents=", "(sorted|shuffled)", null, "SORTED or SHUFFLED (intra-)partition order; if not specified, will be consistent but arbitrary order", false);

        private GenerateOptions() {
        }

        @Override
        public List<? extends Option> options() {
            return Arrays.asList(this.contents);
        }
    }

    public static enum GenerateOrder {
        ARBITRARY,
        SHUFFLED,
        SORTED;

    }
}

