/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.prefix.tree;

import com.google.common.geometry.S2CellId;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.spatial.prefix.tree.Cell;
import org.apache.lucene.spatial.prefix.tree.CellCanPrune;
import org.apache.lucene.spatial.prefix.tree.CellIterator;
import org.apache.lucene.spatial.prefix.tree.FilterCellIterator;
import org.apache.lucene.spatial.prefix.tree.S2PrefixTree;
import org.apache.lucene.util.BytesRef;
import org.locationtech.spatial4j.shape.Shape;
import org.locationtech.spatial4j.shape.SpatialRelation;

class S2PrefixTreeCell
implements CellCanPrune {
    private static S2CellId[] FACES = new S2CellId[6];
    private static final byte LEAF = 43;
    private static final byte[] TOKENS;
    private static final Map<Byte, Integer> PIXELS;
    S2CellId cellId;
    int level;
    S2PrefixTree tree;
    SpatialRelation shapeRel = null;
    boolean isLeaf;
    Shape shape = null;

    S2PrefixTreeCell(S2PrefixTree tree, S2CellId cellId) {
        this.cellId = cellId;
        this.tree = tree;
        this.setLevel();
        if (this.getLevel() == tree.getMaxLevels()) {
            this.setLeaf();
        }
    }

    void readCell(S2PrefixTree tree, BytesRef ref) {
        this.isLeaf = false;
        this.shape = null;
        this.shapeRel = null;
        this.tree = tree;
        this.cellId = this.getS2CellIdFromBytesRef(ref);
        this.setLevel();
        if (this.isLeaf(ref) || this.getLevel() == tree.getMaxLevels()) {
            this.setLeaf();
        }
    }

    @Override
    public SpatialRelation getShapeRel() {
        return this.shapeRel;
    }

    @Override
    public void setShapeRel(SpatialRelation rel) {
        this.shapeRel = rel;
    }

    @Override
    public boolean isLeaf() {
        return this.isLeaf;
    }

    @Override
    public void setLeaf() {
        this.isLeaf = true;
    }

    @Override
    public BytesRef getTokenBytesWithLeaf(BytesRef result) {
        result = this.getTokenBytesNoLeaf(result);
        if (this.isLeaf() && this.getLevel() != this.tree.getMaxLevels()) {
            result.bytes[result.offset + result.length] = 43;
            ++result.length;
        }
        return result;
    }

    @Override
    public BytesRef getTokenBytesNoLeaf(BytesRef result) {
        if (result == null) {
            result = new BytesRef();
        }
        this.getBytesRefFromS2CellId(this.cellId, result);
        return result;
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    private void setLevel() {
        if (this.cellId == null) {
            this.level = 0;
        } else {
            assert (this.cellId.level() % this.tree.arity == 0);
            this.level = this.cellId.level() / this.tree.arity + 1;
        }
    }

    @Override
    public CellIterator getNextLevelCells(Shape shapeFilter) {
        S2CellId[] children;
        if (this.cellId == null) {
            children = FACES;
        } else {
            int nChildren = (int)Math.pow(4.0, this.tree.arity);
            children = new S2CellId[nChildren];
            children[0] = this.cellId.childBegin(this.cellId.level() + this.tree.arity);
            for (int i = 1; i < nChildren; ++i) {
                children[i] = children[i - 1].next();
            }
        }
        ArrayList<S2PrefixTreeCell> cells = new ArrayList<S2PrefixTreeCell>(children.length);
        for (S2CellId pixel : children) {
            cells.add(new S2PrefixTreeCell(this.tree, pixel));
        }
        return new FilterCellIterator(cells.iterator(), shapeFilter);
    }

    @Override
    public Shape getShape() {
        if (this.shape == null) {
            this.shape = this.cellId == null ? this.tree.getSpatialContext().getWorldBounds() : this.tree.s2ShapeFactory.getS2CellShape(this.cellId);
        }
        return this.shape;
    }

    @Override
    public boolean isPrefixOf(Cell c) {
        if (this.cellId == null) {
            return true;
        }
        S2PrefixTreeCell cell = (S2PrefixTreeCell)c;
        return this.cellId.contains(cell.cellId);
    }

    @Override
    public int compareToNoLeaf(Cell fromCell) {
        if (this.cellId == null) {
            return 1;
        }
        S2PrefixTreeCell cell = (S2PrefixTreeCell)fromCell;
        return this.cellId.compareTo(cell.cellId);
    }

    private boolean isLeaf(BytesRef ref) {
        return ref.bytes[ref.offset + ref.length - 1] == 43;
    }

    private S2CellId getS2CellIdFromBytesRef(BytesRef ref) {
        int length = ref.length;
        if (this.isLeaf(ref)) {
            --length;
        }
        if (length == 0) {
            return null;
        }
        int face = PIXELS.get(ref.bytes[ref.offset]);
        S2CellId cellId = FACES[face];
        long id = cellId.id();
        for (int i = ref.offset + 1; i < ref.offset + length; ++i) {
            int thisLevel = i - ref.offset;
            int pos = PIXELS.get(ref.bytes[i]);
            id = id - (id & -id) + (1L << 2 * (30 - thisLevel * this.tree.arity));
            id += (long)pos * ((id & -id) << 1);
        }
        return new S2CellId(id);
    }

    private void getBytesRefFromS2CellId(S2CellId cellId, BytesRef bref) {
        if (cellId == null) {
            bref.length = 0;
            return;
        }
        int length = this.getLevel() + 1;
        byte[] b = bref.bytes.length >= length ? bref.bytes : new byte[length];
        b[0] = TOKENS[cellId.face()];
        for (int i = 1; i < this.getLevel(); ++i) {
            int offset = 0;
            int level = this.tree.arity * i;
            for (int j = 1; j < this.tree.arity; ++j) {
                offset = 4 * offset + cellId.childPosition(level - this.tree.arity + j);
            }
            b[i] = TOKENS[4 * offset + cellId.childPosition(level)];
        }
        bref.bytes = b;
        bref.length = this.getLevel();
        bref.offset = 0;
    }

    @Override
    public int getSubCellsSize() {
        if (this.cellId == null) {
            return 6;
        }
        return (int)Math.pow(4.0, this.tree.arity);
    }

    public int hashCode() {
        if (this.cellId == null) {
            return super.hashCode();
        }
        return this.cellId.hashCode();
    }

    public boolean equals(Object o) {
        S2PrefixTreeCell cell = (S2PrefixTreeCell)o;
        return Objects.equals(this.cellId, cell.cellId);
    }

    public String toString() {
        if (this.cellId == null) {
            return "0";
        }
        return this.cellId.toString();
    }

    static {
        S2PrefixTreeCell.FACES[0] = S2CellId.fromFacePosLevel((int)0, (long)0L, (int)0);
        S2PrefixTreeCell.FACES[1] = S2CellId.fromFacePosLevel((int)1, (long)0L, (int)0);
        S2PrefixTreeCell.FACES[2] = S2CellId.fromFacePosLevel((int)2, (long)0L, (int)0);
        S2PrefixTreeCell.FACES[3] = S2CellId.fromFacePosLevel((int)3, (long)0L, (int)0);
        S2PrefixTreeCell.FACES[4] = S2CellId.fromFacePosLevel((int)4, (long)0L, (int)0);
        S2PrefixTreeCell.FACES[5] = S2CellId.fromFacePosLevel((int)5, (long)0L, (int)0);
        TOKENS = new byte[]{46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122};
        PIXELS = new HashMap<Byte, Integer>(TOKENS.length);
        for (int i = 0; i < TOKENS.length; ++i) {
            PIXELS.put(TOKENS[i], i);
        }
    }
}

