/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.tools;

import java.io.File;
import java.io.IOException;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.fdf.FDFDocument;
import org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;

public class ExportFDF {
    public static void main(String[] args) throws IOException {
        System.setProperty("apple.awt.UIElement", "true");
        ExportFDF exporter = new ExportFDF();
        exporter.exportFDF(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportFDF(String[] args) throws IOException {
        FDFDocument fdf;
        PDDocument pdf;
        block7: {
            pdf = null;
            fdf = null;
            try {
                if (args.length != 1 && args.length != 2) {
                    ExportFDF.usage();
                    break block7;
                }
                pdf = PDDocument.load((File)new File(args[0]));
                PDAcroForm form = pdf.getDocumentCatalog().getAcroForm();
                if (form == null) {
                    System.err.println("Error: This PDF does not contain a form.");
                    break block7;
                }
                String fdfName = null;
                if (args.length == 2) {
                    fdfName = args[1];
                } else if (args[0].length() > 4) {
                    fdfName = args[0].substring(0, args[0].length() - 4) + ".fdf";
                }
                fdf = form.exportFDF();
                fdf.save(fdfName);
            }
            catch (Throwable throwable) {
                this.close(fdf);
                this.close(pdf);
                throw throwable;
            }
        }
        this.close(fdf);
        this.close(pdf);
    }

    private static void usage() {
        String message = "Usage: org.apache.pdfbox.ExportFDF <inputfile> [output-fdf-file]\n\nOptions:\n  [output-fdf-file] : Default is pdf name, test.pdf->test.fdf";
        System.err.println(message);
        System.exit(1);
    }

    public void close(FDFDocument doc) throws IOException {
        if (doc != null) {
            doc.close();
        }
    }

    public void close(PDDocument doc) throws IOException {
        if (doc != null) {
            doc.close();
        }
    }
}

