/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.mov;

import com.drew.lang.Rational;
import com.drew.lang.annotations.NotNull;
import com.drew.metadata.TagDescriptor;
import com.drew.metadata.mov.QuickTimeDictionary;
import com.drew.metadata.mov.QuickTimeDirectory;
import java.util.ArrayList;
import java.util.Arrays;

public class QuickTimeDescriptor
extends TagDescriptor<QuickTimeDirectory> {
    public QuickTimeDescriptor(@NotNull QuickTimeDirectory directory) {
        super(directory);
    }

    @Override
    public String getDescription(int tagType) {
        switch (tagType) {
            case 4096: {
                return this.getMajorBrandDescription();
            }
            case 4098: {
                return this.getCompatibleBrandsDescription();
            }
            case 260: {
                return this.getDurationDescription();
            }
        }
        return super.getDescription(tagType);
    }

    private String getMajorBrandDescription() {
        byte[] value = ((QuickTimeDirectory)this._directory).getByteArray(4096);
        if (value == null) {
            return null;
        }
        return QuickTimeDictionary.lookup(4096, new String(value));
    }

    private String getCompatibleBrandsDescription() {
        String[] values = ((QuickTimeDirectory)this._directory).getStringArray(4098);
        if (values == null) {
            return null;
        }
        ArrayList<String> compatibleBrandsValues = new ArrayList<String>();
        for (String value : values) {
            String compatibleBrandsValue = QuickTimeDictionary.lookup(4096, value);
            compatibleBrandsValues.add(compatibleBrandsValue == null ? value : compatibleBrandsValue);
        }
        return Arrays.toString(compatibleBrandsValues.toArray());
    }

    private String getDurationDescription() {
        Rational duration = ((QuickTimeDirectory)this._directory).getRational(260);
        if (duration == null) {
            return null;
        }
        double value = duration.doubleValue();
        Integer hours = (int)(value / Math.pow(60.0, 2.0));
        Integer minutes = (int)(value / Math.pow(60.0, 1.0) - (double)(hours * 60));
        Integer seconds = (int)Math.ceil(value / Math.pow(60.0, 0.0) - (double)(minutes * 60));
        return String.format("%1$02d:%2$02d:%3$02d", hours, minutes, seconds);
    }
}

