/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ja;

import java.io.IOException;
import java.math.BigDecimal;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.KeywordAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionLengthAttribute;
import org.apache.lucene.util.AttributeSource;

public class JapaneseNumberFilter
extends TokenFilter {
    private final CharTermAttribute termAttr = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
    private final OffsetAttribute offsetAttr = (OffsetAttribute)this.addAttribute(OffsetAttribute.class);
    private final KeywordAttribute keywordAttr = (KeywordAttribute)this.addAttribute(KeywordAttribute.class);
    private final PositionIncrementAttribute posIncrAttr = (PositionIncrementAttribute)this.addAttribute(PositionIncrementAttribute.class);
    private final PositionLengthAttribute posLengthAttr = (PositionLengthAttribute)this.addAttribute(PositionLengthAttribute.class);
    private static char NO_NUMERAL;
    private static char[] numerals;
    private static char[] exponents;
    private AttributeSource.State state;
    private StringBuilder numeral;
    private int fallThroughTokens;
    private boolean exhausted = false;

    public JapaneseNumberFilter(TokenStream input) {
        super(input);
    }

    public final boolean incrementToken() throws IOException {
        if (this.state != null) {
            this.restoreState(this.state);
            this.state = null;
            return true;
        }
        if (this.exhausted) {
            return false;
        }
        if (!this.input.incrementToken()) {
            this.exhausted = true;
            return false;
        }
        if (this.keywordAttr.isKeyword()) {
            return true;
        }
        if (this.fallThroughTokens > 0) {
            --this.fallThroughTokens;
            return true;
        }
        if (this.posIncrAttr.getPositionIncrement() == 0) {
            this.fallThroughTokens = this.posLengthAttr.getPositionLength() - 1;
            return true;
        }
        boolean moreTokens = true;
        boolean composedNumberToken = false;
        int startOffset = 0;
        int endOffset = 0;
        AttributeSource.State preCompositionState = this.captureState();
        String term = this.termAttr.toString();
        boolean numeralTerm = this.isNumeral(term);
        while (moreTokens && numeralTerm) {
            if (!composedNumberToken) {
                startOffset = this.offsetAttr.startOffset();
                composedNumberToken = true;
            }
            endOffset = this.offsetAttr.endOffset();
            moreTokens = this.input.incrementToken();
            if (!moreTokens) {
                this.exhausted = true;
            }
            if (this.posIncrAttr.getPositionIncrement() == 0) {
                this.fallThroughTokens = this.posLengthAttr.getPositionLength() - 1;
                this.state = this.captureState();
                this.restoreState(preCompositionState);
                return moreTokens;
            }
            this.numeral.append(term);
            if (!moreTokens) continue;
            term = this.termAttr.toString();
            numeralTerm = this.isNumeral(term) || this.isNumeralPunctuation(term);
        }
        if (composedNumberToken) {
            if (moreTokens) {
                this.state = this.captureState();
            }
            String normalizedNumber = this.normalizeNumber(this.numeral.toString());
            this.termAttr.setEmpty();
            this.termAttr.append(normalizedNumber);
            this.offsetAttr.setOffset(startOffset, endOffset);
            this.numeral = new StringBuilder();
            return true;
        }
        return moreTokens;
    }

    public void reset() throws IOException {
        super.reset();
        this.fallThroughTokens = 0;
        this.numeral = new StringBuilder();
        this.state = null;
        this.exhausted = false;
    }

    public String normalizeNumber(String number) {
        try {
            BigDecimal normalizedNumber = this.parseNumber(new NumberBuffer(number));
            if (normalizedNumber == null) {
                return number;
            }
            return normalizedNumber.stripTrailingZeros().toPlainString();
        }
        catch (ArithmeticException | NumberFormatException e) {
            return number;
        }
    }

    private BigDecimal parseNumber(NumberBuffer buffer) {
        BigDecimal sum = BigDecimal.ZERO;
        BigDecimal result = this.parseLargePair(buffer);
        if (result == null) {
            return null;
        }
        while (result != null) {
            sum = sum.add(result);
            result = this.parseLargePair(buffer);
        }
        return sum;
    }

    private BigDecimal parseLargePair(NumberBuffer buffer) {
        BigDecimal first = this.parseMediumNumber(buffer);
        BigDecimal second = this.parseLargeKanjiNumeral(buffer);
        if (first == null && second == null) {
            return null;
        }
        if (second == null) {
            return first;
        }
        if (first == null) {
            return second;
        }
        return first.multiply(second);
    }

    private BigDecimal parseMediumNumber(NumberBuffer buffer) {
        BigDecimal sum = BigDecimal.ZERO;
        BigDecimal result = this.parseMediumPair(buffer);
        if (result == null) {
            return null;
        }
        while (result != null) {
            sum = sum.add(result);
            result = this.parseMediumPair(buffer);
        }
        return sum;
    }

    private BigDecimal parseMediumPair(NumberBuffer buffer) {
        BigDecimal first = this.parseBasicNumber(buffer);
        BigDecimal second = this.parseMediumKanjiNumeral(buffer);
        if (first == null && second == null) {
            return null;
        }
        if (second == null) {
            return first;
        }
        if (first == null) {
            return second;
        }
        return first.multiply(second);
    }

    private BigDecimal parseBasicNumber(NumberBuffer buffer) {
        StringBuilder builder = new StringBuilder();
        for (int i = buffer.position(); i < buffer.length(); ++i) {
            char c = buffer.charAt(i);
            if (this.isArabicNumeral(c)) {
                builder.append(this.arabicNumeralValue(c));
            } else if (this.isKanjiNumeral(c)) {
                builder.append(this.kanjiNumeralValue(c));
            } else if (this.isDecimalPoint(c)) {
                builder.append(".");
            } else if (!this.isThousandSeparator(c)) break;
            buffer.advance();
        }
        if (builder.length() == 0) {
            return null;
        }
        return new BigDecimal(builder.toString());
    }

    public BigDecimal parseLargeKanjiNumeral(NumberBuffer buffer) {
        int i = buffer.position();
        if (i >= buffer.length()) {
            return null;
        }
        char c = buffer.charAt(i);
        char power = exponents[c];
        if (power > '\u0003') {
            buffer.advance();
            return BigDecimal.TEN.pow(power);
        }
        return null;
    }

    public BigDecimal parseMediumKanjiNumeral(NumberBuffer buffer) {
        int i = buffer.position();
        if (i >= buffer.length()) {
            return null;
        }
        char c = buffer.charAt(i);
        char power = exponents[c];
        if ('\u0001' <= power && power <= '\u0003') {
            buffer.advance();
            return BigDecimal.TEN.pow(power);
        }
        return null;
    }

    public boolean isNumeral(String input) {
        for (int i = 0; i < input.length(); ++i) {
            if (this.isNumeral(input.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public boolean isNumeral(char c) {
        return this.isArabicNumeral(c) || this.isKanjiNumeral(c) || exponents[c] > '\u0000';
    }

    public boolean isNumeralPunctuation(String input) {
        for (int i = 0; i < input.length(); ++i) {
            if (this.isNumeralPunctuation(input.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public boolean isNumeralPunctuation(char c) {
        return this.isDecimalPoint(c) || this.isThousandSeparator(c);
    }

    public boolean isArabicNumeral(char c) {
        return this.isHalfWidthArabicNumeral(c) || this.isFullWidthArabicNumeral(c);
    }

    private boolean isHalfWidthArabicNumeral(char c) {
        return '0' <= c && c <= '9';
    }

    private boolean isFullWidthArabicNumeral(char c) {
        return '\uff10' <= c && c <= '\uff19';
    }

    private int arabicNumeralValue(char c) {
        int offset = this.isHalfWidthArabicNumeral(c) ? 48 : 65296;
        return c - offset;
    }

    private boolean isKanjiNumeral(char c) {
        return numerals[c] != NO_NUMERAL;
    }

    private int kanjiNumeralValue(char c) {
        return numerals[c];
    }

    private boolean isDecimalPoint(char c) {
        return c == '.' || c == '\uff0e';
    }

    private boolean isThousandSeparator(char c) {
        return c == ',' || c == '\uff0c';
    }

    static {
        int i;
        NO_NUMERAL = (char)65535;
        numerals = new char[65536];
        for (i = 0; i < numerals.length; ++i) {
            JapaneseNumberFilter.numerals[i] = NO_NUMERAL;
        }
        JapaneseNumberFilter.numerals[12295] = '\u0000';
        JapaneseNumberFilter.numerals[19968] = '\u0001';
        JapaneseNumberFilter.numerals[20108] = 2;
        JapaneseNumberFilter.numerals[19977] = 3;
        JapaneseNumberFilter.numerals[22235] = 4;
        JapaneseNumberFilter.numerals[20116] = 5;
        JapaneseNumberFilter.numerals[20845] = 6;
        JapaneseNumberFilter.numerals[19971] = 7;
        JapaneseNumberFilter.numerals[20843] = 8;
        JapaneseNumberFilter.numerals[20061] = 9;
        exponents = new char[65536];
        for (i = 0; i < exponents.length; ++i) {
            JapaneseNumberFilter.exponents[i] = '\u0000';
        }
        JapaneseNumberFilter.exponents[21313] = '\u0001';
        JapaneseNumberFilter.exponents[30334] = 2;
        JapaneseNumberFilter.exponents[21315] = 3;
        JapaneseNumberFilter.exponents[19975] = 4;
        JapaneseNumberFilter.exponents[20740] = 8;
        JapaneseNumberFilter.exponents[20806] = 12;
        JapaneseNumberFilter.exponents[20140] = 16;
        JapaneseNumberFilter.exponents[22419] = 20;
    }

    public static class NumberBuffer {
        private int position;
        private String string;

        public NumberBuffer(String string) {
            this.string = string;
            this.position = 0;
        }

        public char charAt(int index) {
            return this.string.charAt(index);
        }

        public int length() {
            return this.string.length();
        }

        public void advance() {
            ++this.position;
        }

        public int position() {
            return this.position;
        }
    }
}

