/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update.processor;

import java.io.Reader;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import opennlp.tools.langdetect.Language;
import opennlp.tools.langdetect.LanguageDetectorME;
import opennlp.tools.langdetect.LanguageDetectorModel;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.update.processor.DetectedLanguage;
import org.apache.solr.update.processor.LanguageIdentifierUpdateProcessor;
import org.apache.solr.update.processor.SolrInputDocumentReader;
import org.apache.solr.update.processor.UpdateRequestProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenNLPLangDetectUpdateProcessor
extends LanguageIdentifierUpdateProcessor {
    private final LanguageDetectorModel model;
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final Map<String, String> ISO639_MAP = OpenNLPLangDetectUpdateProcessor.make_ISO639_map();

    public OpenNLPLangDetectUpdateProcessor(SolrQueryRequest req, SolrQueryResponse rsp, UpdateRequestProcessor next, LanguageDetectorModel model) {
        super(req, rsp, next);
        this.model = model;
    }

    @Override
    protected List<DetectedLanguage> detectLanguage(Reader solrDocReader) {
        ArrayList<DetectedLanguage> languages = new ArrayList<DetectedLanguage>();
        String content = SolrInputDocumentReader.asString(solrDocReader);
        if (content.length() != 0) {
            Language[] langs;
            LanguageDetectorME ldme = new LanguageDetectorME(this.model);
            for (Language language : langs = ldme.predictLanguages((CharSequence)content)) {
                languages.add(new DetectedLanguage(ISO639_MAP.get(language.getLang()), language.getConfidence()));
            }
        } else {
            log.debug("No input text to detect language from, returning empty list");
        }
        return languages;
    }

    private static Map<String, String> make_ISO639_map() {
        HashMap<String, String> map = new HashMap<String, String>();
        for (String lang : Locale.getISOLanguages()) {
            Locale locale = new Locale(lang);
            map.put(locale.getISO3Language(), locale.getLanguage());
        }
        return map;
    }
}

