/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.plan.volcano;

import java.util.Objects;
import org.apache.calcite.plan.volcano.IterativeRuleQueue;
import org.apache.calcite.plan.volcano.RelSet;
import org.apache.calcite.plan.volcano.RelSubset;
import org.apache.calcite.plan.volcano.RuleDriver;
import org.apache.calcite.plan.volcano.VolcanoPlanner;
import org.apache.calcite.plan.volcano.VolcanoRuleMatch;
import org.apache.calcite.plan.volcano.VolcanoTimeoutException;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.util.trace.CalciteTrace;
import org.slf4j.Logger;

class IterativeRuleDriver
implements RuleDriver {
    private static final Logger LOGGER = CalciteTrace.getPlannerTracer();
    private final VolcanoPlanner planner;
    private final IterativeRuleQueue ruleQueue;

    IterativeRuleDriver(VolcanoPlanner planner) {
        this.planner = planner;
        this.ruleQueue = new IterativeRuleQueue(planner);
    }

    @Override
    public IterativeRuleQueue getRuleQueue() {
        return this.ruleQueue;
    }

    @Override
    public void drive() {
        while (true) {
            LOGGER.debug("PLANNER = {}; COST = {}", (Object)this, (Object)Objects.requireNonNull(this.planner.root, (String)"planner.root").bestCost);
            VolcanoRuleMatch match = this.ruleQueue.popMatch();
            if (match == null) break;
            assert (match.getRule().matches(match));
            try {
                match.onMatch();
            }
            catch (VolcanoTimeoutException e) {
                LOGGER.warn("Volcano planning times out, cancels the subsequent optimization.");
                this.planner.canonize();
                break;
            }
            this.planner.canonize();
        }
    }

    @Override
    public void onProduce(RelNode rel, RelSubset subset) {
    }

    @Override
    public void onSetMerged(RelSet set) {
    }

    @Override
    public void clear() {
        this.ruleQueue.clear();
    }
}

