/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.util.BytesRef;
import org.apache.solr.common.SolrDocumentBase;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.SolrInputField;
import org.apache.solr.schema.CopyField;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;

public class DocumentBuilder {
    static int MIN_LENGTH_TO_MOVE_LAST = Integer.getInteger("solr.docBuilder.minLengthToMoveLast", 4096);

    private static void addField(Document doc, SchemaField field, Object val, boolean forInPlaceUpdate) {
        if (val instanceof IndexableField) {
            if (forInPlaceUpdate) assert (val instanceof NumericDocValuesField) : "Expected in-place update to be done on NDV fields only.";
            doc.add((IndexableField)val);
            return;
        }
        for (IndexableField f : field.getType().createFields(field, val)) {
            if (f == null) continue;
            if (forInPlaceUpdate) {
                if (!(f instanceof NumericDocValuesField)) continue;
                doc.add(f);
                continue;
            }
            doc.add(f);
        }
    }

    private static String getID(SolrInputDocument doc, IndexSchema schema) {
        String id = "";
        SchemaField sf = schema.getUniqueKeyField();
        if (sf != null) {
            id = "[doc=" + doc.getFieldValue(sf.getName()) + "] ";
        }
        return id;
    }

    public static Document toDocument(SolrInputDocument doc, IndexSchema schema) {
        return DocumentBuilder.toDocument(doc, schema, false, true);
    }

    public static Document toDocument(SolrInputDocument doc, IndexSchema schema, boolean forInPlaceUpdate, boolean ignoreNestedDocs) {
        if (!ignoreNestedDocs && doc.hasChildDocuments()) {
            throw DocumentBuilder.unexpectedNestedDocException(schema, forInPlaceUpdate);
        }
        SchemaField uniqueKeyField = schema.getUniqueKeyField();
        String uniqueKeyFieldName = null == uniqueKeyField ? null : uniqueKeyField.getName();
        Document out = new Document();
        HashSet usedFields = Sets.newHashSet();
        for (SolrInputField solrInputField : doc) {
            if (forInPlaceUpdate && (solrInputField.getName().equals(uniqueKeyFieldName) || solrInputField.getName().equals("_root_"))) continue;
            if (solrInputField.getFirstValue() instanceof SolrDocumentBase) {
                if (ignoreNestedDocs) continue;
                throw DocumentBuilder.unexpectedNestedDocException(schema, forInPlaceUpdate);
            }
            String name = solrInputField.getName();
            SchemaField sfield = schema.getFieldOrNull(name);
            boolean used = false;
            if (sfield != null && !sfield.multiValued() && solrInputField.getValueCount() > 1) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "ERROR: " + DocumentBuilder.getID(doc, schema) + "multiple values encountered for non multiValued field " + sfield.getName() + ": " + solrInputField.getValue());
            }
            List<CopyField> copyFields = schema.getCopyFieldsList(name);
            if (copyFields.size() == 0) {
                copyFields = null;
            }
            boolean hasField = false;
            try {
                for (Object v : solrInputField) {
                    if (v == null) continue;
                    hasField = true;
                    if (sfield != null) {
                        used = true;
                        DocumentBuilder.addField(out, sfield, v, forInPlaceUpdate);
                        usedFields.add(sfield.getName());
                    }
                    if (copyFields == null) continue;
                    for (CopyField cf : copyFields) {
                        SchemaField destinationField = cf.getDestination();
                        boolean destHasValues = usedFields.contains(destinationField.getName());
                        if (!destinationField.multiValued() && destHasValues) {
                            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Multiple values encountered for non multiValued copy field " + destinationField.getName() + ": " + v);
                        }
                        used = true;
                        Object val = v;
                        if (val instanceof CharSequence && cf.getMaxChars() > 0) {
                            val = cf.getLimitedValue(val.toString());
                        }
                        DocumentBuilder.addField(out, destinationField, val, destinationField.getName().equals(uniqueKeyFieldName) ? false : forInPlaceUpdate);
                        usedFields.add(destinationField.getName());
                    }
                }
            }
            catch (SolrException ex) {
                throw new SolrException(SolrException.ErrorCode.getErrorCode((int)ex.code()), "ERROR: " + DocumentBuilder.getID(doc, schema) + "Error adding field '" + solrInputField.getName() + "'='" + solrInputField.getValue() + "' msg=" + ex.getMessage(), (Throwable)ex);
            }
            catch (Exception ex) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "ERROR: " + DocumentBuilder.getID(doc, schema) + "Error adding field '" + solrInputField.getName() + "'='" + solrInputField.getValue() + "' msg=" + ex.getMessage(), (Throwable)ex);
            }
            if (used || !hasField) continue;
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "ERROR: " + DocumentBuilder.getID(doc, schema) + "unknown field '" + name + "'");
        }
        if (!forInPlaceUpdate) {
            for (SchemaField schemaField : schema.getRequiredFields()) {
                if (out.getField(schemaField.getName()) != null) continue;
                if (schemaField.getDefaultValue() != null) {
                    DocumentBuilder.addField(out, schemaField, schemaField.getDefaultValue(), false);
                    continue;
                }
                String msg = DocumentBuilder.getID(doc, schema) + "missing required field: " + schemaField.getName();
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, msg);
            }
        }
        if (!forInPlaceUpdate) {
            DocumentBuilder.moveLargestFieldLast(out);
        }
        return out;
    }

    private static SolrException unexpectedNestedDocException(IndexSchema schema, boolean forInPlaceUpdate) {
        if (!schema.isUsableForChildDocs()) {
            return new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unable to index docs with children: the schema must include definitions for both a uniqueKey field and the '_root_' field, using the exact same fieldType");
        }
        if (forInPlaceUpdate) {
            return new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unable to index docs with children: for an in-place update, just provide the doc by itself");
        }
        return new SolrException(SolrException.ErrorCode.SERVER_ERROR, "A document unexpectedly contained nested child documents");
    }

    private static void moveLargestFieldLast(Document doc) {
        String largestField = null;
        int largestFieldLen = -1;
        boolean largestIsLast = true;
        for (IndexableField field : doc) {
            if (!field.fieldType().stored()) continue;
            if (largestIsLast && !field.name().equals(largestField)) {
                largestIsLast = false;
            }
            if (field.numericValue() != null) continue;
            String strVal = field.stringValue();
            if (strVal != null) {
                if (strVal.length() <= largestFieldLen) continue;
                largestField = field.name();
                largestFieldLen = strVal.length();
                largestIsLast = true;
                continue;
            }
            BytesRef bytesRef = field.binaryValue();
            if (bytesRef == null || bytesRef.length <= largestFieldLen) continue;
            largestField = field.name();
            largestFieldLen = bytesRef.length;
            largestIsLast = true;
        }
        if (!largestIsLast && largestField != null && largestFieldLen > MIN_LENGTH_TO_MOVE_LAST) {
            LinkedList<IndexableField> addToEnd = new LinkedList<IndexableField>();
            Iterator iterator = doc.iterator();
            while (iterator.hasNext()) {
                IndexableField field = (IndexableField)iterator.next();
                if (!field.name().equals(largestField)) continue;
                addToEnd.add(field);
                iterator.remove();
            }
            for (IndexableField field : addToEnd) {
                doc.add(field);
            }
        }
    }
}

