/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.response.json;

import java.util.List;
import java.util.Map;
import org.apache.solr.common.util.NamedList;

public class HeatmapJsonFacet {
    private int gridLevel;
    private int columns;
    private int rows;
    private double minX;
    private double maxX;
    private double minY;
    private double maxY;
    private List<List<Integer>> countGrid;
    private String countEncodedAsBase64PNG;

    public HeatmapJsonFacet(NamedList<Object> heatmapNL) {
        this.gridLevel = (Integer)heatmapNL.get("gridLevel");
        this.columns = (Integer)heatmapNL.get("columns");
        this.rows = (Integer)heatmapNL.get("rows");
        this.minX = (Double)heatmapNL.get("minX");
        this.maxX = (Double)heatmapNL.get("maxX");
        this.minY = (Double)heatmapNL.get("minY");
        this.maxY = (Double)heatmapNL.get("maxY");
        System.out.println("Rows is: " + this.rows);
        System.out.println("Cols is " + this.columns);
        System.out.println("Whole deal is: " + heatmapNL);
        if (heatmapNL.get("counts_ints2D") == null) {
            this.countEncodedAsBase64PNG = (String)heatmapNL.get("counts_png");
        } else {
            this.countGrid = (List)heatmapNL.get("counts_ints2D");
        }
    }

    private int getNumCols(List<List<Integer>> grid) {
        for (List<Integer> row : grid) {
            if (row == null) continue;
            return row.size();
        }
        throw new IllegalStateException("All rows in heatmap grid were null!");
    }

    public List<List<Integer>> getCountGrid() {
        return this.countGrid;
    }

    public String getCountPng() {
        return this.countEncodedAsBase64PNG;
    }

    public int getGridLevel() {
        return this.gridLevel;
    }

    public int getNumColumns() {
        return this.columns;
    }

    public int getNumRows() {
        return this.rows;
    }

    public double getMinX() {
        return this.minX;
    }

    public double getMaxX() {
        return this.maxX;
    }

    public double getMinY() {
        return this.minY;
    }

    public double getMaxY() {
        return this.maxY;
    }

    public static boolean isHeatmapFacet(NamedList<Object> potentialHeatmapValues) {
        boolean hasGridLevel = false;
        boolean hasColumns = false;
        boolean hasRows = false;
        boolean hasMinX = false;
        boolean hasMaxX = false;
        boolean hasMinY = false;
        boolean hasMaxY = false;
        boolean hasCountGrid = false;
        for (Map.Entry<String, Object> entry : potentialHeatmapValues) {
            String key = entry.getKey();
            if ("gridLevel".equals(key)) {
                hasGridLevel = true;
                continue;
            }
            if ("columns".equals(key)) {
                hasColumns = true;
                continue;
            }
            if ("rows".equals(key)) {
                hasRows = true;
                continue;
            }
            if ("minX".equals(key)) {
                hasMinX = true;
                continue;
            }
            if ("maxX".equals(key)) {
                hasMaxX = true;
                continue;
            }
            if ("minY".equals(key)) {
                hasMinY = true;
                continue;
            }
            if ("maxY".equals(key)) {
                hasMaxY = true;
                continue;
            }
            if (key == null || !key.startsWith("counts_")) continue;
            hasCountGrid = true;
        }
        return potentialHeatmapValues.size() == 8 && hasGridLevel && hasColumns && hasRows && hasMinX && hasMaxX && hasMinY && hasMaxY && hasCountGrid;
    }
}

