/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud.api.collections;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.TreeMap;
import java.util.UUID;
import org.apache.lucene.util.TestUtil;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.request.CollectionAdminRequest;
import org.apache.solr.client.solrj.response.CollectionAdminResponse;
import org.apache.solr.client.solrj.response.RequestStatusState;
import org.apache.solr.cloud.AbstractDistribZkTestBase;
import org.apache.solr.cloud.SolrCloudTestCase;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.ImplicitDocRouter;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.params.SolrParams;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCloudBackupRestoreTestCase
extends SolrCloudTestCase {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected static final int NUM_SHARDS = 2;
    protected static final int NUM_SPLIT_SHARDS = 3;
    protected static final String BACKUPNAME_PREFIX = "mytestbackup";
    int replFactor;
    int numTlogReplicas;
    int numPullReplicas;
    private static long docsSeed;
    protected String testSuffix = "test1";

    @BeforeClass
    public static void createCluster() throws Exception {
        docsSeed = AbstractCloudBackupRestoreTestCase.random().nextLong();
        System.setProperty("solr.allowPaths", "*");
    }

    @AfterClass
    public static void afterClass() throws Exception {
        System.clearProperty("solr.allowPaths");
    }

    public abstract String getCollectionNamePrefix();

    public abstract String getBackupRepoName();

    public abstract String getBackupLocation();

    public String getCollectionName() {
        return this.getCollectionNamePrefix() + "_" + this.testSuffix;
    }

    public void setTestSuffix(String testSuffix) {
        this.testSuffix = testSuffix;
    }

    @Test
    public void test() throws Exception {
        CollectionAdminRequest.Create create;
        this.setTestSuffix("testok");
        boolean isImplicit = AbstractCloudBackupRestoreTestCase.random().nextBoolean();
        boolean doSplitShardOperation = !isImplicit && AbstractCloudBackupRestoreTestCase.random().nextBoolean();
        this.replFactor = TestUtil.nextInt((Random)AbstractCloudBackupRestoreTestCase.random(), (int)1, (int)2);
        this.numTlogReplicas = TestUtil.nextInt((Random)AbstractCloudBackupRestoreTestCase.random(), (int)0, (int)1);
        this.numPullReplicas = TestUtil.nextInt((Random)AbstractCloudBackupRestoreTestCase.random(), (int)0, (int)1);
        int backupReplFactor = this.replFactor + this.numPullReplicas + this.numTlogReplicas;
        CollectionAdminRequest.Create create2 = create = isImplicit ? CollectionAdminRequest.createCollectionWithImplicitRouter((String)this.getCollectionName(), (String)"conf1", (String)"shard1,shard2", (int)this.replFactor, (int)this.numTlogReplicas, (int)this.numPullReplicas) : CollectionAdminRequest.createCollection((String)this.getCollectionName(), (String)"conf1", (Integer)2, (Integer)this.replFactor, (Integer)this.numTlogReplicas, (Integer)this.numPullReplicas);
        if (AbstractCloudBackupRestoreTestCase.random().nextBoolean()) {
            create.setMaxShardsPerNode(Integer.valueOf(-1));
        } else if (doSplitShardOperation) {
            create.setMaxShardsPerNode(Integer.valueOf((int)Math.ceil((double)(3 * backupReplFactor) / (double)cluster.getJettySolrRunners().size())));
        } else if (2 * backupReplFactor > cluster.getJettySolrRunners().size() || AbstractCloudBackupRestoreTestCase.random().nextBoolean()) {
            create.setMaxShardsPerNode(Integer.valueOf((int)Math.ceil((double)(2 * backupReplFactor) / (double)cluster.getJettySolrRunners().size())));
        }
        if (AbstractCloudBackupRestoreTestCase.random().nextBoolean()) {
            create.setAutoAddReplicas(true);
        }
        Properties coreProps = new Properties();
        coreProps.put("customKey", "customValue");
        create.setProperties(coreProps);
        if (isImplicit) {
            create.setRouterField("shard_s");
        } else if (AbstractCloudBackupRestoreTestCase.random().nextBoolean()) {
            create.setRouterField("shard_s");
        }
        CloudSolrClient solrClient = cluster.getSolrClient();
        create.process((SolrClient)solrClient);
        this.indexDocs(this.getCollectionName(), false);
        if (doSplitShardOperation) {
            int prevActiveSliceCount = this.getActiveSliceCount(this.getCollectionName());
            CollectionAdminRequest.SplitShard splitShard = CollectionAdminRequest.splitShard((String)this.getCollectionName());
            splitShard.setShardName("shard1");
            splitShard.process((SolrClient)solrClient);
            int i = 0;
            while (this.getActiveSliceCount(this.getCollectionName()) != prevActiveSliceCount + 1) {
                AbstractCloudBackupRestoreTestCase.assertTrue((i < 30 ? 1 : 0) != 0);
                Thread.sleep(500L);
                ++i;
            }
            solrClient.commit(this.getCollectionName());
        }
        this.testBackupAndRestore(this.getCollectionName(), backupReplFactor);
        this.testConfigBackupOnly("conf1", this.getCollectionName());
        this.testInvalidPath(this.getCollectionName());
    }

    @Test
    public void testRestoreFailure() throws Exception {
        this.setTestSuffix("testfailure");
        this.replFactor = TestUtil.nextInt((Random)AbstractCloudBackupRestoreTestCase.random(), (int)1, (int)2);
        this.numTlogReplicas = TestUtil.nextInt((Random)AbstractCloudBackupRestoreTestCase.random(), (int)0, (int)1);
        this.numPullReplicas = TestUtil.nextInt((Random)AbstractCloudBackupRestoreTestCase.random(), (int)0, (int)1);
        CollectionAdminRequest.Create create = CollectionAdminRequest.createCollection((String)this.getCollectionName(), (String)"conf1", (Integer)2, (Integer)this.replFactor, (Integer)this.numTlogReplicas, (Integer)this.numPullReplicas);
        if (2 * (this.replFactor + this.numTlogReplicas + this.numPullReplicas) > cluster.getJettySolrRunners().size()) {
            create.setMaxShardsPerNode(Integer.valueOf((int)Math.ceil(2 * (this.replFactor + this.numTlogReplicas + this.numPullReplicas) / cluster.getJettySolrRunners().size())));
        }
        CloudSolrClient solrClient = cluster.getSolrClient();
        create.process((SolrClient)solrClient);
        this.indexDocs(this.getCollectionName(), false);
        String backupLocation = this.getBackupLocation();
        String backupName = BACKUPNAME_PREFIX + this.testSuffix;
        DocCollection backupCollection = solrClient.getZkStateReader().getClusterState().getCollection(this.getCollectionName());
        log.info("Triggering Backup command");
        CollectionAdminRequest.Backup backup = CollectionAdminRequest.backupCollection((String)this.getCollectionName(), (String)backupName).setLocation(backupLocation).setIncremental(false).setRepositoryName(this.getBackupRepoName());
        AbstractCloudBackupRestoreTestCase.assertEquals((long)0L, (long)((CollectionAdminResponse)backup.process((SolrClient)solrClient)).getStatus());
        log.info("Triggering Restore command");
        String restoreCollectionName = this.getCollectionName() + "_restored";
        CollectionAdminRequest.Restore restore = CollectionAdminRequest.restoreCollection((String)restoreCollectionName, (String)backupName).setLocation(backupLocation).setRepositoryName(this.getBackupRepoName());
        if (backupCollection.getReplicas().size() > cluster.getJettySolrRunners().size()) {
            restore.setMaxShardsPerNode((int)Math.ceil(backupCollection.getReplicas().size() / cluster.getJettySolrRunners().size()));
        }
        restore.setConfigName("confFaulty");
        AbstractCloudBackupRestoreTestCase.assertEquals((Object)RequestStatusState.FAILED, (Object)restore.processAndWait((SolrClient)solrClient, 30L));
        AbstractCloudBackupRestoreTestCase.assertThat((String)("Failed collection is still in the clusterstate: " + cluster.getSolrClient().getClusterStateProvider().getClusterState().getCollectionOrNull(restoreCollectionName)), (Object)CollectionAdminRequest.listCollections((SolrClient)solrClient), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.hasItem((Object)restoreCollectionName)));
    }

    protected void testConfigBackupOnly(String configName, String collectionName) throws Exception {
    }

    private void testInvalidPath(String collectionName) throws Exception {
        if (this.getBackupLocation() == null) {
            return;
        }
        String backupName = "invalidbackuprequest";
        CloudSolrClient solrClient = cluster.getSolrClient();
        CollectionAdminRequest.ClusterProp req = CollectionAdminRequest.setClusterProperty((String)"location", (String)"/location/does/not/exist");
        AbstractCloudBackupRestoreTestCase.assertEquals((long)0L, (long)((CollectionAdminResponse)req.process((SolrClient)solrClient)).getStatus());
        CollectionAdminRequest.Backup backup = CollectionAdminRequest.backupCollection((String)collectionName, (String)backupName).setIncremental(false).setRepositoryName(this.getBackupRepoName());
        try {
            backup.process((SolrClient)solrClient);
            AbstractCloudBackupRestoreTestCase.fail((String)"This request should have failed since the cluster property value for backup location property is invalid.");
        }
        catch (SolrException ex) {
            AbstractCloudBackupRestoreTestCase.assertEquals((long)SolrException.ErrorCode.SERVER_ERROR.code, (long)ex.code());
        }
        String restoreCollectionName = collectionName + "_invalidrequest";
        CollectionAdminRequest.Restore restore = CollectionAdminRequest.restoreCollection((String)restoreCollectionName, (String)backupName).setRepositoryName(this.getBackupRepoName());
        try {
            restore.process((SolrClient)solrClient);
            AbstractCloudBackupRestoreTestCase.fail((String)"This request should have failed since the cluster property value for backup location property is invalid.");
        }
        catch (SolrException ex) {
            AbstractCloudBackupRestoreTestCase.assertEquals((long)SolrException.ErrorCode.SERVER_ERROR.code, (long)ex.code());
        }
    }

    private int getActiveSliceCount(String collectionName) {
        return cluster.getSolrClient().getZkStateReader().getClusterState().getCollection(collectionName).getActiveSlices().size();
    }

    private int indexDocs(String collectionName, boolean useUUID) throws Exception {
        Random random = new Random(docsSeed);
        int numDocs = random.nextInt(100);
        if (numDocs == 0) {
            log.info("Indexing ZERO test docs");
            return 0;
        }
        ArrayList<SolrInputDocument> docs = new ArrayList<SolrInputDocument>(numDocs);
        for (int i = 0; i < numDocs; ++i) {
            SolrInputDocument doc = new SolrInputDocument(new String[0]);
            doc.addField("id", useUUID ? UUID.randomUUID().toString() : Integer.valueOf(i));
            doc.addField("shard_s", (Object)("shard" + (1 + random.nextInt(2))));
            docs.add(doc);
        }
        CloudSolrClient client = cluster.getSolrClient();
        client.add(collectionName, docs);
        client.commit(collectionName);
        log.info("Indexed {} docs to collection: {}", (Object)numDocs, (Object)collectionName);
        return numDocs;
    }

    private void testBackupAndRestore(String collectionName, int backupReplFactor) throws Exception {
        String backupLocation = this.getBackupLocation();
        String backupName = BACKUPNAME_PREFIX + this.testSuffix;
        CloudSolrClient client = cluster.getSolrClient();
        DocCollection backupCollection = client.getZkStateReader().getClusterState().getCollection(collectionName);
        Map<String, Integer> origShardToDocCount = AbstractCloudBackupRestoreTestCase.getShardToDocCountMap(client, backupCollection);
        assert (!origShardToDocCount.isEmpty());
        log.info("Triggering Backup command");
        CollectionAdminRequest.Backup backup = CollectionAdminRequest.backupCollection((String)collectionName, (String)backupName).setIncremental(false).setLocation(backupLocation).setRepositoryName(this.getBackupRepoName());
        if (AbstractCloudBackupRestoreTestCase.random().nextBoolean()) {
            AbstractCloudBackupRestoreTestCase.assertEquals((long)0L, (long)((CollectionAdminResponse)backup.process((SolrClient)client)).getStatus());
        } else {
            AbstractCloudBackupRestoreTestCase.assertEquals((Object)RequestStatusState.COMPLETED, (Object)backup.processAndWait((SolrClient)client, 30L));
        }
        log.info("Triggering Restore command");
        String restoreCollectionName = collectionName + "_restored";
        boolean sameConfig = AbstractCloudBackupRestoreTestCase.random().nextBoolean();
        int restoreReplcationFactor = this.replFactor;
        int restoreTlogReplicas = this.numTlogReplicas;
        int restorePullReplicas = this.numPullReplicas;
        boolean setExternalReplicationFactor = false;
        if (AbstractCloudBackupRestoreTestCase.random().nextBoolean()) {
            setExternalReplicationFactor = true;
            restoreTlogReplicas = TestUtil.nextInt((Random)AbstractCloudBackupRestoreTestCase.random(), (int)0, (int)1);
            restoreReplcationFactor = TestUtil.nextInt((Random)AbstractCloudBackupRestoreTestCase.random(), (int)1, (int)2);
            restorePullReplicas = TestUtil.nextInt((Random)AbstractCloudBackupRestoreTestCase.random(), (int)0, (int)1);
        }
        int numShards = backupCollection.getActiveSlices().size();
        int restoreReplFactor = restoreReplcationFactor + restoreTlogReplicas + restorePullReplicas;
        boolean isMaxShardsPerNodeExternal = false;
        boolean isMaxShardsUnlimited = false;
        CollectionAdminRequest.Restore restore = CollectionAdminRequest.restoreCollection((String)restoreCollectionName, (String)backupName).setLocation(backupLocation).setRepositoryName(this.getBackupRepoName());
        if (setExternalReplicationFactor) {
            restore.setReplicationFactor(Integer.valueOf(restoreReplcationFactor));
            restore.setTlogReplicas(Integer.valueOf(restoreTlogReplicas));
            restore.setPullReplicas(Integer.valueOf(restorePullReplicas));
        }
        int computeRestoreMaxShardsPerNode = (int)Math.ceil((double)(restoreReplFactor * numShards) / (double)cluster.getJettySolrRunners().size());
        if (restoreReplFactor > backupReplFactor) {
            if (log.isInfoEnabled()) {
                log.info("numShards={} restoreReplFactor={} maxShardsPerNode={} totalNodes={}", new Object[]{numShards, restoreReplFactor, computeRestoreMaxShardsPerNode, cluster.getJettySolrRunners().size()});
            }
            if (AbstractCloudBackupRestoreTestCase.random().nextBoolean()) {
                isMaxShardsUnlimited = true;
                restore.setMaxShardsPerNode(-1);
            } else {
                isMaxShardsPerNodeExternal = true;
                restore.setMaxShardsPerNode(computeRestoreMaxShardsPerNode);
            }
        }
        if (AbstractCloudBackupRestoreTestCase.rarely()) {
            restore.setCreateNodeSet(cluster.getJettySolrRunners().get(0).getNodeName());
            isMaxShardsPerNodeExternal = true;
            computeRestoreMaxShardsPerNode = origShardToDocCount.size() * restoreReplFactor;
            restore.setMaxShardsPerNode(computeRestoreMaxShardsPerNode);
        }
        int restoreMaxShardsPerNode = computeRestoreMaxShardsPerNode;
        Properties props = new Properties();
        props.setProperty("customKey", "customVal");
        restore.setProperties(props);
        if (!sameConfig) {
            restore.setConfigName("customConfigName");
        }
        if (AbstractCloudBackupRestoreTestCase.random().nextBoolean()) {
            AbstractCloudBackupRestoreTestCase.assertEquals((long)0L, (long)((CollectionAdminResponse)restore.process((SolrClient)client)).getStatus());
        } else {
            AbstractCloudBackupRestoreTestCase.assertEquals((Object)RequestStatusState.COMPLETED, (Object)restore.processAndWait((SolrClient)client, 60L));
        }
        AbstractDistribZkTestBase.waitForRecoveriesToFinish(restoreCollectionName, cluster.getSolrClient().getZkStateReader(), log.isDebugEnabled(), true, 30L);
        DocCollection restoreCollection = client.getZkStateReader().getClusterState().getCollection(restoreCollectionName);
        AbstractCloudBackupRestoreTestCase.assertEquals(origShardToDocCount, AbstractCloudBackupRestoreTestCase.getShardToDocCountMap(client, restoreCollection));
        if (!(restoreCollection.getRouter() instanceof ImplicitDocRouter) && AbstractCloudBackupRestoreTestCase.random().nextBoolean()) {
            this.indexDocs(restoreCollectionName, false);
            AbstractCloudBackupRestoreTestCase.assertEquals(origShardToDocCount, AbstractCloudBackupRestoreTestCase.getShardToDocCountMap(client, restoreCollection));
        }
        AbstractCloudBackupRestoreTestCase.assertEquals((Object)backupCollection.getAutoAddReplicas(), (Object)restoreCollection.getAutoAddReplicas());
        AbstractCloudBackupRestoreTestCase.assertEquals((Object)(sameConfig ? "conf1" : "customConfigName"), (Object)cluster.getSolrClient().getZkStateReader().readConfigName(restoreCollectionName));
        HashMap<String, Integer> numReplicasByNodeName = new HashMap<String, Integer>();
        restoreCollection.getReplicas().forEach(x -> numReplicasByNodeName.put(x.getNodeName(), numReplicasByNodeName.getOrDefault(x.getNodeName(), 0) + 1));
        numReplicasByNodeName.forEach((k, v) -> AbstractCloudBackupRestoreTestCase.assertTrue((String)("Node " + k + " has " + v + " replicas. Expected num replicas : " + restoreMaxShardsPerNode + ". state: \n" + restoreCollection), (v <= restoreMaxShardsPerNode ? 1 : 0) != 0));
        AbstractCloudBackupRestoreTestCase.assertEquals((String)restoreCollection.toString(), (long)restoreReplcationFactor, (long)restoreCollection.getReplicationFactor().intValue());
        AbstractCloudBackupRestoreTestCase.assertEquals((String)restoreCollection.toString(), (long)restoreReplcationFactor, (long)restoreCollection.getNumNrtReplicas().intValue());
        AbstractCloudBackupRestoreTestCase.assertEquals((String)restoreCollection.toString(), (long)restorePullReplicas, (long)restoreCollection.getNumPullReplicas().intValue());
        AbstractCloudBackupRestoreTestCase.assertEquals((String)restoreCollection.toString(), (long)restoreTlogReplicas, (long)restoreCollection.getNumTlogReplicas().intValue());
        if (isMaxShardsPerNodeExternal) {
            AbstractCloudBackupRestoreTestCase.assertEquals((String)restoreCollectionName, (long)restoreMaxShardsPerNode, (long)restoreCollection.getMaxShardsPerNode());
        } else if (isMaxShardsUnlimited) {
            AbstractCloudBackupRestoreTestCase.assertEquals((String)restoreCollectionName, (long)-1L, (long)restoreCollection.getMaxShardsPerNode());
        } else {
            AbstractCloudBackupRestoreTestCase.assertEquals((String)restoreCollectionName, (long)backupCollection.getMaxShardsPerNode(), (long)restoreCollection.getMaxShardsPerNode());
        }
        AbstractCloudBackupRestoreTestCase.assertEquals((String)"Restore collection should use stateFormat=2", (long)2L, (long)restoreCollection.getStateFormat());
        Map<String, Integer> restoredCollectionPerShardCount = AbstractCloudBackupRestoreTestCase.getShardToDocCountMap(client, restoreCollection);
        long restoredCollectionDocCount = restoredCollectionPerShardCount.values().stream().mapToInt(Number::intValue).sum();
        int numberNewDocsIndexed = this.indexDocs(restoreCollectionName, true);
        Map<String, Integer> restoredCollectionPerShardCountAfterIndexing = AbstractCloudBackupRestoreTestCase.getShardToDocCountMap(client, restoreCollection);
        int restoredCollectionFinalDocCount = restoredCollectionPerShardCountAfterIndexing.values().stream().mapToInt(Number::intValue).sum();
        log.info("Original doc count in restored collection:{} , number of newly added documents to the restored collection: {}, after indexing: {}", new Object[]{restoredCollectionDocCount, numberNewDocsIndexed, restoredCollectionFinalDocCount});
        AbstractCloudBackupRestoreTestCase.assertEquals((long)(restoredCollectionDocCount + (long)numberNewDocsIndexed), (long)restoredCollectionFinalDocCount);
    }

    public static Map<String, Integer> getShardToDocCountMap(CloudSolrClient client, DocCollection docCollection) throws SolrServerException, IOException {
        TreeMap<String, Integer> shardToDocCount = new TreeMap<String, Integer>();
        for (Slice slice : docCollection.getActiveSlices()) {
            String shardName = slice.getName();
            HttpSolrClient leaderClient = ((HttpSolrClient.Builder)new HttpSolrClient.Builder(slice.getLeader().getCoreUrl()).withHttpClient(client.getHttpClient())).build();
            Throwable throwable = null;
            try {
                long docsInShard = leaderClient.query((SolrParams)new SolrQuery("*:*").setParam("distrib", new String[]{"false"})).getResults().getNumFound();
                shardToDocCount.put(shardName, (int)docsInShard);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (leaderClient == null) continue;
                if (throwable != null) {
                    try {
                        leaderClient.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                leaderClient.close();
            }
        }
        return shardToDocCount;
    }
}

