/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.layout.template.json.util;

import java.io.PrintWriter;
import java.io.Writer;
import java.util.Objects;
import org.apache.logging.log4j.layout.template.json.util.TruncatingBufferedWriter;

public final class TruncatingBufferedPrintWriter
extends PrintWriter
implements CharSequence {
    private final TruncatingBufferedWriter writer;

    private TruncatingBufferedPrintWriter(TruncatingBufferedWriter writer) {
        super((Writer)writer, false);
        this.writer = writer;
    }

    public static TruncatingBufferedPrintWriter ofCapacity(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException("was expecting a non-negative capacity: " + capacity);
        }
        TruncatingBufferedWriter writer = new TruncatingBufferedWriter(capacity);
        return new TruncatingBufferedPrintWriter(writer);
    }

    public char[] buffer() {
        return this.writer.buffer();
    }

    public int position() {
        return this.writer.position();
    }

    public void position(int index) {
        this.writer.position(index);
    }

    public int capacity() {
        return this.writer.capacity();
    }

    public boolean truncated() {
        return this.writer.truncated();
    }

    public int indexOf(CharSequence seq) {
        Objects.requireNonNull(seq, "seq");
        return this.writer.indexOf(seq);
    }

    @Override
    public int length() {
        return this.writer.length();
    }

    @Override
    public char charAt(int index) {
        return this.writer.charAt(index);
    }

    @Override
    public CharSequence subSequence(int startIndex, int endIndex) {
        return this.writer.subSequence(startIndex, endIndex);
    }

    @Override
    public void close() {
        this.writer.close();
    }

    @Override
    public String toString() {
        return this.writer.toString();
    }
}

