/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.cranky;

import java.io.IOException;
import java.util.Random;
import org.apache.lucene.codecs.PointsFormat;
import org.apache.lucene.codecs.PointsReader;
import org.apache.lucene.codecs.PointsWriter;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.MergeState;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;

class CrankyPointsFormat
extends PointsFormat {
    PointsFormat delegate;
    Random random;

    CrankyPointsFormat(PointsFormat delegate, Random random) {
        this.delegate = delegate;
        this.random = random;
    }

    public PointsWriter fieldsWriter(SegmentWriteState state) throws IOException {
        return new CrankyPointsWriter(this.delegate.fieldsWriter(state), this.random);
    }

    public PointsReader fieldsReader(SegmentReadState state) throws IOException {
        return new CrankyPointsReader(this.delegate.fieldsReader(state), this.random);
    }

    static class CrankyPointsReader
    extends PointsReader {
        final PointsReader delegate;
        final Random random;

        public CrankyPointsReader(PointsReader delegate, Random random) {
            this.delegate = delegate;
            this.random = random;
        }

        public void checkIntegrity() throws IOException {
            if (this.random.nextInt(100) == 0) {
                throw new IOException("Fake IOException");
            }
            this.delegate.checkIntegrity();
            if (this.random.nextInt(100) == 0) {
                throw new IOException("Fake IOException");
            }
        }

        public PointValues getValues(String fieldName) throws IOException {
            final PointValues delegate = this.delegate.getValues(fieldName);
            if (delegate == null) {
                return null;
            }
            return new PointValues(){

                public void intersect(PointValues.IntersectVisitor visitor) throws IOException {
                    if (random.nextInt(100) == 0) {
                        throw new IOException("Fake IOException");
                    }
                    delegate.intersect(visitor);
                    if (random.nextInt(100) == 0) {
                        throw new IOException("Fake IOException");
                    }
                }

                public long estimatePointCount(PointValues.IntersectVisitor visitor) {
                    return delegate.estimatePointCount(visitor);
                }

                public byte[] getMinPackedValue() throws IOException {
                    if (random.nextInt(100) == 0) {
                        throw new IOException("Fake IOException");
                    }
                    return delegate.getMinPackedValue();
                }

                public byte[] getMaxPackedValue() throws IOException {
                    if (random.nextInt(100) == 0) {
                        throw new IOException("Fake IOException");
                    }
                    return delegate.getMaxPackedValue();
                }

                public int getNumDimensions() throws IOException {
                    if (random.nextInt(100) == 0) {
                        throw new IOException("Fake IOException");
                    }
                    return delegate.getNumDimensions();
                }

                public int getNumIndexDimensions() throws IOException {
                    if (random.nextInt(100) == 0) {
                        throw new IOException("Fake IOException");
                    }
                    return delegate.getNumIndexDimensions();
                }

                public int getBytesPerDimension() throws IOException {
                    if (random.nextInt(100) == 0) {
                        throw new IOException("Fake IOException");
                    }
                    return delegate.getBytesPerDimension();
                }

                public long size() {
                    return delegate.size();
                }

                public int getDocCount() {
                    return delegate.getDocCount();
                }
            };
        }

        public void close() throws IOException {
            this.delegate.close();
            if (this.random.nextInt(100) == 0) {
                throw new IOException("Fake IOException");
            }
        }

        public long ramBytesUsed() {
            return this.delegate.ramBytesUsed();
        }
    }

    static class CrankyPointsWriter
    extends PointsWriter {
        final PointsWriter delegate;
        final Random random;

        public CrankyPointsWriter(PointsWriter delegate, Random random) {
            this.delegate = delegate;
            this.random = random;
        }

        public void writeField(FieldInfo fieldInfo, PointsReader values) throws IOException {
            if (this.random.nextInt(100) == 0) {
                throw new IOException("Fake IOException");
            }
            this.delegate.writeField(fieldInfo, values);
        }

        public void finish() throws IOException {
            if (this.random.nextInt(100) == 0) {
                throw new IOException("Fake IOException");
            }
            this.delegate.finish();
            if (this.random.nextInt(100) == 0) {
                throw new IOException("Fake IOException");
            }
        }

        public void merge(MergeState mergeState) throws IOException {
            if (this.random.nextInt(100) == 0) {
                throw new IOException("Fake IOException");
            }
            this.delegate.merge(mergeState);
            if (this.random.nextInt(100) == 0) {
                throw new IOException("Fake IOException");
            }
        }

        public void close() throws IOException {
            this.delegate.close();
            if (this.random.nextInt(100) == 0) {
                throw new IOException("Fake IOException");
            }
        }
    }
}

