/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.spans;

import java.io.IOException;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.spans.SpanCollector;
import org.apache.lucene.search.spans.Spans;

class AssertingSpans
extends Spans {
    final Spans in;
    int doc = -1;
    State state = State.DOC_START;

    AssertingSpans(Spans in) {
        this.in = in;
    }

    public int nextStartPosition() throws IOException {
        assert (this.state != State.DOC_START) : "invalid position access, state=" + (Object)((Object)this.state) + ": " + this.in;
        assert (this.state != State.DOC_FINISHED) : "invalid position access, state=" + (Object)((Object)this.state) + ": " + this.in;
        assert (this.state != State.DOC_UNVERIFIED) : "invalid position access, state=" + (Object)((Object)this.state) + ": " + this.in;
        this.checkCurrentPositions();
        int prev = this.in.startPosition();
        int start = this.in.nextStartPosition();
        assert (start >= prev) : "invalid startPosition (positions went backwards, previous=" + prev + "): " + this.in;
        this.state = start == Integer.MAX_VALUE ? State.POS_FINISHED : State.ITERATING;
        this.checkCurrentPositions();
        return start;
    }

    private void checkCurrentPositions() {
        int start = this.in.startPosition();
        int end = this.in.endPosition();
        if (this.state == State.DOC_START || this.state == State.DOC_UNVERIFIED || this.state == State.POS_START) {
            assert (start == -1) : "invalid startPosition (should be -1): " + this.in;
            assert (end == -1) : "invalid endPosition (should be -1): " + this.in;
        } else if (this.state == State.POS_FINISHED) {
            assert (start == Integer.MAX_VALUE) : "invalid startPosition (should be NO_MORE_POSITIONS): " + this.in;
            assert (end == Integer.MAX_VALUE) : "invalid endPosition (should be NO_MORE_POSITIONS): " + this.in;
        } else {
            assert (start >= 0) : "invalid startPosition (negative): " + this.in;
            assert (start <= end) : "invalid startPosition (> endPosition): " + this.in;
        }
    }

    public int startPosition() {
        this.checkCurrentPositions();
        return this.in.startPosition();
    }

    public int endPosition() {
        this.checkCurrentPositions();
        return this.in.endPosition();
    }

    public int width() {
        assert (this.state == State.ITERATING);
        int distance = this.in.width();
        assert (distance >= 0);
        return distance;
    }

    public void collect(SpanCollector collector) throws IOException {
        assert (this.state == State.ITERATING) : "collect() called in illegal state: " + (Object)((Object)this.state) + ": " + this.in;
        this.in.collect(collector);
    }

    public int docID() {
        int doc = this.in.docID();
        assert (doc == this.doc) : "broken docID() impl: docID() = " + doc + ", but next/advance last returned: " + this.doc + ": " + this.in;
        return doc;
    }

    public int nextDoc() throws IOException {
        assert (this.state != State.DOC_FINISHED) : "nextDoc() called after NO_MORE_DOCS: " + this.in;
        int nextDoc = this.in.nextDoc();
        assert (nextDoc > this.doc) : "backwards nextDoc from " + this.doc + " to " + nextDoc + ": " + this.in;
        if (nextDoc == Integer.MAX_VALUE) {
            this.state = State.DOC_FINISHED;
        } else {
            assert (this.in.startPosition() == -1) : "invalid initial startPosition() [should be -1]: " + this.in;
            assert (this.in.endPosition() == -1) : "invalid initial endPosition() [should be -1]: " + this.in;
            this.state = State.POS_START;
        }
        this.doc = nextDoc;
        return this.docID();
    }

    public int advance(int target) throws IOException {
        assert (this.state != State.DOC_FINISHED) : "advance() called after NO_MORE_DOCS: " + this.in;
        assert (target > this.doc) : "target must be > docID(), got " + target + " <= " + this.doc + ": " + this.in;
        int advanced = this.in.advance(target);
        assert (advanced >= target) : "backwards advance from: " + target + " to: " + advanced + ": " + this.in;
        if (advanced == Integer.MAX_VALUE) {
            this.state = State.DOC_FINISHED;
        } else {
            assert (this.in.startPosition() == -1) : "invalid initial startPosition() [should be -1]: " + this.in;
            assert (this.in.endPosition() == -1) : "invalid initial endPosition() [should be -1]: " + this.in;
            this.state = State.POS_START;
        }
        this.doc = advanced;
        return this.docID();
    }

    public String toString() {
        return "Asserting(" + this.in + ")";
    }

    public long cost() {
        return this.in.cost();
    }

    public float positionsCost() {
        float cost = this.in.positionsCost();
        assert (!Float.isNaN(cost)) : "positionsCost() should not be NaN";
        assert (cost > 0.0f) : "positionsCost() must be positive";
        return cost;
    }

    public TwoPhaseIterator asTwoPhaseIterator() {
        TwoPhaseIterator iterator = this.in.asTwoPhaseIterator();
        if (iterator == null) {
            return null;
        }
        return new AssertingTwoPhaseView(iterator);
    }

    class AssertingDISI
    extends DocIdSetIterator {
        final DocIdSetIterator in;

        AssertingDISI(DocIdSetIterator in) {
            this.in = in;
        }

        public int docID() {
            assert (this.in.docID() == AssertingSpans.this.docID());
            return this.in.docID();
        }

        public int nextDoc() throws IOException {
            assert (AssertingSpans.this.state != State.DOC_FINISHED) : "nextDoc() called after NO_MORE_DOCS: " + this.in;
            int nextDoc = this.in.nextDoc();
            assert (nextDoc > AssertingSpans.this.doc) : "backwards nextDoc from " + AssertingSpans.this.doc + " to " + nextDoc + ": " + this.in;
            AssertingSpans.this.state = nextDoc == Integer.MAX_VALUE ? State.DOC_FINISHED : State.DOC_UNVERIFIED;
            AssertingSpans.this.doc = nextDoc;
            return this.docID();
        }

        public int advance(int target) throws IOException {
            assert (AssertingSpans.this.state != State.DOC_FINISHED) : "advance() called after NO_MORE_DOCS: " + this.in;
            assert (target > AssertingSpans.this.doc) : "target must be > docID(), got " + target + " <= " + AssertingSpans.this.doc + ": " + this.in;
            int advanced = this.in.advance(target);
            assert (advanced >= target) : "backwards advance from: " + target + " to: " + advanced + ": " + this.in;
            AssertingSpans.this.state = advanced == Integer.MAX_VALUE ? State.DOC_FINISHED : State.DOC_UNVERIFIED;
            AssertingSpans.this.doc = advanced;
            return this.docID();
        }

        public long cost() {
            return this.in.cost();
        }
    }

    class AssertingTwoPhaseView
    extends TwoPhaseIterator {
        final TwoPhaseIterator in;
        int lastDoc;

        AssertingTwoPhaseView(TwoPhaseIterator iterator) {
            super((DocIdSetIterator)new AssertingDISI(iterator.approximation()));
            this.lastDoc = -1;
            this.in = iterator;
        }

        public boolean matches() throws IOException {
            if (this.approximation.docID() == -1 || this.approximation.docID() == Integer.MAX_VALUE) {
                throw new AssertionError((Object)("matches() should not be called on doc ID " + this.approximation.docID()));
            }
            if (this.lastDoc == this.approximation.docID()) {
                throw new AssertionError((Object)("matches() has been called twice on doc ID " + this.approximation.docID()));
            }
            this.lastDoc = this.approximation.docID();
            boolean v = this.in.matches();
            if (v) {
                AssertingSpans.this.state = State.POS_START;
            }
            return v;
        }

        public float matchCost() {
            float cost = this.in.matchCost();
            if (Float.isNaN(cost)) {
                throw new AssertionError((Object)("matchCost()=" + cost + " should not be NaN on doc ID " + this.approximation.docID()));
            }
            if (cost < 0.0f) {
                throw new AssertionError((Object)("matchCost()=" + cost + " should be non negative on doc ID " + this.approximation.docID()));
            }
            return cost;
        }
    }

    static enum State {
        DOC_START,
        DOC_UNVERIFIED,
        POS_START,
        ITERATING,
        POS_FINISHED,
        DOC_FINISHED;

    }
}

