/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4;

import com.carrotsearch.ant.tasks.junit4.Pluralize;

public class TestsSummary {
    public final int suites;
    public final int ignoredSuites;
    public final int suiteErrors;
    public final int tests;
    public final int failures;
    public final int errors;
    public final int assumptions;
    public final int ignores;

    public TestsSummary(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        this.suites = n;
        this.ignoredSuites = n2;
        this.suiteErrors = n3;
        this.tests = n4;
        this.failures = n5;
        this.errors = n6;
        this.assumptions = n7;
        this.ignores = n8;
    }

    public boolean isSuccessful() {
        return this.errors + this.failures + this.suiteErrors == 0;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.suites).append(Pluralize.pluralize(this.suites, " suite"));
        if (this.ignoredSuites > 0) {
            stringBuilder.append(" (").append(this.ignoredSuites).append(" ignored)");
        }
        stringBuilder.append(", ").append(this.tests).append(Pluralize.pluralize(this.tests, " test"));
        if (this.suiteErrors > 0) {
            stringBuilder.append(", ").append(this.suiteErrors).append(Pluralize.pluralize(this.suiteErrors, " suite-level error"));
        }
        if (this.errors > 0) {
            stringBuilder.append(", ").append(this.errors).append(Pluralize.pluralize(this.errors, " error"));
        }
        if (this.failures > 0) {
            stringBuilder.append(", ").append(this.failures).append(Pluralize.pluralize(this.failures, " failure"));
        }
        if (this.ignores + this.assumptions > 0) {
            stringBuilder.append(", ").append(this.ignores + this.assumptions).append(" ignored");
            if (this.assumptions > 0) {
                stringBuilder.append(" (").append(this.assumptions).append(Pluralize.pluralize(this.assumptions, " assumption")).append(")");
            }
        }
        return stringBuilder.toString();
    }

    public int getNonIgnoredTestsCount() {
        return this.tests - (this.ignores + this.assumptions);
    }
}

