/*
 * Decompiled with CFR 0.152.
 */
package org.gagravarr.ogg.audio;

import org.gagravarr.flac.FlacFirstOggPacket;
import org.gagravarr.flac.FlacTags;
import org.gagravarr.ogg.OggPacket;
import org.gagravarr.ogg.OggStreamAudioData;
import org.gagravarr.ogg.OggStreamIdentifier;
import org.gagravarr.ogg.OggStreamPacket;
import org.gagravarr.ogg.audio.OggAudioHeaders;
import org.gagravarr.ogg.audio.OggAudioInfoHeader;
import org.gagravarr.ogg.audio.OggAudioSetupHeader;
import org.gagravarr.ogg.audio.OggAudioTagsHeader;
import org.gagravarr.opus.OpusInfo;
import org.gagravarr.opus.OpusPacketFactory;
import org.gagravarr.speex.SpeexInfo;
import org.gagravarr.speex.SpeexPacketFactory;
import org.gagravarr.vorbis.VorbisInfo;
import org.gagravarr.vorbis.VorbisPacketFactory;

public class OggAudioStreamHeaders
implements OggAudioHeaders {
    private int sid;
    private OggStreamIdentifier.OggStreamType type;
    private OggAudioInfoHeader info;
    private OggAudioTagsHeader tags;
    private OggAudioSetupHeader setup;

    private OggAudioStreamHeaders(int sid, OggStreamIdentifier.OggStreamType type, OggAudioInfoHeader info) {
        this.sid = sid;
        this.type = type;
        this.info = info;
    }

    public static OggAudioStreamHeaders create(OggPacket firstPacket) {
        if (firstPacket.isBeginningOfStream() && firstPacket.getData() != null && firstPacket.getData().length > 10) {
            int sid = firstPacket.getSid();
            if (VorbisPacketFactory.isVorbisStream(firstPacket)) {
                return new OggAudioStreamHeaders(sid, OggStreamIdentifier.OGG_VORBIS, (VorbisInfo)VorbisPacketFactory.create(firstPacket));
            }
            if (SpeexPacketFactory.isSpeexStream(firstPacket)) {
                return new OggAudioStreamHeaders(sid, OggStreamIdentifier.SPEEX_AUDIO, (SpeexInfo)SpeexPacketFactory.create(firstPacket));
            }
            if (OpusPacketFactory.isOpusStream(firstPacket)) {
                return new OggAudioStreamHeaders(sid, OggStreamIdentifier.OPUS_AUDIO, (OpusInfo)OpusPacketFactory.create(firstPacket));
            }
            if (FlacFirstOggPacket.isFlacStream(firstPacket)) {
                FlacFirstOggPacket flac = new FlacFirstOggPacket(firstPacket);
                return new OggAudioStreamHeaders(sid, OggStreamIdentifier.OGG_FLAC, flac.getInfo());
            }
            throw new IllegalArgumentException("Unsupported stream of type " + OggStreamIdentifier.identifyType(firstPacket));
        }
        throw new IllegalArgumentException("May only be called for the first packet in a stream, with data");
    }

    protected OggStreamPacket createNext(OggPacket packet) {
        if (this.type == OggStreamIdentifier.OGG_VORBIS) {
            return VorbisPacketFactory.create(packet);
        }
        if (this.type == OggStreamIdentifier.SPEEX_AUDIO) {
            return SpeexPacketFactory.create(packet);
        }
        if (this.type == OggStreamIdentifier.OPUS_AUDIO) {
            return OpusPacketFactory.create(packet);
        }
        if (this.type == OggStreamIdentifier.OGG_FLAC) {
            return null;
        }
        throw new IllegalArgumentException("Unsupported stream of type " + this.type);
    }

    public boolean populate(OggPacket packet) {
        if (this.type == OggStreamIdentifier.OGG_FLAC) {
            if (this.tags == null) {
                this.tags = new FlacTags(packet);
                return true;
            }
            return false;
        }
        OggStreamPacket sPacket = this.createNext(packet);
        if (sPacket instanceof OggAudioTagsHeader) {
            this.tags = (OggAudioTagsHeader)sPacket;
            return this.type == OggStreamIdentifier.OGG_VORBIS;
        }
        if (sPacket instanceof OggAudioSetupHeader) {
            this.setup = (OggAudioSetupHeader)sPacket;
            return false;
        }
        throw new IllegalArgumentException("Expecting header packet but got " + sPacket);
    }

    public OggStreamAudioData createAudio(OggPacket packet) {
        return (OggStreamAudioData)this.createNext(packet);
    }

    public int getSid() {
        return this.sid;
    }

    public OggStreamIdentifier.OggStreamType getType() {
        return this.type;
    }

    public OggAudioInfoHeader getInfo() {
        return this.info;
    }

    public OggAudioTagsHeader getTags() {
        return this.tags;
    }

    public OggAudioSetupHeader getSetup() {
        return this.setup;
    }
}

