/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.function.field;

import java.io.IOException;
import java.util.function.Consumer;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.util.BytesRef;
import org.apache.solr.analytics.facet.compare.ExpressionComparator;
import org.apache.solr.analytics.function.field.AnalyticsField;
import org.apache.solr.analytics.util.function.BooleanConsumer;
import org.apache.solr.analytics.value.BooleanValue;

public class BooleanField
extends AnalyticsField
implements BooleanValue.CastingBooleanValue {
    private SortedDocValues docValues;
    boolean value;
    boolean exists;
    int trueOrd;

    public BooleanField(String fieldName) {
        super(fieldName);
    }

    @Override
    public void doSetNextReader(LeafReaderContext context) throws IOException {
        this.docValues = DocValues.getSorted((LeafReader)context.reader(), (String)this.fieldName);
        int numOrds = this.docValues.getValueCount();
        int trueOrd = -2;
        for (int i = 0; i < numOrds; ++i) {
            BytesRef br = this.docValues.lookupOrd(i);
            if (br.length != 1 || br.bytes[br.offset] != 84) continue;
            trueOrd = i;
            break;
        }
        this.trueOrd = trueOrd;
    }

    @Override
    public void collect(int doc) throws IOException {
        this.exists = this.docValues.advanceExact(doc);
        if (this.exists) {
            this.value = this.trueOrd == this.docValues.ordValue();
        }
    }

    @Override
    public boolean getBoolean() {
        return this.value;
    }

    @Override
    public String getString() {
        return this.exists ? Boolean.toString(this.value) : null;
    }

    @Override
    public Object getObject() {
        return this.exists ? Boolean.valueOf(this.value) : null;
    }

    @Override
    public boolean exists() {
        return this.exists;
    }

    @Override
    public void streamBooleans(BooleanConsumer cons) {
        if (this.exists) {
            cons.accept(this.value);
        }
    }

    @Override
    public void streamStrings(Consumer<String> cons) {
        if (this.exists) {
            cons.accept(Boolean.toString(this.value));
        }
    }

    @Override
    public void streamObjects(Consumer<Object> cons) {
        if (this.exists) {
            cons.accept(this.value);
        }
    }

    @Override
    public ExpressionComparator<Boolean> getObjectComparator(String expression) {
        return new ExpressionComparator<Boolean>(expression);
    }
}

