/*
 * Decompiled with CFR 0.152.
 */
package org.jasypt.hibernate.encryptor;

import java.math.BigDecimal;
import org.jasypt.encryption.pbe.PBEBigDecimalEncryptor;
import org.jasypt.encryption.pbe.StandardPBEBigDecimalEncryptor;
import org.jasypt.encryption.pbe.config.PBEConfig;
import org.jasypt.exceptions.EncryptionInitializationException;
import org.jasypt.hibernate.encryptor.HibernatePBEEncryptorRegistry;
import org.jasypt.salt.SaltGenerator;

public final class HibernatePBEBigDecimalEncryptor {
    private String registeredName = null;
    private PBEBigDecimalEncryptor encryptor = null;
    private boolean encryptorSet = false;

    public HibernatePBEBigDecimalEncryptor() {
        this.encryptor = new StandardPBEBigDecimalEncryptor();
        this.encryptorSet = false;
    }

    HibernatePBEBigDecimalEncryptor(String registeredName, PBEBigDecimalEncryptor encryptor) {
        this.encryptor = encryptor;
        this.registeredName = registeredName;
        this.encryptorSet = true;
    }

    public PBEBigDecimalEncryptor getEncryptor() {
        return this.encryptor;
    }

    public void setEncryptor(PBEBigDecimalEncryptor encryptor) {
        if (this.encryptorSet) {
            throw new EncryptionInitializationException("An encryptor has been already set: no further configuration possible on hibernate wrapper");
        }
        this.encryptor = encryptor;
        this.encryptorSet = true;
    }

    public void setPassword(String password) {
        if (this.encryptorSet) {
            throw new EncryptionInitializationException("An encryptor has been already set: no further configuration possible on hibernate wrapper");
        }
        StandardPBEBigDecimalEncryptor standardPBEBigDecimalEncryptor = (StandardPBEBigDecimalEncryptor)this.encryptor;
        standardPBEBigDecimalEncryptor.setPassword(password);
    }

    public void setAlgorithm(String algorithm) {
        if (this.encryptorSet) {
            throw new EncryptionInitializationException("An encryptor has been already set: no further configuration possible on hibernate wrapper");
        }
        StandardPBEBigDecimalEncryptor standardPBEBigDecimalEncryptor = (StandardPBEBigDecimalEncryptor)this.encryptor;
        standardPBEBigDecimalEncryptor.setAlgorithm(algorithm);
    }

    public void setKeyObtentionIterations(int keyObtentionIterations) {
        if (this.encryptorSet) {
            throw new EncryptionInitializationException("An encryptor has been already set: no further configuration possible on hibernate wrapper");
        }
        StandardPBEBigDecimalEncryptor standardPBEBigDecimalEncryptor = (StandardPBEBigDecimalEncryptor)this.encryptor;
        standardPBEBigDecimalEncryptor.setKeyObtentionIterations(keyObtentionIterations);
    }

    public void setSaltGenerator(SaltGenerator saltGenerator) {
        if (this.encryptorSet) {
            throw new EncryptionInitializationException("An encryptor has been already set: no further configuration possible on hibernate wrapper");
        }
        StandardPBEBigDecimalEncryptor standardPBEBigDecimalEncryptor = (StandardPBEBigDecimalEncryptor)this.encryptor;
        standardPBEBigDecimalEncryptor.setSaltGenerator(saltGenerator);
    }

    public void setConfig(PBEConfig config) {
        if (this.encryptorSet) {
            throw new EncryptionInitializationException("An encryptor has been already set: no further configuration possible on hibernate wrapper");
        }
        StandardPBEBigDecimalEncryptor standardPBEBigDecimalEncryptor = (StandardPBEBigDecimalEncryptor)this.encryptor;
        standardPBEBigDecimalEncryptor.setConfig(config);
    }

    public BigDecimal encrypt(BigDecimal message) {
        if (this.encryptor == null) {
            throw new EncryptionInitializationException("Encryptor has not been set into Hibernate wrapper");
        }
        return this.encryptor.encrypt(message);
    }

    public BigDecimal decrypt(BigDecimal encryptedMessage) {
        if (this.encryptor == null) {
            throw new EncryptionInitializationException("Encryptor has not been set into Hibernate wrapper");
        }
        return this.encryptor.decrypt(encryptedMessage);
    }

    public void setRegisteredName(String registeredName) {
        if (this.registeredName != null) {
            HibernatePBEEncryptorRegistry.getInstance().unregisterHibernatePBEBigDecimalEncryptor(this.registeredName);
        }
        this.registeredName = registeredName;
        HibernatePBEEncryptorRegistry.getInstance().registerHibernatePBEBigDecimalEncryptor(this);
    }

    public String getRegisteredName() {
        return this.registeredName;
    }
}

