/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.apollo.openwire.codec.v6;

import java.io.IOException;
import org.apache.activemq.apollo.openwire.codec.BooleanStream;
import org.apache.activemq.apollo.openwire.codec.OpenWireFormat;
import org.apache.activemq.apollo.openwire.codec.v6.BaseCommandMarshaller;
import org.apache.activemq.apollo.openwire.command.DataStructure;
import org.apache.activemq.apollo.openwire.command.ReplayCommand;
import org.fusesource.hawtbuf.DataByteArrayInputStream;
import org.fusesource.hawtbuf.DataByteArrayOutputStream;

public class ReplayCommandMarshaller
extends BaseCommandMarshaller {
    public byte getDataStructureType() {
        return 65;
    }

    public DataStructure createObject() {
        return new ReplayCommand();
    }

    public void tightUnmarshal(OpenWireFormat wireFormat, Object o, DataByteArrayInputStream dataIn, BooleanStream bs) throws IOException {
        super.tightUnmarshal(wireFormat, o, dataIn, bs);
        ReplayCommand info = (ReplayCommand)o;
        info.setFirstNakNumber(dataIn.readInt());
        info.setLastNakNumber(dataIn.readInt());
    }

    public int tightMarshal1(OpenWireFormat wireFormat, Object o, BooleanStream bs) throws IOException {
        ReplayCommand info = (ReplayCommand)o;
        int rc = super.tightMarshal1(wireFormat, o, bs);
        return rc + 8;
    }

    public void tightMarshal2(OpenWireFormat wireFormat, Object o, DataByteArrayOutputStream dataOut, BooleanStream bs) throws IOException {
        super.tightMarshal2(wireFormat, o, dataOut, bs);
        ReplayCommand info = (ReplayCommand)o;
        dataOut.writeInt(info.getFirstNakNumber());
        dataOut.writeInt(info.getLastNakNumber());
    }

    public void looseUnmarshal(OpenWireFormat wireFormat, Object o, DataByteArrayInputStream dataIn) throws IOException {
        super.looseUnmarshal(wireFormat, o, dataIn);
        ReplayCommand info = (ReplayCommand)o;
        info.setFirstNakNumber(dataIn.readInt());
        info.setLastNakNumber(dataIn.readInt());
    }

    public void looseMarshal(OpenWireFormat wireFormat, Object o, DataByteArrayOutputStream dataOut) throws IOException {
        ReplayCommand info = (ReplayCommand)o;
        super.looseMarshal(wireFormat, o, dataOut);
        dataOut.writeInt(info.getFirstNakNumber());
        dataOut.writeInt(info.getLastNakNumber());
    }
}

