/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.apollo.openwire.command;

import java.util.Arrays;
import org.apache.activemq.apollo.filter.BooleanExpression;
import org.apache.activemq.apollo.filter.FilterException;
import org.apache.activemq.apollo.filter.Filterable;
import org.apache.activemq.apollo.openwire.command.BrokerId;
import org.apache.activemq.apollo.openwire.command.ConsumerInfo;
import org.apache.activemq.apollo.openwire.command.DataStructure;
import org.apache.activemq.apollo.openwire.command.Message;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NetworkBridgeFilter
implements DataStructure,
BooleanExpression {
    public static final byte DATA_STRUCTURE_TYPE = 91;
    static final Log LOG = LogFactory.getLog(NetworkBridgeFilter.class);
    private BrokerId networkBrokerId;
    private int networkTTL;

    public NetworkBridgeFilter() {
    }

    public NetworkBridgeFilter(BrokerId remoteBrokerPath, int networkTTL) {
        this.networkBrokerId = remoteBrokerPath;
        this.networkTTL = networkTTL;
    }

    public byte getDataStructureType() {
        return 91;
    }

    public boolean isMarshallAware() {
        return false;
    }

    public boolean matches(Filterable filterable) throws FilterException {
        return this.matchesForwardingFilter((Message)filterable);
    }

    public Object evaluate(Filterable filterable) throws FilterException {
        return this.matches(filterable) ? Boolean.TRUE : Boolean.FALSE;
    }

    protected boolean matchesForwardingFilter(Message message) {
        int hops;
        if (NetworkBridgeFilter.contains(message.getBrokerPath(), this.networkBrokerId)) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Message all ready routed once through this broker (" + this.networkBrokerId + "), path: " + Arrays.toString(message.getBrokerPath()) + " - ignoring: " + message));
            }
            return false;
        }
        int n = hops = message.getBrokerPath() == null ? 0 : message.getBrokerPath().length;
        if (hops >= this.networkTTL) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Message restricted to " + this.networkTTL + " network hops ignoring: " + message));
            }
            return false;
        }
        if (message.isAdvisory() && message.getDataStructure() != null && message.getDataStructure().getDataStructureType() == 5) {
            ConsumerInfo info = (ConsumerInfo)message.getDataStructure();
            int n2 = hops = info.getBrokerPath() == null ? 0 : info.getBrokerPath().length;
            if (hops >= this.networkTTL) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("ConsumerInfo advisory restricted to " + this.networkTTL + " network hops ignoring: " + message));
                }
                return false;
            }
        }
        return true;
    }

    public static boolean contains(BrokerId[] brokerPath, BrokerId brokerId) {
        if (brokerPath != null && brokerId != null) {
            for (int i = 0; i < brokerPath.length; ++i) {
                if (!brokerId.equals(brokerPath[i])) continue;
                return true;
            }
        }
        return false;
    }

    public int getNetworkTTL() {
        return this.networkTTL;
    }

    public void setNetworkTTL(int networkTTL) {
        this.networkTTL = networkTTL;
    }

    public BrokerId getNetworkBrokerId() {
        return this.networkBrokerId;
    }

    public void setNetworkBrokerId(BrokerId remoteBrokerPath) {
        this.networkBrokerId = remoteBrokerPath;
    }
}

