/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.hawtdispatch.transport;

import java.io.EOFException;
import java.io.IOException;
import java.net.SocketAddress;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.fusesource.hawtdispatch.CustomDispatchSource;
import org.fusesource.hawtdispatch.Dispatch;
import org.fusesource.hawtdispatch.DispatchQueue;
import org.fusesource.hawtdispatch.EventAggregator;
import org.fusesource.hawtdispatch.EventAggregators;
import org.fusesource.hawtdispatch.Retained;
import org.fusesource.hawtdispatch.Task;
import org.fusesource.hawtdispatch.TaskWrapper;
import org.fusesource.hawtdispatch.transport.PipeTransportServer;
import org.fusesource.hawtdispatch.transport.ProtocolCodec;
import org.fusesource.hawtdispatch.transport.Transport;
import org.fusesource.hawtdispatch.transport.TransportListener;

public class PipeTransport
implements Transport {
    private static final Object EOF_TOKEN = new Object();
    private final PipeTransportServer server;
    PipeTransport peer;
    private TransportListener listener;
    private SocketAddress remoteAddress;
    private AtomicBoolean stopping = new AtomicBoolean();
    private String name;
    private boolean marshal;
    private boolean trace;
    private DispatchQueue dispatchQueue;
    private CustomDispatchSource<Object, LinkedList<Object>> dispatchSource;
    private boolean connected;
    private long writeCounter = 0L;
    private long readCounter = 0L;
    private ProtocolCodec protocolCodec;
    int outbound = 0;
    int maxOutbound = 100;

    public PipeTransport(PipeTransportServer server) {
        this.server = server;
    }

    public DispatchQueue getDispatchQueue() {
        return this.dispatchQueue;
    }

    public void setDispatchQueue(DispatchQueue queue) {
        this.dispatchQueue = queue;
    }

    @Deprecated
    public void start(Runnable onCompleted) {
        this.start((Task)new TaskWrapper(onCompleted));
    }

    public void start(final Task onCompleted) {
        if (this.dispatchQueue == null) {
            throw new IllegalArgumentException("dispatchQueue is not set");
        }
        this.server.dispatchQueue.execute(new Task(){

            public void run() {
                PipeTransport.this.dispatchSource = Dispatch.createSource((EventAggregator)EventAggregators.linkedList(), (DispatchQueue)PipeTransport.this.dispatchQueue);
                PipeTransport.this.dispatchSource.setEventHandler(new Task(){

                    public void run() {
                        try {
                            final LinkedList commands = (LinkedList)PipeTransport.this.dispatchSource.getData();
                            for (Object o : commands) {
                                if (o == EOF_TOKEN) {
                                    throw new EOFException();
                                }
                                PipeTransport.this.readCounter++;
                                PipeTransport.this.listener.onTransportCommand(o);
                            }
                            PipeTransport.this.peer.dispatchQueue.execute(new Task(){

                                public void run() {
                                    PipeTransport.this.outbound -= commands.size();
                                    PipeTransport.this.drainInbound();
                                }
                            });
                        }
                        catch (IOException e) {
                            PipeTransport.this.listener.onTransportFailure(e);
                        }
                    }
                });
                if (PipeTransport.this.peer.dispatchSource != null) {
                    PipeTransport.this.fireConnected();
                    PipeTransport.this.peer.fireConnected();
                }
                if (onCompleted != null) {
                    onCompleted.run();
                }
            }
        });
    }

    private void fireConnected() {
        this.dispatchQueue.execute(new Task(){

            public void run() {
                PipeTransport.this.connected = true;
                PipeTransport.this.dispatchSource.resume();
                PipeTransport.this.listener.onTransportConnected();
                PipeTransport.this.drainInbound();
            }
        });
    }

    public void flush() {
        this.listener.onRefill();
    }

    @Deprecated
    public void stop(Runnable onCompleted) {
        this.stop((Task)new TaskWrapper(onCompleted));
    }

    public void stop(Task onCompleted) {
        if (this.connected) {
            this.peer.dispatchSource.merge(EOF_TOKEN);
        }
        if (this.dispatchSource != null) {
            this.dispatchSource.setCancelHandler(onCompleted);
            this.dispatchSource.cancel();
        }
        this.setDispatchQueue(null);
    }

    public boolean full() {
        return this.outbound >= this.maxOutbound;
    }

    public boolean offer(Object command) {
        if (!this.connected) {
            return false;
        }
        if (this.full()) {
            return false;
        }
        this.transmit(command);
        return true;
    }

    private void drainInbound() {
        if (!this.full()) {
            this.listener.onRefill();
        }
    }

    private void transmit(Object command) {
        ++this.writeCounter;
        ++this.outbound;
        this.peer.dispatchSource.merge(command);
    }

    public long getWriteCounter() {
        return this.writeCounter;
    }

    public long getReadCounter() {
        return this.readCounter;
    }

    public SocketAddress getLocalAddress() {
        return this.remoteAddress;
    }

    public SocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    public void suspendRead() {
        this.dispatchSource.suspend();
    }

    public void resumeRead() {
        this.dispatchSource.resume();
    }

    public void setRemoteAddress(final String remoteAddress) {
        this.remoteAddress = new SocketAddress(){

            public String toString() {
                return remoteAddress;
            }
        };
        if (this.name == null) {
            this.name = remoteAddress;
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public TransportListener getTransportListener() {
        return this.listener;
    }

    public void setTransportListener(TransportListener transportListener) {
        this.listener = transportListener;
    }

    public ProtocolCodec getProtocolCodec() {
        return this.protocolCodec;
    }

    public void setProtocolCodec(ProtocolCodec protocolCodec) {
        this.protocolCodec = protocolCodec;
    }

    public boolean isTrace() {
        return this.trace;
    }

    public void setTrace(boolean trace) {
        this.trace = trace;
    }

    public boolean isMarshal() {
        return this.marshal;
    }

    public void setMarshal(boolean marshall) {
        this.marshal = marshall;
    }

    public boolean isConnected() {
        return !this.stopping.get();
    }

    public boolean isClosed() {
        return false;
    }

    static final class OneWay {
        final Object command;
        final Retained retained;

        public OneWay(Object command, Retained retained) {
            this.command = command;
            this.retained = retained;
        }
    }
}

