/*
 * Decompiled with CFR 0.152.
 */
package com.gentlyweb.utils;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import javax.activation.DataSource;

public class URLDataSource
implements DataSource {
    private URL url = null;
    private String contentType = "text/plain";

    public URLDataSource(URL url) {
        this.url = url;
    }

    public InputStream getInputStream() throws IOException {
        if (this.url == null) {
            throw new IOException("No URL provided");
        }
        URLConnection urlC = this.url.openConnection();
        urlC.setDoInput(true);
        urlC.connect();
        this.contentType = urlC.getContentType();
        return new BufferedInputStream(urlC.getInputStream());
    }

    public OutputStream getOutputStream() throws IOException {
        throw new IOException("Output not supported");
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getName() {
        return "URL DataSource for sending only";
    }
}

